/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.griffin.SqlException;
import io.questdb.griffin.engine.groupby.MicroTimestampSampler;
import io.questdb.griffin.engine.groupby.MonthTimestampSampler;
import io.questdb.griffin.engine.groupby.TimestampSampler;
import io.questdb.griffin.engine.groupby.YearTimestampSampler;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import org.jetbrains.annotations.NotNull;

public final class TimestampSamplerFactory {
    public static TimestampSampler getInstance(CharSequence cs, int position) throws SqlException {
        int k = -1;
        if (cs == null) {
            throw SqlException.$(position, "missing interval");
        }
        int len = cs.length();
        for (int i = 0; i < len; ++i) {
            char c = cs.charAt(i);
            if (c >= '0' && c <= '9') continue;
            k = i;
            break;
        }
        if (k == -1) {
            throw SqlException.$(position + len, "expected interval qualifier");
        }
        if (k + 1 < len) {
            throw SqlException.$(position + k, "expected single letter qualifier");
        }
        try {
            int n;
            if (k == 0) {
                n = 1;
            } else {
                n = Numbers.parseInt(cs, 0, k);
                if (n == 0) {
                    throw SqlException.$(position, "zero is not a valid sample value");
                }
            }
            return TimestampSamplerFactory.createTimestampSampler(n, cs.charAt(k), position + k);
        }
        catch (NumericException ignore) {
            assert (false);
            throw SqlException.$(position + k, "unsupported interval qualifier");
        }
    }

    public static TimestampSampler getInstance(long period, CharSequence units, int position) throws SqlException {
        if (units.length() == 1) {
            return TimestampSamplerFactory.createTimestampSampler(period, units.charAt(0), position);
        }
        throw SqlException.$(position, "expected one character interval qualifier");
    }

    @NotNull
    private static TimestampSampler createTimestampSampler(long interval, char timeUnit, int position) throws SqlException {
        switch (timeUnit) {
            case 'U': {
                return new MicroTimestampSampler(interval);
            }
            case 'T': {
                return new MicroTimestampSampler(1000L * interval);
            }
            case 's': {
                return new MicroTimestampSampler(1000000L * interval);
            }
            case 'm': {
                return new MicroTimestampSampler(60000000L * interval);
            }
            case 'h': {
                return new MicroTimestampSampler(3600000000L * interval);
            }
            case 'd': {
                return new MicroTimestampSampler(86400000000L * interval);
            }
            case 'M': {
                return new MonthTimestampSampler((int)interval);
            }
            case 'y': {
                return new YearTimestampSampler((int)interval);
            }
        }
        throw SqlException.$(position, "unsupported interval qualifier");
    }
}

