/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.SymbolMapReader;
import io.questdb.cairo.sql.DataFrameCursorFactory;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.engine.table.AbstractDeferredTreeSetRecordCursorFactory;
import io.questdb.griffin.engine.table.LatestByValuesIndexedFilteredRecordCursor;
import io.questdb.griffin.engine.table.LatestByValuesIndexedRecordCursor;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LatestByValuesIndexedFilteredRecordCursorFactory
extends AbstractDeferredTreeSetRecordCursorFactory {
    private final Function filter;

    public LatestByValuesIndexedFilteredRecordCursorFactory(@NotNull CairoConfiguration configuration, @NotNull RecordMetadata metadata, @NotNull DataFrameCursorFactory dataFrameCursorFactory, int columnIndex, ObjList<Function> keyValueFuncs, SymbolMapReader symbolMapReader, @Nullable Function filter, @NotNull IntList columnIndexes) {
        super(configuration, metadata, dataFrameCursorFactory, columnIndex, keyValueFuncs, symbolMapReader);
        this.cursor = filter != null ? new LatestByValuesIndexedFilteredRecordCursor(columnIndex, this.rows, this.symbolKeys, this.deferredSymbolKeys, filter, columnIndexes) : new LatestByValuesIndexedRecordCursor(columnIndex, this.symbolKeys, this.deferredSymbolKeys, this.rows, columnIndexes);
        this.filter = filter;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return true;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Index backward scan").meta("on").putColumnName(this.columnIndex);
        sink.optAttr((CharSequence)"filter", this.filter);
        sink.attr("symbolFilter").putColumnName(this.columnIndex).val(" in ");
        if (this.symbolKeys.size() > 0) {
            sink.val(this.symbolKeys);
        }
        if (this.deferredSymbolFuncs != null && this.deferredSymbolFuncs.size() > 0) {
            if (this.symbolKeys.size() > 0) {
                sink.val(" or ").putColumnName(this.columnIndex).val(" in ");
            }
            sink.val(this.deferredSymbolFuncs);
        }
        sink.child(this.dataFrameCursorFactory);
    }

    @Override
    protected void _close() {
        super._close();
        Misc.free(this.filter);
    }
}

