/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.datetime.microtime;

import io.questdb.std.ConcurrentHashMap;
import io.questdb.std.datetime.DateFormat;
import io.questdb.std.datetime.microtime.TimestampFormatCompiler;
import java.util.function.Function;

public class TimestampFormatFactory {
    private static final ThreadLocal<TimestampFormatCompiler> tlCompiler = ThreadLocal.withInitial(TimestampFormatCompiler::new);
    private static final Function<CharSequence, DateFormat> mapper = TimestampFormatFactory::map;
    private final ConcurrentHashMap<DateFormat> cache = new ConcurrentHashMap();

    public DateFormat get(CharSequence pattern) {
        return this.cache.computeIfAbsent(pattern, mapper);
    }

    private static DateFormat map(CharSequence value) {
        return tlCompiler.get().compile(value);
    }
}

