/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.uuid5;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.ArrayUtils;

public class Uuid5Util {
    public static String fromString(String value, String namespace) {
        UUID nsUUID = namespace == null ? new UUID(0L, 0L) : UUID.fromString(namespace);
        byte[] nsBytes = ByteBuffer.wrap(new byte[16]).putLong(nsUUID.getMostSignificantBits()).putLong(nsUUID.getLeastSignificantBits()).array();
        byte[] subjectBytes = value.getBytes();
        byte[] nameBytes = ArrayUtils.addAll((byte[])nsBytes, (byte[])subjectBytes);
        byte[] nameHash = DigestUtils.sha1((byte[])nameBytes);
        byte[] uuidBytes = Arrays.copyOf(nameHash, 16);
        uuidBytes[6] = (byte)(uuidBytes[6] & 0xF);
        uuidBytes[6] = (byte)(uuidBytes[6] | 0x50);
        uuidBytes[8] = (byte)(uuidBytes[8] & 0x3F);
        uuidBytes[8] = (byte)(uuidBytes[8] | 0x80);
        String encoded = Hex.encodeHexString((byte[])Objects.requireNonNull(uuidBytes));
        StringBuffer sb = new StringBuffer(encoded);
        while (sb.length() != 32) {
            sb.insert(0, "0");
        }
        sb.ensureCapacity(32);
        sb.insert(8, '-');
        sb.insert(13, '-');
        sb.insert(18, '-');
        sb.insert(23, '-');
        return sb.toString();
    }
}

