/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.flow.diff;

import org.apache.nifi.flow.ScheduledState;
import org.apache.nifi.flow.VersionedComponent;
import org.apache.nifi.registry.flow.diff.DifferenceDescriptor;
import org.apache.nifi.registry.flow.diff.DifferenceType;

public class EvolvingDifferenceDescriptor
implements DifferenceDescriptor {
    @Override
    public String describeDifference(DifferenceType type, String flowAName, String flowBName, VersionedComponent componentA, VersionedComponent componentB, String fieldName, Object valueA, Object valueB) {
        String description;
        switch (type) {
            case COMPONENT_ADDED: {
                description = String.format("%s with ID %s was added to flow", componentB.getComponentType().getTypeName(), componentB.getIdentifier());
                break;
            }
            case COMPONENT_REMOVED: {
                description = String.format("%s with ID %s was removed from flow", componentA.getComponentType().getTypeName(), componentA.getIdentifier());
                break;
            }
            case SCHEDULED_STATE_CHANGED: {
                if (valueB == ScheduledState.RUNNING) {
                    description = String.format("%s was started", componentB.getComponentType().getTypeName());
                    break;
                }
                if (valueB == ScheduledState.ENABLED) {
                    description = String.format("%s was enabled", componentB.getComponentType().getTypeName());
                    break;
                }
                description = String.format("%s was disabled", componentA.getComponentType().getTypeName());
                break;
            }
            case PROPERTY_ADDED: {
                description = String.format("Property '%s' was added to %s with ID %s", fieldName, componentB.getComponentType().getTypeName(), componentB.getIdentifier());
                break;
            }
            case PROPERTY_REMOVED: {
                description = String.format("Property '%s' was removed from %s with ID %s", fieldName, componentA.getComponentType().getTypeName(), componentA.getIdentifier());
                break;
            }
            case PROPERTY_PARAMETERIZED: {
                description = String.format("Property '%s' was parameterized", fieldName);
                break;
            }
            case PROPERTY_PARAMETERIZATION_REMOVED: {
                description = String.format("Property '%s' is no longer a parameter reference", fieldName);
                break;
            }
            case VARIABLE_ADDED: {
                description = String.format("Variable '%s' was added to Process Group with ID %s", fieldName, componentB.getIdentifier());
                break;
            }
            case VARIABLE_REMOVED: {
                description = String.format("Variable '%s' was removed from Process Group with ID %s", fieldName, componentA.getIdentifier());
                break;
            }
            default: {
                description = String.format("%s for %s with ID %s from '%s' to '%s'", type.getDescription(), componentA.getComponentType().getTypeName(), componentA.getIdentifier(), valueA, valueB);
            }
        }
        return description;
    }
}

