/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.remote;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.nifi.authorization.AuthorizationResult;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.resource.DataTransferAuthorizable;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.StandardNiFiUser;
import org.apache.nifi.authorization.util.IdentityMapping;
import org.apache.nifi.authorization.util.IdentityMappingUtil;
import org.apache.nifi.authorization.util.UserGroupUtil;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.ConnectableType;
import org.apache.nifi.controller.AbstractPort;
import org.apache.nifi.controller.ProcessScheduler;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.events.BulletinFactory;
import org.apache.nifi.events.EventReporter;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessSessionFactory;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.FlowFileAccessException;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.remote.Peer;
import org.apache.nifi.remote.PortAuthorizationResult;
import org.apache.nifi.remote.PublicPort;
import org.apache.nifi.remote.TransferDirection;
import org.apache.nifi.remote.codec.FlowFileCodec;
import org.apache.nifi.remote.exception.BadRequestException;
import org.apache.nifi.remote.exception.NotAuthorizedException;
import org.apache.nifi.remote.exception.ProtocolException;
import org.apache.nifi.remote.exception.RequestExpiredException;
import org.apache.nifi.remote.exception.TransmissionDisabledException;
import org.apache.nifi.remote.protocol.CommunicationsSession;
import org.apache.nifi.remote.protocol.ServerProtocol;
import org.apache.nifi.reporting.BulletinRepository;
import org.apache.nifi.reporting.ComponentType;
import org.apache.nifi.reporting.Severity;
import org.apache.nifi.scheduling.SchedulingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardPublicPort
extends AbstractPort
implements PublicPort {
    private static final String CATEGORY = "Site to Site";
    private static final Logger logger = LoggerFactory.getLogger(StandardPublicPort.class);
    private final AtomicReference<Set<String>> groupAccessControl = new AtomicReference(new HashSet());
    private final AtomicReference<Set<String>> userAccessControl = new AtomicReference(new HashSet());
    private final boolean secure;
    private final Authorizer authorizer;
    private final List<IdentityMapping> identityMappings;
    private TransferDirection direction;
    private final BulletinRepository bulletinRepository;
    private final EventReporter eventReporter;
    private final ProcessScheduler scheduler;
    private final Set<Relationship> relationships;
    private final BlockingQueue<FlowFileRequest> requestQueue = new ArrayBlockingQueue<FlowFileRequest>(1000);
    private final Set<FlowFileRequest> activeRequests = new HashSet<FlowFileRequest>();
    private final Lock requestLock = new ReentrantLock();
    private boolean shutdown = false;

    public StandardPublicPort(String id, String name, final TransferDirection direction, ConnectableType type, Authorizer authorizer, final BulletinRepository bulletinRepository, ProcessScheduler scheduler, boolean secure, String yieldPeriod, List<IdentityMapping> identityMappings) {
        super(id, name, type, scheduler);
        this.setSchedulingPeriod("1 nanos");
        this.authorizer = authorizer;
        this.secure = secure;
        this.identityMappings = identityMappings;
        this.bulletinRepository = bulletinRepository;
        this.scheduler = scheduler;
        this.direction = direction;
        this.setYieldPeriod(yieldPeriod);
        this.eventReporter = new EventReporter(){
            private static final long serialVersionUID = 1L;

            public void reportEvent(Severity severity, String category, String message) {
                String groupId = StandardPublicPort.this.getProcessGroup().getIdentifier();
                String groupName = StandardPublicPort.this.getProcessGroup().getName();
                String sourceId = StandardPublicPort.this.getIdentifier();
                String sourceName = StandardPublicPort.this.getName();
                ComponentType componentType = direction == TransferDirection.RECEIVE ? ComponentType.INPUT_PORT : ComponentType.OUTPUT_PORT;
                bulletinRepository.addBulletin(BulletinFactory.createBulletin((String)groupId, (String)groupName, (String)sourceId, (ComponentType)componentType, (String)sourceName, (String)category, (String)severity.name(), (String)message));
            }
        };
        this.relationships = direction == TransferDirection.RECEIVE ? Collections.singleton(AbstractPort.PORT_RELATIONSHIP) : Collections.emptySet();
    }

    public Collection<Relationship> getRelationships() {
        return this.relationships;
    }

    public boolean isTriggerWhenEmpty() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTrigger(ProcessContext context, ProcessSessionFactory sessionFactory) {
        FlowFileRequest flowFileRequest;
        try {
            flowFileRequest = this.requestQueue.poll(1L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ie) {
            return;
        }
        if (flowFileRequest == null) {
            context.yield();
            return;
        }
        flowFileRequest.setServiceBegin();
        this.requestLock.lock();
        try {
            CommunicationsSession commsSession;
            if (this.shutdown && (commsSession = flowFileRequest.getPeer().getCommunicationsSession()) != null) {
                commsSession.interrupt();
            }
            this.activeRequests.add(flowFileRequest);
        }
        finally {
            this.requestLock.unlock();
        }
        ProcessSession session = sessionFactory.createSession();
        try {
            this.onTrigger(context, session, flowFileRequest);
        }
        catch (TransmissionDisabledException e) {
            session.rollback();
        }
        catch (Exception e) {
            logger.error("{} Failed to process data", (Object)this, (Object)e);
            if (logger.isDebugEnabled()) {
                logger.error("", (Throwable)e);
            }
            session.rollback();
        }
        finally {
            this.requestLock.lock();
            try {
                this.activeRequests.remove(flowFileRequest);
            }
            finally {
                this.requestLock.unlock();
            }
        }
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
    }

    private void onTrigger(ProcessContext context, ProcessSession session, FlowFileRequest flowFileRequest) {
        int transferCount;
        ServerProtocol protocol = flowFileRequest.getProtocol();
        BlockingQueue<ProcessingResult> responseQueue = flowFileRequest.getResponseQueue();
        if (flowFileRequest.isExpired()) {
            String message = String.format("%s Cannot service request from %s because the request has timed out", new Object[]{this, flowFileRequest.getPeer()});
            logger.warn(message);
            this.eventReporter.reportEvent(Severity.WARNING, CATEGORY, message);
            responseQueue.add(new ProcessingResult((Exception)new RequestExpiredException()));
            return;
        }
        Peer peer = flowFileRequest.getPeer();
        CommunicationsSession commsSession = peer.getCommunicationsSession();
        String sourceDn = commsSession.getUserDn();
        logger.debug("{} Servicing request for {} (DN={})", new Object[]{this, peer, sourceDn});
        PortAuthorizationResult authorizationResult = this.checkUserAuthorization(sourceDn);
        if (!authorizationResult.isAuthorized()) {
            String message = String.format("%s Cannot service request from %s (DN=%s) because peer is not authorized to communicate with this port: %s", new Object[]{this, flowFileRequest.getPeer(), flowFileRequest.getPeer().getCommunicationsSession().getUserDn(), authorizationResult.getExplanation()});
            logger.error(message);
            this.eventReporter.reportEvent(Severity.ERROR, CATEGORY, message);
            responseQueue.add(new ProcessingResult((Exception)new NotAuthorizedException(authorizationResult.getExplanation())));
            return;
        }
        FlowFileCodec codec = protocol.getPreNegotiatedCodec();
        if (codec == null) {
            responseQueue.add(new ProcessingResult((Exception)new BadRequestException("None of the supported FlowFile Codecs supplied is compatible with this instance")));
            return;
        }
        try {
            transferCount = this.getConnectableType() == ConnectableType.INPUT_PORT ? this.receiveFlowFiles(context, session, codec, flowFileRequest) : this.transferFlowFiles(context, session, codec, flowFileRequest);
        }
        catch (Exception e) {
            session.rollback();
            responseQueue.add(new ProcessingResult(e));
            return;
        }
        responseQueue.add(new ProcessingResult(transferCount));
    }

    private int transferFlowFiles(ProcessContext context, ProcessSession session, FlowFileCodec codec, FlowFileRequest request) throws IOException {
        return request.getProtocol().transferFlowFiles(request.getPeer(), context, session, codec);
    }

    private int receiveFlowFiles(ProcessContext context, ProcessSession session, FlowFileCodec codec, FlowFileRequest receiveRequest) throws IOException {
        return receiveRequest.getProtocol().receiveFlowFiles(receiveRequest.getPeer(), context, session, codec);
    }

    public boolean isValid() {
        if (this.getConnectableType() == ConnectableType.INPUT_PORT) {
            Set availableConnections = this.getConnections(Relationship.ANONYMOUS);
            return !availableConnections.isEmpty();
        }
        return true;
    }

    public Collection<ValidationResult> getValidationErrors() {
        ArrayList<ValidationResult> validationErrors = new ArrayList<ValidationResult>();
        if (this.getScheduledState() == ScheduledState.STOPPED && !this.isValid()) {
            ValidationResult error = new ValidationResult.Builder().explanation(String.format("Output connection for port '%s' is not defined.", this.getName())).subject(String.format("Port '%s'", this.getName())).valid(false).build();
            validationErrors.add(error);
        }
        return validationErrors;
    }

    public boolean isTransmitting() {
        if (!this.isRunning()) {
            return false;
        }
        this.requestLock.lock();
        try {
            boolean bl = !this.activeRequests.isEmpty();
            return bl;
        }
        finally {
            this.requestLock.unlock();
        }
    }

    public void setGroupAccessControl(Set<String> groups) {
        this.groupAccessControl.set(new HashSet(Objects.requireNonNull(groups)));
    }

    public Set<String> getGroupAccessControl() {
        return Collections.unmodifiableSet(this.groupAccessControl.get());
    }

    public void setUserAccessControl(Set<String> users) {
        this.userAccessControl.set(new HashSet(Objects.requireNonNull(users)));
    }

    public Set<String> getUserAccessControl() {
        return Collections.unmodifiableSet(this.userAccessControl.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        super.shutdown();
        this.requestLock.lock();
        try {
            this.shutdown = true;
            for (FlowFileRequest request : this.activeRequests) {
                CommunicationsSession commsSession = request.getPeer().getCommunicationsSession();
                if (commsSession == null) continue;
                commsSession.interrupt();
            }
        }
        finally {
            this.requestLock.unlock();
        }
    }

    public void onSchedulingStart() {
        super.onSchedulingStart();
        this.requestLock.lock();
        try {
            this.shutdown = false;
        }
        finally {
            this.requestLock.unlock();
        }
    }

    public PortAuthorizationResult checkUserAuthorization(String dn) {
        if (!this.secure) {
            return new StandardPortAuthorizationResult(true, "Site-to-Site is not Secure");
        }
        if (dn == null) {
            String message = String.format("%s authorization failed for user %s because the DN is unknown", new Object[]{this, dn});
            logger.warn(message);
            this.eventReporter.reportEvent(Severity.WARNING, CATEGORY, message);
            return new StandardPortAuthorizationResult(false, "User DN is not known");
        }
        String identity = IdentityMappingUtil.mapIdentity((String)dn, this.identityMappings);
        Set groups = UserGroupUtil.getUserGroups((Authorizer)this.authorizer, (String)identity);
        return this.checkUserAuthorization((NiFiUser)new StandardNiFiUser.Builder().identity(identity).groups(groups).build());
    }

    public PortAuthorizationResult checkUserAuthorization(NiFiUser user) {
        if (!this.secure) {
            return new StandardPortAuthorizationResult(true, "Site-to-Site is not Secure");
        }
        if (user == null) {
            String message = String.format("%s authorization failed because the user is unknown", new Object[]{this});
            logger.warn(message);
            this.eventReporter.reportEvent(Severity.WARNING, CATEGORY, message);
            return new StandardPortAuthorizationResult(false, "User is not known");
        }
        DataTransferAuthorizable dataTransferAuthorizable = new DataTransferAuthorizable((Authorizable)this);
        AuthorizationResult result = dataTransferAuthorizable.checkAuthorization(this.authorizer, RequestAction.WRITE, user);
        if (!AuthorizationResult.Result.Approved.equals((Object)result.getResult())) {
            String message = String.format("%s authorization failed for user %s because %s", new Object[]{this, user.getIdentity(), result.getExplanation()});
            logger.warn(message);
            this.eventReporter.reportEvent(Severity.WARNING, CATEGORY, message);
            return new StandardPortAuthorizationResult(false, message);
        }
        return new StandardPortAuthorizationResult(true, "User is Authorized");
    }

    public int receiveFlowFiles(Peer peer, ServerProtocol serverProtocol) throws NotAuthorizedException, BadRequestException, RequestExpiredException {
        if (this.getConnectableType() != ConnectableType.INPUT_PORT) {
            throw new IllegalStateException("Cannot receive FlowFiles because this port is not an Input Port");
        }
        if (!this.isRunning()) {
            throw new IllegalStateException("Port not running");
        }
        try {
            FlowFileRequest request = new FlowFileRequest(peer, serverProtocol);
            if (!this.requestQueue.offer(request)) {
                throw new RequestExpiredException();
            }
            this.scheduler.registerEvent((Connectable)this);
            ProcessingResult result = null;
            try {
                while (!request.waitForService(100L, TimeUnit.MILLISECONDS)) {
                    if (!request.isExpired()) continue;
                    this.requestQueue.remove(request);
                    throw new SocketTimeoutException("Read timed out");
                }
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new ProcessException("Interrupted while waiting for site-to-site request to be serviced", (Throwable)ie);
            }
            result = request.getResponseQueue().take();
            Exception problem = result.getProblem();
            if (problem == null) {
                return result.getFileCount();
            }
            throw problem;
        }
        catch (BadRequestException | NotAuthorizedException | RequestExpiredException e) {
            throw e;
        }
        catch (ProtocolException e) {
            throw new BadRequestException((Throwable)e);
        }
        catch (IOException | FlowFileAccessException e) {
            String REQUEST_TOO_LONG_MSG = "Request input stream longer than";
            if (e.getMessage() != null && e.getMessage().contains("Request input stream longer than")) {
                logger.error("The content length filter (configured with {}) is blocking the site-to-site connection: {}", (Object)"nifi.web.max.content.size", (Object)e.getMessage());
                throw new BadRequestException(e);
            }
            throw new ProcessException(e);
        }
        catch (InterruptedException e) {
            logger.error("The NiFi DoS filter has interrupted a long running session. If this is undesired, configure a longer web request timeout value in nifi.properties using '{}'", (Object)"nifi.web.request.timeout");
            throw new ProcessException((Throwable)e);
        }
        catch (Exception e) {
            throw new ProcessException((Throwable)e);
        }
    }

    public int transferFlowFiles(Peer peer, ServerProtocol serverProtocol) throws NotAuthorizedException, BadRequestException, RequestExpiredException {
        if (this.getConnectableType() != ConnectableType.OUTPUT_PORT) {
            throw new IllegalStateException("Cannot send FlowFiles because this port is not an Output Port");
        }
        if (!this.isRunning()) {
            throw new IllegalStateException("Port not running");
        }
        try {
            FlowFileRequest request = new FlowFileRequest(peer, serverProtocol);
            if (!this.requestQueue.offer(request)) {
                throw new RequestExpiredException();
            }
            this.scheduler.registerEvent((Connectable)this);
            try {
                while (!request.waitForService(100L, TimeUnit.MILLISECONDS)) {
                    if (!request.isExpired()) continue;
                    this.requestQueue.remove(request);
                    throw new SocketTimeoutException("Read timed out");
                }
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new ProcessException("Interrupted while waiting for Site-to-Site request to be serviced", (Throwable)ie);
            }
            ProcessingResult result = request.getResponseQueue().take();
            Exception problem = result.getProblem();
            if (problem == null) {
                return result.getFileCount();
            }
            throw problem;
        }
        catch (BadRequestException | NotAuthorizedException | RequestExpiredException e) {
            throw e;
        }
        catch (ProtocolException e) {
            throw new BadRequestException((Throwable)e);
        }
        catch (Exception e) {
            throw new ProcessException((Throwable)e);
        }
    }

    public SchedulingStrategy getSchedulingStrategy() {
        return SchedulingStrategy.TIMER_DRIVEN;
    }

    public boolean isSideEffectFree() {
        return false;
    }

    public String getComponentType() {
        return "PublicPort";
    }

    public TransferDirection getDirection() {
        return this.direction;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("id", (Object)this.getIdentifier()).append("name", (Object)this.getName()).toString();
    }

    private static class FlowFileRequest {
        private final Peer peer;
        private final ServerProtocol protocol;
        private final BlockingQueue<ProcessingResult> queue;
        private final long creationTime;
        private final AtomicBoolean beingServiced = new AtomicBoolean(false);

        public FlowFileRequest(Peer peer, ServerProtocol protocol) {
            this.creationTime = System.currentTimeMillis();
            this.peer = peer;
            this.protocol = protocol;
            this.queue = new ArrayBlockingQueue<ProcessingResult>(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setServiceBegin() {
            this.beingServiced.set(true);
            FlowFileRequest flowFileRequest = this;
            synchronized (flowFileRequest) {
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean waitForService(long duration, TimeUnit timeUnit) throws InterruptedException {
            long latestWaitTime = System.nanoTime() + timeUnit.toNanos(duration);
            while (!this.beingServiced.get()) {
                long nanosToWait = latestWaitTime - System.nanoTime();
                if (nanosToWait <= 0L) {
                    return false;
                }
                if (this.isExpired()) {
                    return false;
                }
                FlowFileRequest flowFileRequest = this;
                synchronized (flowFileRequest) {
                    TimeUnit.NANOSECONDS.timedWait(this, nanosToWait);
                }
            }
            return true;
        }

        public BlockingQueue<ProcessingResult> getResponseQueue() {
            return this.queue;
        }

        public Peer getPeer() {
            return this.peer;
        }

        public ServerProtocol getProtocol() {
            return this.protocol;
        }

        public boolean isExpired() {
            long expiration = this.protocol.getRequestExpiration() * 2L;
            if (expiration <= 0L) {
                return false;
            }
            if (expiration < 500L) {
                expiration = 500L;
            }
            return System.currentTimeMillis() > this.creationTime + expiration;
        }
    }

    private static class ProcessingResult {
        private final int fileCount;
        private final Exception problem;

        public ProcessingResult(int fileCount) {
            this.fileCount = fileCount;
            this.problem = null;
        }

        public ProcessingResult(Exception problem) {
            this.fileCount = 0;
            this.problem = problem;
        }

        public Exception getProblem() {
            return this.problem;
        }

        public int getFileCount() {
            return this.fileCount;
        }
    }

    public static class StandardPortAuthorizationResult
    implements PortAuthorizationResult {
        private final boolean isAuthorized;
        private final String explanation;

        public StandardPortAuthorizationResult(boolean isAuthorized, String explanation) {
            this.isAuthorized = isAuthorized;
            this.explanation = explanation;
        }

        public boolean isAuthorized() {
            return this.isAuthorized;
        }

        public String getExplanation() {
            return this.explanation;
        }
    }
}

