/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.inheritance;

import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.cluster.protocol.DataFlow;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.inheritance.FlowInheritability;
import org.apache.nifi.controller.inheritance.FlowInheritabilityCheck;

public class MissingComponentsCheck
implements FlowInheritabilityCheck {
    @Override
    public FlowInheritability checkInheritability(DataFlow existingFlow, DataFlow proposedFlow, FlowController flowController) {
        if (existingFlow == null) {
            return FlowInheritability.inheritable();
        }
        HashSet existingMissingComponents = new HashSet(existingFlow.getMissingComponents());
        existingMissingComponents.removeAll(proposedFlow.getMissingComponents());
        if (existingMissingComponents.size() > 0) {
            String missingIds = StringUtils.join(existingMissingComponents, (String)",");
            return FlowInheritability.notInheritable("Current flow has missing components that are not considered missing in the proposed flow (" + missingIds + ")");
        }
        HashSet proposedMissingComponents = new HashSet(proposedFlow.getMissingComponents());
        proposedMissingComponents.removeAll(existingFlow.getMissingComponents());
        if (proposedMissingComponents.size() > 0) {
            String missingIds = StringUtils.join(proposedMissingComponents, (String)",");
            return FlowInheritability.notInheritable("Proposed flow has missing components that are not considered missing in the current flow (" + missingIds + ")");
        }
        return FlowInheritability.inheritable();
    }
}

