/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.status.history;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.nifi.controller.status.history.EmptyStatusSnapshot;
import org.apache.nifi.controller.status.history.MetricDescriptor;
import org.apache.nifi.controller.status.history.StatusSnapshot;

public class MetricRollingBuffer {
    private final int capacity;
    private StatusSnapshot[] snapshots;
    private int writeIndex = 0;
    private int readIndex;
    private boolean readExhausted;
    private int count = 0;

    public MetricRollingBuffer(int maxCapacity) {
        this.capacity = maxCapacity;
    }

    public void update(StatusSnapshot snapshot) {
        if (snapshot == null) {
            return;
        }
        if (this.snapshots == null) {
            this.snapshots = new StatusSnapshot[Math.min(this.capacity, 16)];
        }
        if (this.snapshots[this.writeIndex] == null) {
            ++this.count;
        }
        this.snapshots[this.writeIndex++] = snapshot;
        if (this.writeIndex >= this.snapshots.length) {
            if (this.snapshots.length < this.capacity) {
                this.grow();
            } else {
                this.writeIndex = 0;
            }
        }
    }

    public int size() {
        return this.count;
    }

    public void expireBefore(Date date) {
        if (this.snapshots == null) {
            return;
        }
        int readIndex = this.writeIndex;
        for (int i = 0; i < this.snapshots.length; ++i) {
            StatusSnapshot snapshot = this.snapshots[readIndex];
            if (snapshot == null) {
                if (++readIndex < this.snapshots.length) continue;
                readIndex = 0;
                continue;
            }
            Date snapshotTimestamp = snapshot.getTimestamp();
            if (snapshotTimestamp.after(date)) break;
            this.snapshots[readIndex] = null;
            --this.count;
            if (++readIndex < this.snapshots.length) continue;
            readIndex = 0;
        }
        if (this.count < this.snapshots.length / 4 || this.snapshots.length - this.count > 128) {
            this.compact();
        }
    }

    private void grow() {
        int initialSize = this.snapshots.length;
        int newSize = Math.min(this.capacity, this.snapshots.length + 64);
        StatusSnapshot[] newArray = new StatusSnapshot[newSize];
        System.arraycopy(this.snapshots, 0, newArray, 0, this.snapshots.length);
        this.snapshots = newArray;
        this.writeIndex = initialSize;
    }

    private void compact() {
        StatusSnapshot[] newArray = new StatusSnapshot[this.count + 1];
        int insertionIndex = 0;
        int readIndex = this.writeIndex;
        for (int i = 0; i < this.snapshots.length; ++i) {
            StatusSnapshot snapshot = this.snapshots[readIndex];
            if (snapshot != null) {
                newArray[insertionIndex++] = snapshot;
            }
            if (++readIndex < this.snapshots.length) continue;
            readIndex = 0;
        }
        this.snapshots = newArray;
        this.writeIndex = this.count;
        this.count = newArray.length - 1;
    }

    public List<StatusSnapshot> getSnapshots(List<Date> timestamps, boolean includeCounters, Set<MetricDescriptor<?>> defaultStatusMetrics) {
        if (this.snapshots == null) {
            return Collections.emptyList();
        }
        ArrayList<StatusSnapshot> list = new ArrayList<StatusSnapshot>(this.snapshots.length);
        this.resetRead();
        for (Date timestamp : timestamps) {
            StatusSnapshot snapshot = this.getSnapshotForTimestamp(timestamp);
            if (snapshot == null) {
                list.add(new EmptyStatusSnapshot(timestamp, defaultStatusMetrics));
                continue;
            }
            list.add(includeCounters ? snapshot : snapshot.withoutCounters());
        }
        return list;
    }

    private StatusSnapshot getSnapshotForTimestamp(Date timestamp) {
        while (!this.readExhausted) {
            StatusSnapshot snapshot = this.snapshots[this.readIndex];
            if (snapshot == null) {
                this.advanceRead();
                continue;
            }
            Date snapshotTimestamp = snapshot.getTimestamp();
            if (snapshotTimestamp.before(timestamp)) {
                this.advanceRead();
                continue;
            }
            if (snapshotTimestamp.after(timestamp)) {
                return null;
            }
            this.advanceRead();
            return snapshot;
        }
        return null;
    }

    private void resetRead() {
        this.readIndex = this.writeIndex;
        this.readExhausted = false;
    }

    private void advanceRead() {
        ++this.readIndex;
        if (this.readIndex >= this.snapshots.length) {
            this.readIndex = 0;
        }
        if (this.readIndex == this.writeIndex) {
            this.readExhausted = true;
        }
    }
}

