/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.tree.btree;

import java.io.PrintStream;
import java.util.Arrays;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.CompressedUnsignedLongArrayByteIterable;
import jetbrains.exodus.log.CompressedUnsignedLongByteIterable;
import jetbrains.exodus.tree.Dumpable;
import jetbrains.exodus.tree.LongIterator;
import jetbrains.exodus.tree.btree.BTreeBalancePolicy;
import jetbrains.exodus.tree.btree.BTreeBase;
import jetbrains.exodus.tree.btree.BTreeDupMutable;
import jetbrains.exodus.tree.btree.BTreeMutable;
import jetbrains.exodus.tree.btree.BTreeTraverser;
import jetbrains.exodus.tree.btree.BaseLeafNode;
import jetbrains.exodus.tree.btree.BaseLeafNodeMutable;
import jetbrains.exodus.tree.btree.BasePageMutable;
import jetbrains.exodus.tree.btree.BottomPage;
import jetbrains.exodus.tree.btree.ILeafNode;
import jetbrains.exodus.tree.btree.LeafNodeDup;
import jetbrains.exodus.tree.btree.LeafNodeDupMutable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class BottomPageMutable
extends BasePageMutable {
    BottomPageMutable(BTreeMutable tree, BottomPage page) {
        super(tree, page);
    }

    private BottomPageMutable(BottomPageMutable page, int from, int length) {
        super((BTreeMutable)page.getTree());
        BTreeBalancePolicy bp = this.getBalancePolicy();
        int max = Math.max((length & 0x7FFFFFFE) + 2, ((BTreeMutable)this.tree).isDup() ? bp.getDupPageMaxSize() : bp.getPageMaxSize());
        this.keys = new BaseLeafNodeMutable[max];
        this.keysAddresses = new long[max];
        System.arraycopy(page.keys, from, this.keys, 0, length);
        System.arraycopy(page.keysAddresses, from, this.keysAddresses, 0, length);
        this.size = length;
    }

    @Override
    protected boolean isBottom() {
        return true;
    }

    @Override
    public long getChildAddress(int index) {
        return this.keysAddresses[index];
    }

    @Override
    @Nullable
    public BasePageMutable put(@NotNull ByteIterable key, @NotNull ByteIterable value, boolean overwrite, boolean[] result) {
        BTreeMutable tree = (BTreeMutable)this.getTree();
        int pos = this.binarySearch(key);
        if (pos >= 0) {
            if (overwrite) {
                BaseLeafNode ln = this.getKey(pos);
                if (tree.allowsDuplicates) {
                    LeafNodeDupMutable lnm = LeafNodeDupMutable.convert(ln, tree);
                    if (lnm.put(value)) {
                        tree.addExpiredLoggable(ln);
                        this.set(pos, lnm, null);
                        result[0] = true;
                    }
                } else if (!ln.isDupLeaf()) {
                    tree.addExpiredLoggable(ln);
                    this.set(pos, tree.createMutableLeaf(key, value), null);
                    result[0] = true;
                }
            }
            return null;
        }
        pos = -pos - 1;
        BasePageMutable page = this.insertAt(pos, tree.createMutableLeaf(key, value), null);
        result[0] = true;
        tree.incrementSize();
        return page;
    }

    @Override
    @Nullable
    public BasePageMutable putRight(@NotNull ByteIterable key, @NotNull ByteIterable value) {
        BTreeMutable tree = (BTreeMutable)this.getTree();
        if (this.size > 0) {
            int pos = this.size - 1;
            BaseLeafNode ln = this.getKey(pos);
            int cmp = ln.compareKeyTo(key);
            if (cmp > 0) {
                throw new IllegalArgumentException("Key must be greater");
            }
            if (cmp == 0) {
                if (tree.allowsDuplicates) {
                    this.set(pos, LeafNodeDupMutable.convert(ln, tree).putRight(value), null);
                    tree.addExpiredLoggable(ln);
                    return null;
                }
                throw new IllegalArgumentException("Key must not be equal");
            }
        }
        BasePageMutable page = this.insertAt(this.size, tree.createMutableLeaf(key, value), null);
        tree.incrementSize();
        return page;
    }

    @Override
    protected BasePageMutable split(int from, int length) {
        BottomPageMutable result = new BottomPageMutable(this, from, length);
        this.decrementSize(length);
        return result;
    }

    @Override
    protected long getBottomPagesCount() {
        return 1L;
    }

    @Override
    public ILeafNode get(@NotNull ByteIterable key) {
        return BottomPage.get(key, this);
    }

    @Override
    public ILeafNode find(@NotNull BTreeTraverser stack, int depth, @NotNull ByteIterable key, @Nullable ByteIterable value, boolean equalOrNext) {
        return BottomPage.find(stack, depth, key, value, equalOrNext, this);
    }

    @Override
    public boolean keyExists(@NotNull ByteIterable key) {
        return BottomPage.keyExists(key, this);
    }

    @Override
    public boolean exists(@NotNull ByteIterable key, @NotNull ByteIterable value) {
        return BottomPage.exists(key, value, this);
    }

    @Override
    @NotNull
    protected BasePageMutable.ReclaimFlag saveChildren() {
        BTreeBase tree = this.getTree();
        BasePageMutable.ReclaimFlag result = BasePageMutable.ReclaimFlag.RECLAIM;
        for (int i = 0; i < this.size; ++i) {
            if (this.keysAddresses[i] != -1L) continue;
            this.keysAddresses[i] = this.keys[i].save(tree);
            result = BasePageMutable.ReclaimFlag.PRESERVE;
        }
        return result;
    }

    @Override
    protected ByteIterable[] getByteIterables(@NotNull BasePageMutable.ReclaimFlag flag) {
        return new ByteIterable[]{CompressedUnsignedLongByteIterable.getIterable((this.size << 1) + flag.value), CompressedUnsignedLongArrayByteIterable.getIterable((long[])this.keysAddresses, (int)this.size)};
    }

    public String toString() {
        return "Bottom* [" + this.size + ']';
    }

    @Override
    public void dump(PrintStream out, int level, Dumpable.ToString renderer) {
        BottomPage.dump(out, level, renderer, this);
    }

    @Override
    public boolean delete(@NotNull ByteIterable key, @Nullable ByteIterable value) {
        int pos = this.binarySearch(key);
        if (pos < 0) {
            return false;
        }
        BTreeMutable tree = (BTreeMutable)this.getTree();
        if (tree.allowsDuplicates) {
            BaseLeafNode ln = this.getKey(pos);
            if (value == null) {
                if (!ln.isMutable()) {
                    tree.addExpiredLoggable(ln);
                    LongIterator it = ln.addressIterator();
                    while (it.hasNext()) {
                        tree.addExpiredLoggable(it.next());
                    }
                }
                this.copyChildren(pos + 1, pos);
                tree.decrementSize(ln.getDupCount());
                this.decrementSize(1);
                return true;
            }
            if (ln.isDup()) {
                boolean res;
                LeafNodeDupMutable lnm;
                if (ln.isMutable()) {
                    lnm = (LeafNodeDupMutable)ln;
                    res = lnm.delete(value);
                } else {
                    LeafNodeDup lnd = (LeafNodeDup)ln;
                    BTreeDupMutable dupTree = lnd.getTreeCopyMutable();
                    dupTree.mainTree = tree;
                    res = dupTree.delete(value);
                    if (res) {
                        tree.addExpiredLoggable(ln.getAddress());
                        lnm = LeafNodeDupMutable.convert(ln, tree, dupTree);
                        this.set(pos, lnm, null);
                    } else {
                        return false;
                    }
                }
                if (res) {
                    if (lnm.getRootPage().isBottom() && lnm.getRootPage().getSize() == 1) {
                        tree.addExpiredLoggable(this.keysAddresses[pos]);
                        tree.addExpiredLoggable(ln.addressIterator().next());
                        this.set(pos, tree.createMutableLeaf(lnm.getKey(), lnm.getValue()), null);
                    }
                    return true;
                }
                return false;
            }
        }
        tree.addExpiredLoggable(this.keysAddresses[pos]);
        this.copyChildren(pos + 1, pos);
        tree.decrementSize(1L);
        this.decrementSize(1);
        return true;
    }

    @Override
    protected BasePageMutable mergeWithChildren() {
        return this;
    }

    @Override
    protected void mergeWithRight(BasePageMutable page) {
        int newPageSize = this.size + page.size;
        if (newPageSize >= this.keys.length) {
            int newArraySize = (newPageSize & 0x7FFFFFFE) + 2;
            this.keys = Arrays.copyOf(this.keys, newArraySize);
            this.keysAddresses = Arrays.copyOf(this.keysAddresses, newArraySize);
        }
        System.arraycopy(page.keys, 0, this.keys, this.size, page.size);
        System.arraycopy(page.keysAddresses, 0, this.keysAddresses, this.size, page.size);
        this.size = newPageSize;
    }

    @Override
    protected void mergeWithLeft(BasePageMutable page) {
        page.mergeWithRight(this);
        this.keys = page.keys;
        this.keysAddresses = page.keysAddresses;
        this.size = page.size;
    }

    @Override
    public boolean childExists(@NotNull ByteIterable key, long pageAddress) {
        return false;
    }

    @Override
    protected byte getType() {
        return ((BTreeMutable)this.getTree()).getBottomPageType();
    }

    @Override
    protected void setMutableChild(int index, @NotNull BasePageMutable child) {
        throw new UnsupportedOperationException();
    }
}

