/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.okhttp.implementation;

import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.okhttp.implementation.OkHttpAsyncResponseBase;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import okhttp3.Headers;

public final class OkHttpToAzureCoreHttpHeadersWrapper
extends HttpHeaders {
    private final Headers okhttpHeaders;
    private HttpHeaders azureCoreHeaders;
    private boolean converted = false;

    public OkHttpToAzureCoreHttpHeadersWrapper(Headers okhttpHeaders) {
        this.okhttpHeaders = okhttpHeaders;
        this.azureCoreHeaders = new HttpHeaders(okhttpHeaders.size() * 2);
    }

    public int getSize() {
        return this.converted ? this.azureCoreHeaders.getSize() : this.okhttpHeaders.size();
    }

    @Deprecated
    public HttpHeaders add(String name, String value) {
        if (name == null || value == null) {
            return this;
        }
        this.convertIfNeeded();
        this.azureCoreHeaders.add(name, value);
        return this;
    }

    public HttpHeaders add(HttpHeaderName name, String value) {
        if (name == null || value == null) {
            return this;
        }
        this.convertIfNeeded();
        this.azureCoreHeaders.add(name, value);
        return this;
    }

    @Deprecated
    public HttpHeaders set(String name, String value) {
        if (name == null) {
            return this;
        }
        this.convertIfNeeded();
        this.azureCoreHeaders.set(name, value);
        return this;
    }

    public HttpHeaders set(HttpHeaderName name, String value) {
        if (name == null) {
            return this;
        }
        this.convertIfNeeded();
        this.azureCoreHeaders.set(name, value);
        return this;
    }

    @Deprecated
    public HttpHeaders set(String name, List<String> values) {
        if (name == null) {
            return this;
        }
        this.convertIfNeeded();
        this.azureCoreHeaders.set(name, values);
        return this;
    }

    public HttpHeaders set(HttpHeaderName name, List<String> values) {
        if (name == null) {
            return this;
        }
        this.convertIfNeeded();
        this.azureCoreHeaders.set(name, values);
        return this;
    }

    public HttpHeaders setAll(Map<String, List<String>> headers) {
        this.convertIfNeeded();
        this.azureCoreHeaders.setAll(headers);
        return this;
    }

    public HttpHeaders setAllHttpHeaders(HttpHeaders headers) {
        this.convertIfNeeded();
        this.azureCoreHeaders.setAllHttpHeaders(headers);
        return this;
    }

    @Deprecated
    public HttpHeader get(String name) {
        this.convertIfNeeded();
        return this.azureCoreHeaders.get(name);
    }

    public HttpHeader get(HttpHeaderName name) {
        this.convertIfNeeded();
        return this.azureCoreHeaders.get(name);
    }

    @Deprecated
    public HttpHeader remove(String name) {
        this.convertIfNeeded();
        return this.azureCoreHeaders.remove(name);
    }

    public HttpHeader remove(HttpHeaderName name) {
        this.convertIfNeeded();
        return this.azureCoreHeaders.remove(name);
    }

    @Deprecated
    public String getValue(String name) {
        this.convertIfNeeded();
        return this.azureCoreHeaders.getValue(name);
    }

    public String getValue(HttpHeaderName name) {
        this.convertIfNeeded();
        return this.azureCoreHeaders.getValue(name);
    }

    @Deprecated
    public String[] getValues(String name) {
        this.convertIfNeeded();
        return this.azureCoreHeaders.getValues(name);
    }

    public String[] getValues(HttpHeaderName name) {
        this.convertIfNeeded();
        return this.azureCoreHeaders.getValues(name);
    }

    public Map<String, String> toMap() {
        this.convertIfNeeded();
        return this.azureCoreHeaders.toMap();
    }

    public Iterator<HttpHeader> iterator() {
        this.convertIfNeeded();
        return this.azureCoreHeaders.iterator();
    }

    public Stream<HttpHeader> stream() {
        this.convertIfNeeded();
        return this.azureCoreHeaders.stream();
    }

    public String toString() {
        this.convertIfNeeded();
        return this.azureCoreHeaders.toString();
    }

    private void convertIfNeeded() {
        if (this.converted) {
            return;
        }
        this.azureCoreHeaders = OkHttpAsyncResponseBase.fromOkHttpHeaders(this.okhttpHeaders);
        this.converted = true;
    }
}

