/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.h2.database.migration;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.sql.SQLException;
import org.apache.nifi.h2.database.migration.DatabaseRepackager;
import org.apache.nifi.h2.database.migration.DatabaseStatementRunner;
import org.apache.nifi.h2.database.migration.DatabaseVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DatabaseExporter {
    private static final String URL_FORMAT = "jdbc:h2:%s;LOCK_MODE=3";
    private static final String DATABASE_FILE_FORMAT = "%s.mv.db";
    private static final String BACKUP_DATABASE_FILE_FORMAT = "%s.backup";
    private static final String REPACKAGED_DATABASE_FORMAT = "repackaged-%s";
    private static final String EXPORT_SCRIPT_NAME_FORMAT = "export-%s.sql";
    private static final String SCRIPT_TO_FORMAT = "SCRIPT TO '%s'";
    private static final Logger logger = LoggerFactory.getLogger(DatabaseExporter.class);

    DatabaseExporter() {
    }

    static Path runExportBackup(DatabaseVersion databaseVersion, String user, String pass, String databaseLocation) {
        Path exportDatabaseScriptPath;
        String databaseFileLocation = String.format(DATABASE_FILE_FORMAT, databaseLocation);
        Path databaseFilePath = Paths.get(databaseFileLocation, new String[0]);
        Path databasePath = Paths.get(databaseLocation, new String[0]);
        if (databaseVersion.isRepackagingRequired()) {
            Path repackagedDatabasePath = DatabaseExporter.getRepackagedDatabasePath(databaseVersion, databaseFilePath, databasePath);
            exportDatabaseScriptPath = DatabaseExporter.exportDatabaseScript(databaseVersion, repackagedDatabasePath, user, pass);
            Path repackagedDatabaseFilePath = Paths.get(String.format(DATABASE_FILE_FORMAT, repackagedDatabasePath), new String[0]);
            try {
                Files.delete(repackagedDatabaseFilePath);
            }
            catch (IOException e) {
                logger.warn("H2 DB {} delete repackaged database [{}] failed", new Object[]{databaseVersion.getVersion(), repackagedDatabaseFilePath, e});
            }
        } else {
            exportDatabaseScriptPath = DatabaseExporter.exportDatabaseScript(databaseVersion, databasePath, user, pass);
        }
        if (!Files.isReadable(exportDatabaseScriptPath)) {
            String message = String.format("H2 DB [%s] export failed: script path [%s] not found", databaseLocation, exportDatabaseScriptPath);
            throw new IllegalStateException(message);
        }
        DatabaseExporter.createDatabaseBackup(databaseFilePath);
        return exportDatabaseScriptPath;
    }

    private static Path getRepackagedDatabasePath(DatabaseVersion databaseVersion, Path databaseFilePath, Path databasePath) {
        String repackagedDatabaseFileName = String.format(REPACKAGED_DATABASE_FORMAT, databaseFilePath.getFileName());
        Path repackagedDatabaseFilePath = databaseFilePath.resolveSibling(repackagedDatabaseFileName);
        DatabaseRepackager.repackageDatabaseFile(databaseVersion, databaseFilePath, repackagedDatabaseFilePath);
        String repackagedDatabaseName = String.format(REPACKAGED_DATABASE_FORMAT, databasePath.getFileName());
        return databasePath.resolveSibling(repackagedDatabaseName);
    }

    private static Path exportDatabaseScript(DatabaseVersion databaseVersion, Path databasePath, String user, String password) {
        Path databaseName = databasePath.getFileName();
        String exportScriptName = String.format(EXPORT_SCRIPT_NAME_FORMAT, databaseName);
        Path exportScriptPath = databasePath.resolveSibling(exportScriptName);
        String scriptToCommand = String.format(SCRIPT_TO_FORMAT, exportScriptPath);
        String url = String.format(URL_FORMAT, databasePath);
        try {
            DatabaseStatementRunner.run(databaseVersion, url, user, password, scriptToCommand);
        }
        catch (SQLException e) {
            throw new IllegalStateException(String.format("H2 DB %s export script failed [%s]", databaseVersion.getVersion(), scriptToCommand), e);
        }
        return exportScriptPath;
    }

    private static void createDatabaseBackup(Path databaseFilePath) {
        String backupDatabaseFileLocation = String.format(BACKUP_DATABASE_FILE_FORMAT, databaseFilePath);
        Path backupDatabaseFilePath = Paths.get(backupDatabaseFileLocation, new String[0]);
        try {
            Files.move(databaseFilePath, backupDatabaseFilePath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("H2 DB [%s] migration backup failed", databaseFilePath), e);
        }
    }
}

