/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.extension;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.registry.extension.BundlePersistenceProvider;
import org.apache.nifi.registry.extension.ExtensionClassLoader;
import org.apache.nifi.registry.flow.FlowPersistenceProvider;
import org.apache.nifi.registry.hook.EventHookProvider;
import org.apache.nifi.registry.properties.NiFiRegistryProperties;
import org.apache.nifi.registry.security.authentication.IdentityProvider;
import org.apache.nifi.registry.security.authorization.AccessPolicyProvider;
import org.apache.nifi.registry.security.authorization.Authorizer;
import org.apache.nifi.registry.security.authorization.UserGroupProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExtensionManager {
    static final Logger LOGGER = LoggerFactory.getLogger(ExtensionManager.class);
    private static final List<Class> EXTENSION_CLASSES;
    private final NiFiRegistryProperties properties;
    private final Map<String, ExtensionClassLoader> classLoaderMap = new HashMap<String, ExtensionClassLoader>();
    private final AtomicBoolean loaded = new AtomicBoolean(false);

    @Autowired
    public ExtensionManager(NiFiRegistryProperties properties) {
        this.properties = properties;
    }

    @PostConstruct
    public synchronized void discoverExtensions() {
        if (!this.loaded.get()) {
            List<ExtensionClassLoader> classLoaders = this.getClassLoaders();
            for (ExtensionClassLoader extensionClassLoader : classLoaders) {
                for (Class extensionClass : EXTENSION_CLASSES) {
                    this.loadExtensions(extensionClass, extensionClassLoader);
                }
            }
            this.loaded.set(true);
        }
    }

    public ExtensionClassLoader getExtensionClassLoader(String canonicalClassName) {
        if (StringUtils.isBlank((CharSequence)canonicalClassName)) {
            throw new IllegalArgumentException("Class name can not be null");
        }
        return this.classLoaderMap.get(canonicalClassName);
    }

    private void loadExtensions(Class extensionClass, ExtensionClassLoader extensionClassLoader) {
        ServiceLoader serviceLoader = ServiceLoader.load(extensionClass, extensionClassLoader);
        for (Object o : serviceLoader) {
            String extensionClassName = o.getClass().getCanonicalName();
            if (this.classLoaderMap.containsKey(extensionClassName)) {
                String currDir = extensionClassLoader.getRootDir();
                String existingDir = this.classLoaderMap.get(extensionClassName).getRootDir();
                LOGGER.warn("Skipping {} from {} which was already found in {}", new Object[]{extensionClassName, currDir, existingDir});
                continue;
            }
            this.classLoaderMap.put(o.getClass().getCanonicalName(), extensionClassLoader);
        }
    }

    private List<ExtensionClassLoader> getClassLoaders() {
        ArrayList<ExtensionClassLoader> classLoaders = new ArrayList<ExtensionClassLoader>();
        ExtensionClassLoader frameworkClassLoader = new ExtensionClassLoader("web-api", new URL[0], this.getClass().getClassLoader());
        classLoaders.add(frameworkClassLoader);
        ClassLoader systemClassLoader = FlowPersistenceProvider.class.getClassLoader();
        Set extensionDirs = this.properties.getExtensionsDirs();
        for (String dir : extensionDirs) {
            ExtensionClassLoader classLoader;
            if (StringUtils.isBlank((CharSequence)dir) || (classLoader = this.createClassLoader(dir, systemClassLoader)) == null) continue;
            classLoaders.add(classLoader);
        }
        return classLoaders;
    }

    private ExtensionClassLoader createClassLoader(String dir, ClassLoader parentClassLoader) {
        File[] files;
        File dirFile = new File(dir);
        if (!dirFile.exists()) {
            LOGGER.warn("Skipping extension directory that does not exist: " + dir);
            return null;
        }
        if (!dirFile.canRead()) {
            LOGGER.warn("Skipping extension directory that can not be read: " + dir);
            return null;
        }
        LinkedList<URL> resources = new LinkedList<URL>();
        try {
            resources.add(dirFile.toURI().toURL());
        }
        catch (MalformedURLException mfe) {
            LOGGER.warn("Unable to add {} to classpath", (Object)dirFile.getAbsolutePath(), (Object)mfe);
        }
        if (dirFile.isDirectory() && (files = dirFile.listFiles()) != null) {
            for (File resource : files) {
                if (resource.isDirectory()) {
                    LOGGER.warn("Recursive directories are not supported, skipping " + resource.getAbsolutePath());
                    continue;
                }
                try {
                    resources.add(resource.toURI().toURL());
                }
                catch (MalformedURLException mfe) {
                    LOGGER.warn("Unable to add {} to classpath", (Object)resource.getAbsolutePath(), (Object)mfe);
                }
            }
        }
        URL[] urls = resources.toArray(new URL[resources.size()]);
        return new ExtensionClassLoader(dir, urls, parentClassLoader);
    }

    static {
        ArrayList<Class<BundlePersistenceProvider>> classes = new ArrayList<Class<BundlePersistenceProvider>>();
        classes.add(FlowPersistenceProvider.class);
        classes.add(UserGroupProvider.class);
        classes.add(AccessPolicyProvider.class);
        classes.add(Authorizer.class);
        classes.add(IdentityProvider.class);
        classes.add(EventHookProvider.class);
        classes.add(BundlePersistenceProvider.class);
        EXTENSION_CLASSES = Collections.unmodifiableList(classes);
    }
}

