/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.security.crypto;

import java.io.IOException;
import org.apache.nifi.properties.SensitivePropertyProtectionException;
import org.apache.nifi.properties.SensitivePropertyProviderFactory;
import org.apache.nifi.properties.StandardSensitivePropertyProviderFactory;
import org.apache.nifi.registry.properties.util.NiFiRegistryBootstrapUtils;
import org.apache.nifi.registry.security.crypto.CryptoKeyProvider;
import org.apache.nifi.registry.security.crypto.MissingCryptoKeyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SensitivePropertyProviderFactoryConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(SensitivePropertyProviderFactoryConfiguration.class);
    @Autowired(required=false)
    private CryptoKeyProvider masterKeyProvider;

    @Bean
    public SensitivePropertyProviderFactory getProvider() {
        if (this.masterKeyProvider == null || this.masterKeyProvider.isEmpty()) {
            return null;
        }
        try {
            return StandardSensitivePropertyProviderFactory.withKeyAndBootstrapSupplier((String)this.masterKeyProvider.getKey(), () -> {
                try {
                    return NiFiRegistryBootstrapUtils.loadBootstrapProperties();
                }
                catch (IOException e) {
                    throw new SensitivePropertyProtectionException("Error creating Sensitive Property Provider", (Throwable)e);
                }
            });
        }
        catch (MissingCryptoKeyException e) {
            logger.warn("Error creating Sensitive Property Provider", (Throwable)e);
            throw new SensitivePropertyProtectionException("Error creating Sensitive Property Provider", (Throwable)e);
        }
    }
}

