/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stateless.bootstrap;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.nifi.stateless.bootstrap.RunStatelessFlow;
import org.apache.nifi.stateless.config.ParameterOverride;

public class BootstrapConfiguration {
    private static final String RUN_CONTINUOUS_ENV_VAR = "NIFI_STATELESS_CONTINUOUS";
    private static final String ENGINE_CONFIG_FILE_ENV_VAR = "NIFI_STATELESS_ENGINE_CONFIG_FILE";
    private static final String FLOW_CONFIGURATION_FILE_ENV_VAR = "NIFI_STATELESS_FLOW_CONFIG_FILE";
    private static final String DEFAULT_ENGINE_CONFIG_FILE = "./conf/stateless.properties";
    private static final String DEFAULT_FLOW_CONFIG_FILE = "./conf/env-flow-config.properties";
    private static final Pattern PARAMETER_OVERRIDE_PATTERN = Pattern.compile("(?<!\\\\):");
    private static final String PARAMETER_OVERRIDE_FLAG = "-p";
    private static final String RUN_CONTINUOUS_SHORT_FLAG = "-c";
    private static final String RUN_CONTINUOUS_LONG_FLAG = "--continuous";
    private static final String ENGINE_CONFIG_SHORT_FLAG = "-e";
    private static final String ENGINE_CONFIG_LONG_FLAG = "--engine-config";
    private static final String FLOW_CONFIGURATION_FILE_SHORT_FLAG = "-f";
    private static final String FLOW_CONFIGURATION_FILE_LONG_FLAG = "--flow-config";
    private File engineConfigFile = null;
    private File flowDefinitionFile = null;
    private boolean runContinuous;
    private List<ParameterOverride> parameterOverrides = new ArrayList<ParameterOverride>();

    static void printUsage() {
        System.out.println("Usage:");
        System.out.println();
        System.out.print("java " + RunStatelessFlow.class.getCanonicalName() + " ");
        System.out.println("<options>");
        System.out.println();
        System.out.println();
        System.out.println("Options:");
        System.out.println("-p <context name>:<parameter name>=<parameter value>");
        System.out.println("    Specifies a parameter value to use. If the parameter is present in the provided flow configuration file, the value provided here will take precedence.");
        System.out.println("    For example, to specify that the 'Foo' parameter of the Parameter Context with name 'bar' should have a value of 'BAZ', use:");
        System.out.println("    -p bar:Foo=BAZ");
        System.out.println();
        System.out.println("    Multiple Parameters may be specified in this way. For example:");
        System.out.println("    -p bar:Foo=BAZ -p \"My Context:My Parameter=My Value\"");
        System.out.println();
        System.out.println("    If a Parameter Context name has a colon in it, it may be escaped using the \\ character. Parameter names and values do not need to be escaped:");
        System.out.println("    -p \"My\\:Context:My:Parameter=Use ratio of 1:1");
        System.out.println();
        System.out.println(RUN_CONTINUOUS_SHORT_FLAG);
        System.out.println(RUN_CONTINUOUS_LONG_FLAG);
        System.out.println("    Specifies that the flow should be run continuously. If not specified, the flow will run only a single iteration and stop ");
        System.out.println("    (unless the --continuous System Property is set to a value of true).");
        System.out.println();
        System.out.println(ENGINE_CONFIG_SHORT_FLAG);
        System.out.println(ENGINE_CONFIG_LONG_FLAG);
        System.out.println("    Specifies the filename of the Stateless Engine Configuration properties file. ");
        System.out.println("    If not specified, the NIFI_STATELESS_ENGINE_CONFIG_FILE Environment Variable will be inspected.");
        System.out.println("    If that is not set, defaults to ./conf/stateless.properties");
        System.out.println();
        System.out.println(FLOW_CONFIGURATION_FILE_SHORT_FLAG);
        System.out.println(FLOW_CONFIGURATION_FILE_LONG_FLAG);
        System.out.println("    Specifies the filename of the Flow Configuration properties file.");
        System.out.println("    If not specified, the NIFI_STATELESS_FLOW_CONFIG_FILE Environment Variable will be inspected.");
        System.out.println("    If that is not set, defaults to ./conf/env-flow-config.properties, which sources all configuration from environment variables.");
        System.out.println();
        System.out.println();
    }

    private BootstrapConfiguration() {
        this.runContinuous = Boolean.parseBoolean(System.getenv(RUN_CONTINUOUS_ENV_VAR));
    }

    public File getEngineConfigFile() {
        return this.engineConfigFile;
    }

    public File getFlowDefinitionFile() {
        return this.flowDefinitionFile;
    }

    public List<ParameterOverride> getParameterOverrides() {
        return this.parameterOverrides;
    }

    public boolean isRunContinuous() {
        return this.runContinuous;
    }

    static BootstrapConfiguration fromCommandLineArgs(String[] args) {
        BootstrapConfiguration configuration = new BootstrapConfiguration();
        configuration.parseArguments(args);
        return configuration;
    }

    private void parseArguments(String[] args) {
        String arg;
        String flowConfigFilename;
        String engineConfigFilename = System.getenv(ENGINE_CONFIG_FILE_ENV_VAR);
        if (engineConfigFilename == null) {
            engineConfigFilename = DEFAULT_ENGINE_CONFIG_FILE;
        }
        if ((flowConfigFilename = System.getenv(FLOW_CONFIGURATION_FILE_ENV_VAR)) == null) {
            flowConfigFilename = DEFAULT_FLOW_CONFIG_FILE;
        }
        LinkedList<String> argQueue = new LinkedList<String>(Arrays.asList(args));
        block15: while ((arg = (String)argQueue.poll()) != null) {
            switch (arg) {
                case "-p": {
                    String parameterArg = (String)argQueue.poll();
                    if (parameterArg == null) {
                        throw new IllegalArgumentException("Invalid argument: -p argument must be followed by the parameter");
                    }
                    ParameterOverride override = this.parseOverride(parameterArg);
                    this.parameterOverrides.add(override);
                    continue block15;
                }
                case "-e": 
                case "--engine-config": {
                    engineConfigFilename = (String)argQueue.poll();
                    if (engineConfigFilename != null) continue block15;
                    throw new IllegalArgumentException("When specifying flag " + arg + ", next arg must supply the filename of the Engine Configuration file but no arg was given.");
                }
                case "-f": 
                case "--flow-config": {
                    flowConfigFilename = (String)argQueue.poll();
                    if (flowConfigFilename != null) continue block15;
                    throw new IllegalArgumentException("When specifying flag " + arg + ", next arg must supply the filename of the Flow Configuration file but no arg was given.");
                }
                case "-c": 
                case "--continuous": {
                    this.runContinuous = true;
                    continue block15;
                }
            }
            throw new IllegalArgumentException("Invalid argument: " + arg);
        }
        this.engineConfigFile = new File(engineConfigFilename);
        if (!this.engineConfigFile.exists()) {
            throw new IllegalArgumentException(String.format("Cannot find Engine Configuration File %s - please ensure that the file exists and appropriate permissions are in place for allowing access to the file, or otherwise specify a different filename using the %s or %s command-line argument or by specifying the %s Environment Variable", this.engineConfigFile.getAbsolutePath(), ENGINE_CONFIG_LONG_FLAG, ENGINE_CONFIG_SHORT_FLAG, ENGINE_CONFIG_FILE_ENV_VAR));
        }
        this.flowDefinitionFile = new File(flowConfigFilename);
        if (!this.flowDefinitionFile.exists()) {
            throw new IllegalArgumentException(String.format("Cannot find Flow Configuration File %s - please ensure that the file exists and appropriate permissions are in place for allowing access to the file, or otherwise specify a different filename using the %s or %s command-line argument or by specifying the %s Environment Variable", this.flowDefinitionFile.getAbsolutePath(), FLOW_CONFIGURATION_FILE_LONG_FLAG, FLOW_CONFIGURATION_FILE_SHORT_FLAG, FLOW_CONFIGURATION_FILE_ENV_VAR));
        }
    }

    ParameterOverride parseOverride(String argument) {
        String[] nameAndValueSplits = argument.split("=", 2);
        if (nameAndValueSplits.length == 1) {
            throw new IllegalArgumentException("Invalid parameter: argument has no equals sign: " + argument);
        }
        String contextAndParameterName = nameAndValueSplits[0];
        if (contextAndParameterName.trim().isEmpty()) {
            throw new IllegalArgumentException("Invalid parameter: argument has no parameter name: " + argument);
        }
        String parameterValue = nameAndValueSplits[1];
        String[] splits = contextAndParameterName.split(PARAMETER_OVERRIDE_PATTERN.pattern(), 2);
        if (splits.length == 1) {
            return new ParameterOverride(contextAndParameterName, parameterValue);
        }
        if (splits.length == 2) {
            String contextName = splits[0].replace("\\:", ":");
            String parameterName = splits[1];
            return new ParameterOverride(contextName, parameterName, parameterValue);
        }
        throw new IllegalArgumentException("Invalid parameter: " + argument);
    }
}

