/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate;

import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterator;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.NonDisposableEntityIterator;
import org.jetbrains.annotations.NotNull;

public final class EntityTypeFilteredIterator
extends NonDisposableEntityIterator {
    private final EntityIterator source;
    private final int entityTypeId;
    private boolean hasNext;
    private boolean hasNextValid;
    private EntityId nextId;

    public EntityTypeFilteredIterator(@NotNull EntityIterableBase source, int entityTypeId) {
        super(source);
        this.source = source.iterator();
        this.entityTypeId = entityTypeId;
    }

    @Override
    protected boolean hasNextImpl() {
        this.checkHasNext();
        return this.hasNext;
    }

    @Override
    protected EntityId nextIdImpl() {
        this.checkHasNext();
        this.hasNextValid = false;
        return this.nextId;
    }

    private void checkHasNext() {
        if (!this.hasNextValid) {
            this.hasNextValid = true;
            this.nextId = null;
            while (this.source.hasNext()) {
                EntityId nextId = this.source.nextId();
                if (nextId != null && this.entityTypeId != nextId.getTypeId()) continue;
                this.nextId = nextId;
                this.hasNext = true;
                return;
            }
            this.hasNext = false;
        }
    }
}

