/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate;

import java.util.Collection;
import java.util.Map;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.core.dataStructures.hash.IntHashMap;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterableHandle;
import jetbrains.exodus.entitystore.EntityIterableType;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.EntityIdSet;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableDecoratorBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableHandleBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableHandleDecorator;
import jetbrains.exodus.entitystore.iterate.EntityIteratorBase;
import jetbrains.exodus.entitystore.iterate.SourceMappingIterator;
import jetbrains.exodus.entitystore.tables.LinkValue;
import jetbrains.exodus.entitystore.tables.PropertyKey;
import jetbrains.exodus.entitystore.util.EntityIdSetFactory;
import jetbrains.exodus.env.Cursor;
import jetbrains.exodus.util.LightOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u000f2\u00020\u0001:\u0002\u000f\u0010B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Ljetbrains/exodus/entitystore/iterate/SelectDistinctIterable;", "Ljetbrains/exodus/entitystore/iterate/EntityIterableDecoratorBase;", "txn", "Ljetbrains/exodus/entitystore/PersistentStoreTransaction;", "source", "Ljetbrains/exodus/entitystore/iterate/EntityIterableBase;", "linkId", "", "(Ljetbrains/exodus/entitystore/PersistentStoreTransaction;Ljetbrains/exodus/entitystore/iterate/EntityIterableBase;I)V", "getHandleImpl", "Ljetbrains/exodus/entitystore/EntityIterableHandle;", "getIteratorImpl", "Ljetbrains/exodus/entitystore/iterate/EntityIteratorBase;", "isEmpty", "", "Companion", "SelectDistinctIterator", "xodus-entity-store"})
public final class SelectDistinctIterable
extends EntityIterableDecoratorBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int linkId;

    public SelectDistinctIterable(@NotNull PersistentStoreTransaction txn, @NotNull EntityIterableBase source, int linkId) {
        Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        super(txn, source);
        this.linkId = linkId;
    }

    @Override
    public boolean isEmpty() {
        return this.source.isEmpty();
    }

    @Override
    @NotNull
    public EntityIteratorBase getIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
        return new SelectDistinctIterator(txn);
    }

    @Override
    @NotNull
    protected EntityIterableHandle getHandleImpl() {
        PersistentEntityStoreImpl persistentEntityStoreImpl = this.getStore();
        EntityIterableType entityIterableType = Companion.getType();
        EntityIterableHandle entityIterableHandle = this.source.getHandle();
        return new EntityIterableHandleDecorator(this, persistentEntityStoreImpl, entityIterableType, entityIterableHandle){
            @NotNull
            private final int[] linkIds;
            final /* synthetic */ SelectDistinctIterable this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
                int[] nArray = new int[]{SelectDistinctIterable.access$getLinkId$p(this.this$0)};
                int[] nArray2 = EntityIterableHandleBase.mergeFieldIds(nArray, this.decorated.getLinkIds());
                Intrinsics.checkNotNullExpressionValue((Object)nArray2, (String)"mergeFieldIds(intArrayOf\u2026nkId), decorated.linkIds)");
                this.linkIds = nArray2;
            }

            @NotNull
            public int[] getLinkIds() {
                return this.linkIds;
            }

            public void toString(@NotNull StringBuilder builder) {
                Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
                super.toString(builder);
                this.applyDecoratedToBuilder(builder);
                builder.append('-');
                builder.append(SelectDistinctIterable.access$getLinkId$p(this.this$0));
            }

            public void hashCode(@NotNull EntityIterableHandleBase.EntityIterableHandleHash hash) {
                Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
                super.hashCode(hash);
                hash.applyDelimiter();
                hash.apply(SelectDistinctIterable.access$getLinkId$p(this.this$0));
            }

            public boolean isMatchedLinkAdded(@NotNull EntityId source, @NotNull EntityId target, int linkId) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                Intrinsics.checkNotNullParameter((Object)target, (String)"target");
                return linkId == SelectDistinctIterable.access$getLinkId$p(this.this$0) || this.decorated.isMatchedLinkAdded(source, target, linkId);
            }

            public boolean isMatchedLinkDeleted(@NotNull EntityId source, @NotNull EntityId target, int linkId) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                Intrinsics.checkNotNullParameter((Object)target, (String)"target");
                return linkId == SelectDistinctIterable.access$getLinkId$p(this.this$0) || this.decorated.isMatchedLinkDeleted(source, target, linkId);
            }
        };
    }

    private static final EntityIterableBase _init_$lambda-0(PersistentStoreTransaction txn, PersistentEntityStoreImpl $noName_1, Object[] parameters) {
        Intrinsics.checkNotNullExpressionValue((Object)txn, (String)"txn");
        Object object = parameters[1];
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type jetbrains.exodus.entitystore.iterate.EntityIterableBase");
        }
        EntityIterableBase entityIterableBase = (EntityIterableBase)object;
        Object object2 = parameters[0];
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
        }
        Integer n = Integer.valueOf((String)object2);
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"valueOf(parameters[0] as String)");
        return new SelectDistinctIterable(txn, entityIterableBase, ((Number)n).intValue());
    }

    static {
        EntityIterableBase.registerType(Companion.getType(), SelectDistinctIterable::_init_$lambda-0);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0016\u001a\u00020\u000bH\u0002J\b\u0010\u0017\u001a\u00020\u000bH\u0016J\b\u0010\u0018\u001a\u00020\u0010H\u0016J\b\u0010\u0019\u001a\u00020\u000bH\u0014J\n\u0010\u001a\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010\u001b\u001a\u00020\u000eH\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Ljetbrains/exodus/entitystore/iterate/SelectDistinctIterable$SelectDistinctIterator;", "Ljetbrains/exodus/entitystore/iterate/EntityIteratorBase;", "Ljetbrains/exodus/entitystore/iterate/SourceMappingIterator;", "txn", "Ljetbrains/exodus/entitystore/PersistentStoreTransaction;", "(Ljetbrains/exodus/entitystore/iterate/SelectDistinctIterable;Ljetbrains/exodus/entitystore/PersistentStoreTransaction;)V", "auxArray", "", "auxStream", "Ljetbrains/exodus/util/LightOutputStream;", "hasNext", "", "hasNextValid", "iterated", "Ljetbrains/exodus/entitystore/iterate/EntityIdSet;", "nextId", "Ljetbrains/exodus/entitystore/EntityId;", "sourceIt", "srcId", "usedCursors", "Ljetbrains/exodus/core/dataStructures/hash/IntHashMap;", "Ljetbrains/exodus/env/Cursor;", "advance", "dispose", "getSourceId", "hasNextImpl", "nextIdImpl", "toSet", "xodus-entity-store"})
    private final class SelectDistinctIterator
    extends EntityIteratorBase
    implements SourceMappingIterator {
        @NotNull
        private final PersistentStoreTransaction txn;
        @NotNull
        private final EntityIteratorBase sourceIt;
        @NotNull
        private final IntHashMap<Cursor> usedCursors;
        @NotNull
        private final LightOutputStream auxStream;
        @NotNull
        private final int[] auxArray;
        @NotNull
        private EntityIdSet iterated;
        private EntityId srcId;
        @Nullable
        private EntityId nextId;
        private boolean hasNext;
        private boolean hasNextValid;

        public SelectDistinctIterator(PersistentStoreTransaction txn) {
            Intrinsics.checkNotNullParameter((Object)SelectDistinctIterable.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
            super(SelectDistinctIterable.this);
            this.txn = txn;
            this.sourceIt = (EntityIteratorBase)SelectDistinctIterable.this.source.iterator();
            this.usedCursors = new IntHashMap(6, 2.0f);
            this.auxStream = new LightOutputStream();
            this.auxArray = new int[8];
            this.iterated = EntityIdSetFactory.newSet();
        }

        @Override
        protected boolean hasNextImpl() {
            if (!this.hasNextValid) {
                this.hasNextValid = true;
                this.hasNext = this.advance();
            }
            return this.hasNext;
        }

        @Override
        @Nullable
        public EntityId nextIdImpl() {
            EntityId nextId = this.nextId;
            EntityIdSet entityIdSet = this.iterated.add(nextId);
            Intrinsics.checkNotNullExpressionValue((Object)entityIdSet, (String)"iterated.add(nextId)");
            this.iterated = entityIdSet;
            this.hasNextValid = false;
            return nextId;
        }

        private final boolean advance() {
            if (SelectDistinctIterable.this.linkId < 0) {
                return !this.iterated.contains(null) && this.sourceIt.hasNext();
            }
            while (this.sourceIt.hasNext()) {
                Cursor cursor;
                EntityId nextSourceId;
                if (this.sourceIt.nextId() == null) continue;
                this.srcId = nextSourceId;
                int typeId = nextSourceId.getTypeId();
                Cursor cursor2 = (Cursor)this.usedCursors.get(typeId);
                if (cursor2 == null) {
                    Cursor cursor3;
                    Cursor it = cursor3 = this.getStore().getLinksFirstIndexCursor(this.txn, typeId);
                    boolean bl = false;
                    Map map = (Map)this.usedCursors;
                    Integer n = typeId;
                    map.put(n, it);
                    Cursor cursor4 = cursor3;
                    Intrinsics.checkNotNullExpressionValue((Object)cursor4, (String)"store.getLinksFirstIndex\u2026sedCursors[typeId] = it }");
                    cursor = cursor4;
                } else {
                    cursor = cursor2;
                }
                Cursor cursor5 = cursor;
                ArrayByteIterable keyEntry = PropertyKey.propertyKeyToEntry(this.auxStream, this.auxArray, nextSourceId.getLocalId(), SelectDistinctIterable.this.linkId);
                ByteIterable value = cursor5.getSearchKey((ByteIterable)keyEntry);
                if (value == null) {
                    if (this.iterated.contains(null)) continue;
                    this.nextId = null;
                    return true;
                }
                LinkValue linkValue = LinkValue.entryToLinkValue(value);
                EntityId entityId = linkValue.getEntityId();
                Intrinsics.checkNotNullExpressionValue((Object)entityId, (String)"linkValue.entityId");
                EntityId nextId = entityId;
                if (this.iterated.contains(nextId)) continue;
                this.nextId = nextId;
                return true;
            }
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean dispose() {
            this.sourceIt.disposeIfShouldBe();
            if (!super.dispose()) return false;
            Collection collection = this.usedCursors.values();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"usedCursors.values");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Cursor it = (Cursor)element$iv;
                boolean bl = false;
                it.close();
            }
            Unit it = Unit.INSTANCE;
            return true;
        }

        @Override
        @NotNull
        protected EntityIdSet toSet() {
            return this.iterated;
        }

        @Override
        @NotNull
        public EntityId getSourceId() {
            EntityId entityId = this.srcId;
            if (entityId == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"srcId");
                entityId = null;
            }
            return entityId;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Ljetbrains/exodus/entitystore/iterate/SelectDistinctIterable$Companion;", "", "()V", "type", "Ljetbrains/exodus/entitystore/EntityIterableType;", "getType", "()Ljetbrains/exodus/entitystore/EntityIterableType;", "xodus-entity-store"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EntityIterableType getType() {
            return EntityIterableType.SELECT_DISTINCT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

