/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.cluster;

import org.apache.curator.utils.ZookeeperFactory;
import org.apache.nifi.controller.cluster.ZooKeeperClientConfig;
import org.apache.zookeeper.ClientCnxnSocketNetty;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.admin.ZooKeeperAdmin;
import org.apache.zookeeper.client.ZKClientConfig;
import org.apache.zookeeper.common.ClientX509Util;

public class SecureClientZooKeeperFactory
implements ZookeeperFactory {
    public static final String NETTY_CLIENT_CNXN_SOCKET = ClientCnxnSocketNetty.class.getName();
    private ZKClientConfig zkSecureClientConfig = new ZKClientConfig();

    public SecureClientZooKeeperFactory(ZooKeeperClientConfig zkConfig) {
        String cnxnSocket = zkConfig.getConnectionSocket();
        if (!NETTY_CLIENT_CNXN_SOCKET.equals(cnxnSocket)) {
            throw new IllegalArgumentException(String.format("connection factory set to '%s', %s required", String.valueOf(cnxnSocket), NETTY_CLIENT_CNXN_SOCKET));
        }
        this.zkSecureClientConfig.setProperty("zookeeper.clientCnxnSocket", cnxnSocket);
        boolean clientSecure = zkConfig.isClientSecure();
        if (!clientSecure) {
            throw new IllegalStateException(String.format("%s set to '%b', expected true", "zookeeper.client.secure", clientSecure));
        }
        this.zkSecureClientConfig.setProperty("zookeeper.client.secure", String.valueOf(clientSecure));
        ClientX509Util clientX509util = new ClientX509Util();
        this.zkSecureClientConfig.setProperty(clientX509util.getSslKeystoreLocationProperty(), zkConfig.getKeyStore());
        this.zkSecureClientConfig.setProperty(clientX509util.getSslKeystoreTypeProperty(), zkConfig.getKeyStoreType());
        this.zkSecureClientConfig.setProperty(clientX509util.getSslKeystorePasswdProperty(), zkConfig.getKeyStorePassword());
        this.zkSecureClientConfig.setProperty(clientX509util.getSslTruststoreLocationProperty(), zkConfig.getTrustStore());
        this.zkSecureClientConfig.setProperty(clientX509util.getSslTruststoreTypeProperty(), zkConfig.getTrustStoreType());
        this.zkSecureClientConfig.setProperty(clientX509util.getSslTruststorePasswdProperty(), zkConfig.getTrustStorePassword());
    }

    public ZooKeeper newZooKeeper(String connectString, int sessionTimeout, Watcher watcher, boolean canBeReadOnly) throws Exception {
        return new ZooKeeperAdmin(connectString, sessionTimeout, watcher, this.zkSecureClientConfig);
    }
}

