/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.nifi.controller.queue.FlowFileQueue;
import org.apache.nifi.controller.repository.FlowFileRecord;
import org.apache.nifi.controller.repository.FlowFileRepository;
import org.apache.nifi.controller.repository.FlowFileSwapManager;
import org.apache.nifi.controller.repository.QueueProvider;
import org.apache.nifi.controller.repository.RepositoryRecord;
import org.apache.nifi.controller.repository.RepositoryRecordType;
import org.apache.nifi.controller.repository.claim.ContentClaim;
import org.apache.nifi.controller.repository.claim.ResourceClaim;
import org.apache.nifi.controller.repository.claim.ResourceClaimManager;

public class VolatileFlowFileRepository
implements FlowFileRepository {
    private final AtomicLong idGenerator = new AtomicLong(0L);
    private ResourceClaimManager claimManager;

    public void initialize(ResourceClaimManager claimManager) {
        this.claimManager = claimManager;
    }

    public boolean isVolatile() {
        return true;
    }

    public long getStorageCapacity() throws IOException {
        return 1L;
    }

    public long getUsableStorageSpace() throws IOException {
        return 0L;
    }

    public String getFileStoreName() {
        return null;
    }

    public void close() throws IOException {
    }

    private void markDestructable(ContentClaim contentClaim) {
        if (contentClaim == null) {
            return;
        }
        ResourceClaim resourceClaim = contentClaim.getResourceClaim();
        if (resourceClaim == null) {
            return;
        }
        this.claimManager.markDestructable(resourceClaim);
    }

    private int getClaimantCount(ContentClaim claim) {
        if (claim == null) {
            return 0;
        }
        ResourceClaim resourceClaim = claim.getResourceClaim();
        if (resourceClaim == null) {
            return 0;
        }
        return this.claimManager.getClaimantCount(resourceClaim);
    }

    public void updateRepository(Collection<RepositoryRecord> records) throws IOException {
        for (RepositoryRecord record : records) {
            this.updateClaimCounts(record);
            if (record.getType() == RepositoryRecordType.DELETE) {
                if (record.getCurrentClaim() != null && this.getClaimantCount(record.getCurrentClaim()) <= 0) {
                    this.markDestructable(record.getCurrentClaim());
                }
                if (record.getOriginalClaim() == null || record.getOriginalClaim().equals(record.getCurrentClaim()) || this.getClaimantCount(record.getOriginalClaim()) > 0) continue;
                this.markDestructable(record.getOriginalClaim());
                continue;
            }
            if (record.getType() != RepositoryRecordType.UPDATE || record.getOriginalClaim() == null || record.getCurrentClaim() == record.getOriginalClaim() || this.getClaimantCount(record.getOriginalClaim()) > 0) continue;
            this.markDestructable(record.getOriginalClaim());
        }
    }

    private void updateClaimCounts(RepositoryRecord record) {
        ContentClaim originalClaim;
        boolean claimChanged;
        ContentClaim currentClaim = record.getCurrentClaim();
        boolean bl = claimChanged = !Objects.equals(currentClaim, originalClaim = record.getOriginalClaim());
        if (record.getType() == RepositoryRecordType.DELETE || record.getType() == RepositoryRecordType.CONTENTMISSING) {
            this.decrementClaimCount(currentClaim);
        }
        if (claimChanged) {
            this.decrementClaimCount(originalClaim);
        }
    }

    private void decrementClaimCount(ContentClaim claim) {
        if (claim == null) {
            return;
        }
        this.claimManager.decrementClaimantCount(claim.getResourceClaim());
    }

    public long loadFlowFiles(QueueProvider queueProvider) throws IOException {
        return 0L;
    }

    public Set<String> findQueuesWithFlowFiles(FlowFileSwapManager swapManager) throws IOException {
        return Collections.emptySet();
    }

    public void updateMaxFlowFileIdentifier(long maxId) {
        long currentId;
        boolean updated;
        do {
            if ((currentId = this.idGenerator.get()) < maxId) continue;
            return;
        } while (!(updated = this.idGenerator.compareAndSet(currentId, maxId)));
    }

    public long getNextFlowFileSequence() {
        return this.idGenerator.getAndIncrement();
    }

    public long getMaxFlowFileIdentifier() throws IOException {
        return this.idGenerator.get() - 1L;
    }

    public void swapFlowFilesIn(String swapLocation, List<FlowFileRecord> flowFileRecords, FlowFileQueue queue) throws IOException {
    }

    public void swapFlowFilesOut(List<FlowFileRecord> swappedOut, FlowFileQueue queue, String swapLocation) throws IOException {
    }

    public boolean isValidSwapLocationSuffix(String swapLocationSuffix) {
        return false;
    }
}

