/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.status.analytics.models;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.math3.linear.SingularMatrixException;
import org.apache.commons.math3.stat.regression.OLSMultipleLinearRegression;
import org.apache.nifi.controller.status.analytics.StatusAnalyticsModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrdinaryLeastSquares
implements StatusAnalyticsModel {
    private static final Logger LOG = LoggerFactory.getLogger(OrdinaryLeastSquares.class);
    private OLSMultipleLinearRegression olsModel = new OLSMultipleLinearRegression();
    private double[] coefficients;

    public void learn(Stream<Double[]> features, Stream<Double> labels) {
        double[] labelArray = ArrayUtils.toPrimitive((Double[])((Double[])labels.toArray(Double[]::new)));
        double[][] featuresMatrix = (double[][])features.map(ArrayUtils::toPrimitive).toArray(x$0 -> new double[x$0][]);
        this.olsModel.newSampleData(labelArray, featuresMatrix);
        try {
            this.coefficients = this.olsModel.estimateRegressionParameters();
        }
        catch (SingularMatrixException sme) {
            LOG.debug("The OLSMultipleLinearRegression model's matrix has no inverse (i.e. it is singular) so regression parameters can not be estimated at this time.");
        }
    }

    public Double predict(Double[] feature) {
        if (this.coefficients == null) {
            return null;
        }
        double intercept = this.olsModel.isNoIntercept() ? 0.0 : this.coefficients[0];
        double sumX = 0.0;
        for (int i = 0; i < feature.length; ++i) {
            sumX += this.coefficients[i + 1] * feature[i];
        }
        return sumX + intercept;
    }

    public Double predictVariable(Integer predictVariableIndex, Map<Integer, Double> knownVariablesWithIndex, Double label) {
        if (this.coefficients == null) {
            return null;
        }
        double intercept = this.olsModel.isNoIntercept() ? 0.0 : this.coefficients[0];
        double predictorCoeff = this.coefficients[predictVariableIndex + 1];
        double sumX = 0.0;
        if (knownVariablesWithIndex.size() > 0) {
            sumX = knownVariablesWithIndex.entrySet().stream().map(featureTuple -> this.coefficients[this.olsModel.isNoIntercept() ? (Integer)featureTuple.getKey() : (Integer)featureTuple.getKey() + 1] * (Double)featureTuple.getValue()).mapToDouble(Double::doubleValue).sum();
        }
        return (label - intercept - sumX) / predictorCoeff;
    }

    public Map<String, Double> getScores() {
        if (this.coefficients == null) {
            return null;
        }
        HashMap<String, Double> scores = new HashMap<String, Double>();
        try {
            scores.put("rSquared", this.olsModel.calculateRSquared());
            scores.put("totalSumOfSquares", this.olsModel.calculateTotalSumOfSquares());
        }
        catch (SingularMatrixException sme) {
            LOG.debug("The OLSMultipleLinearRegression model's matrix has no inverse (i.e. it is singular) so no scores can be calculated at this time.");
        }
        return scores;
    }

    public Boolean supportsOnlineLearning() {
        return false;
    }

    public void clear() {
    }
}

