/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.kms.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class KeyHandleName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_KEY_HANDLE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/keyHandles/{key_handle}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String keyHandle;

    @Deprecated
    protected KeyHandleName() {
        this.project = null;
        this.location = null;
        this.keyHandle = null;
    }

    private KeyHandleName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.keyHandle = (String)Preconditions.checkNotNull((Object)builder.getKeyHandle());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getKeyHandle() {
        return this.keyHandle;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static KeyHandleName of(String project, String location, String keyHandle) {
        return KeyHandleName.newBuilder().setProject(project).setLocation(location).setKeyHandle(keyHandle).build();
    }

    public static String format(String project, String location, String keyHandle) {
        return KeyHandleName.newBuilder().setProject(project).setLocation(location).setKeyHandle(keyHandle).build().toString();
    }

    public static KeyHandleName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_KEY_HANDLE.validatedMatch(formattedString, "KeyHandleName.parse: formattedString not in valid format");
        return KeyHandleName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("key_handle"));
    }

    public static List<KeyHandleName> parseList(List<String> formattedStrings) {
        ArrayList<KeyHandleName> list = new ArrayList<KeyHandleName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(KeyHandleName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<KeyHandleName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (KeyHandleName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_KEY_HANDLE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            KeyHandleName keyHandleName = this;
            synchronized (keyHandleName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.keyHandle != null) {
                        fieldMapBuilder.put((Object)"key_handle", (Object)this.keyHandle);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_KEY_HANDLE.instantiate(new String[]{"project", this.project, "location", this.location, "key_handle", this.keyHandle});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            KeyHandleName that = (KeyHandleName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.keyHandle, that.keyHandle);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.keyHandle);
    }

    public static class Builder {
        private String project;
        private String location;
        private String keyHandle;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getKeyHandle() {
            return this.keyHandle;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setKeyHandle(String keyHandle) {
            this.keyHandle = keyHandle;
            return this;
        }

        private Builder(KeyHandleName keyHandleName) {
            this.project = keyHandleName.project;
            this.location = keyHandleName.location;
            this.keyHandle = keyHandleName.keyHandle;
        }

        public KeyHandleName build() {
            return new KeyHandleName(this);
        }
    }
}

