/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.log;

import jetbrains.exodus.log.DataCorruptionException;
import jetbrains.exodus.log.Log;
import jetbrains.exodus.log.LogUtil;
import org.jetbrains.annotations.NotNull;

class BlockNotFoundException
extends DataCorruptionException {
    private BlockNotFoundException(String message, long address, long fileLengthBound) {
        super(message + LogUtil.getWrongAddressErrorMessage(address, fileLengthBound));
    }

    public static void raise(@NotNull String message, @NotNull Log log, long address) {
        BlockNotFoundException.checkLogIsClosing(log);
        throw new BlockNotFoundException(message, address, log.getFileLengthBound());
    }

    static void raise(@NotNull Log log, long address) {
        BlockNotFoundException.raise("File not found", log, address);
    }
}

