/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.tls;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.nifi.toolkit.tls.commandLine.ExitCode;
import org.apache.nifi.toolkit.tls.service.client.TlsCertificateAuthorityClientCommandLine;
import org.apache.nifi.toolkit.tls.service.server.TlsCertificateAuthorityServiceCommandLine;
import org.apache.nifi.toolkit.tls.standalone.TlsToolkitStandaloneCommandLine;
import org.apache.nifi.toolkit.tls.status.TlsToolkitGetStatusCommandLine;

public class TlsToolkitMain {
    public static final String DESCRIPTION = "DESCRIPTION";
    public static final String UNABLE_TO_GET_DESCRIPTION = "Unable to get description. (";
    private final Map<String, Class<?>> mainMap = new LinkedHashMap();

    public TlsToolkitMain() {
        this.mainMap.put("standalone", TlsToolkitStandaloneCommandLine.class);
        this.mainMap.put("server", TlsCertificateAuthorityServiceCommandLine.class);
        this.mainMap.put("client", TlsCertificateAuthorityClientCommandLine.class);
        this.mainMap.put("status", TlsToolkitGetStatusCommandLine.class);
    }

    public static void main(String[] args) {
        new TlsToolkitMain().doMain(args);
    }

    private <T> T printUsageAndExit(String message, ExitCode exitCode) {
        System.out.println(message);
        System.out.println();
        System.out.println("Usage: tls-toolkit service [-h] [args]");
        System.out.println();
        System.out.println("Services:");
        this.mainMap.forEach((s, aClass) -> System.out.println("   " + s + ": " + this.getDescription((Class<?>)aClass)));
        System.out.println();
        System.exit(exitCode.ordinal());
        return null;
    }

    protected String getDescription(Class<?> clazz) {
        try {
            Field declaredField = clazz.getDeclaredField(DESCRIPTION);
            return String.valueOf(declaredField.get(null));
        }
        catch (Exception e) {
            return UNABLE_TO_GET_DESCRIPTION + e.getMessage() + ")";
        }
    }

    protected Map<String, Class<?>> getMainMap() {
        return this.mainMap;
    }

    protected Method getMain(String service) {
        Class<?> mainClass = this.mainMap.get(service);
        if (mainClass == null) {
            this.printUsageAndExit("Unknown service: " + service, ExitCode.INVALID_ARGS);
        }
        System.err.println("The TLS Toolkit is deprecated and targeted for removal in Apache NiFi 2.0.");
        try {
            return mainClass.getDeclaredMethod("main", String[].class);
        }
        catch (NoSuchMethodException e) {
            return (Method)this.printUsageAndExit("Service " + service + " is missing main method.", ExitCode.SERVICE_ERROR);
        }
    }

    public void doMain(String[] args) {
        if (args.length < 1) {
            this.printUsageAndExit("Expected at least a service argument.", ExitCode.INVALID_ARGS);
        }
        String service = args[0].toLowerCase();
        try {
            this.getMain(service).invoke(null, new Object[]{Arrays.copyOfRange(args, 1, args.length, String[].class)});
        }
        catch (IllegalAccessException e) {
            this.printUsageAndExit("Service " + service + " has invalid main method.", ExitCode.SERVICE_ERROR);
        }
        catch (InvocationTargetException e) {
            this.printUsageAndExit("Service " + service + " error: " + e.getCause().getMessage(), ExitCode.SERVICE_ERROR);
        }
    }
}

