/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.tls.service.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.nifi.toolkit.tls.commandLine.CommandLineParseException;
import org.apache.nifi.toolkit.tls.commandLine.ExitCode;
import org.apache.nifi.toolkit.tls.configuration.InstanceDefinition;
import org.apache.nifi.toolkit.tls.configuration.TlsClientConfig;
import org.apache.nifi.toolkit.tls.service.BaseCertificateAuthorityCommandLine;
import org.apache.nifi.toolkit.tls.service.client.TlsCertificateAuthorityClient;
import org.apache.nifi.toolkit.tls.util.InputStreamFactory;
import org.apache.nifi.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TlsCertificateAuthorityClientCommandLine
extends BaseCertificateAuthorityCommandLine {
    public static final String DESCRIPTION = "Generates a private key and gets it signed by the certificate authority.";
    public static final String CERTIFICATE_DIRECTORY = "certificateDirectory";
    public static final String SUBJECT_ALTERNATIVE_NAMES = "subjectAlternativeNames";
    public static final String DEFAULT_CERTIFICATE_DIRECTORY = ".";
    private final Logger logger = LoggerFactory.getLogger(TlsCertificateAuthorityClientCommandLine.class);
    private final InputStreamFactory inputStreamFactory;
    private String certificateDirectory;
    private List<InstanceDefinition> domainAlternativeNames;

    public TlsCertificateAuthorityClientCommandLine() {
        this(FileInputStream::new);
    }

    public TlsCertificateAuthorityClientCommandLine(InputStreamFactory inputStreamFactory) {
        super(DESCRIPTION);
        this.inputStreamFactory = inputStreamFactory;
        this.addOptionWithArg("C", CERTIFICATE_DIRECTORY, "The file to write the CA certificate to", DEFAULT_CERTIFICATE_DIRECTORY);
        this.addOptionWithArg(null, SUBJECT_ALTERNATIVE_NAMES, "Comma-separated list of domains to use as Subject Alternative Names in the certificate");
    }

    public static void main(String[] args) throws Exception {
        TlsCertificateAuthorityClientCommandLine tlsCertificateAuthorityClientCommandLine = new TlsCertificateAuthorityClientCommandLine();
        try {
            tlsCertificateAuthorityClientCommandLine.parse(args);
        }
        catch (CommandLineParseException e) {
            System.exit(e.getExitCode().ordinal());
        }
        new TlsCertificateAuthorityClient().generateCertificateAndGetItSigned(tlsCertificateAuthorityClientCommandLine.createClientConfig(), tlsCertificateAuthorityClientCommandLine.getCertificateDirectory(), tlsCertificateAuthorityClientCommandLine.getConfigJsonOut(), tlsCertificateAuthorityClientCommandLine.differentPasswordForKeyAndKeystore());
        System.exit(ExitCode.SUCCESS.ordinal());
    }

    @Override
    protected boolean shouldAddDaysArg() {
        return false;
    }

    @Override
    protected boolean shouldAddSigningAlgorithmArg() {
        return false;
    }

    @Override
    protected String getTokenDescription() {
        return "The token to use to prevent MITM (required and must be same as one used by CA)";
    }

    @Override
    protected String getDnDescription() {
        return "The dn to use for the client certificate";
    }

    @Override
    protected String getPortDescription() {
        return "The port to use to communicate with the Certificate Authority";
    }

    @Override
    protected String getDnHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            this.logger.warn("Unable to determine hostname", (Throwable)e);
            return "localhost";
        }
    }

    @Override
    protected CommandLine doParse(String[] args) throws CommandLineParseException {
        CommandLine commandLine = super.doParse(args);
        this.certificateDirectory = commandLine.getOptionValue(CERTIFICATE_DIRECTORY, DEFAULT_CERTIFICATE_DIRECTORY);
        this.domainAlternativeNames = commandLine.hasOption(SUBJECT_ALTERNATIVE_NAMES) ? Collections.unmodifiableList(InstanceDefinition.createDefinitions(null, Arrays.stream(commandLine.getOptionValues(SUBJECT_ALTERNATIVE_NAMES)).flatMap(s -> Arrays.stream(s.split(",")).map(String::trim)), null, null, null)) : Collections.EMPTY_LIST;
        return commandLine;
    }

    public String getCertificateDirectory() {
        return this.certificateDirectory;
    }

    public List<String> getDomainAlternativeNames() {
        if (this.domainAlternativeNames == null) {
            this.domainAlternativeNames = Collections.EMPTY_LIST;
        }
        return this.domainAlternativeNames.stream().map(InstanceDefinition::getHostname).collect(Collectors.toList());
    }

    public TlsClientConfig createClientConfig() throws IOException {
        String configJsonIn = this.getConfigJsonIn();
        if (!StringUtils.isEmpty((String)configJsonIn)) {
            try (InputStream inputStream = this.inputStreamFactory.create(new File(configJsonIn));){
                TlsClientConfig tlsClientConfig = (TlsClientConfig)new ObjectMapper().readValue(inputStream, TlsClientConfig.class);
                tlsClientConfig.initDefaults();
                TlsClientConfig tlsClientConfig2 = tlsClientConfig;
                return tlsClientConfig2;
            }
        }
        TlsClientConfig tlsClientConfig = new TlsClientConfig();
        tlsClientConfig.setCaHostname(this.getCertificateAuthorityHostname());
        tlsClientConfig.setDn(this.getDn());
        tlsClientConfig.setDomainAlternativeNames(this.getDomainAlternativeNames());
        tlsClientConfig.setToken(this.getToken());
        tlsClientConfig.setPort(this.getPort());
        tlsClientConfig.setKeyStore("keystore." + this.getKeyStoreType().toLowerCase());
        tlsClientConfig.setKeyStoreType(this.getKeyStoreType());
        tlsClientConfig.setTrustStore("truststore." + tlsClientConfig.getTrustStoreType().toLowerCase());
        tlsClientConfig.setKeySize(this.getKeySize());
        tlsClientConfig.setKeyPairAlgorithm(this.getKeyAlgorithm());
        tlsClientConfig.setSigningAlgorithm(this.getSigningAlgorithm());
        return tlsClientConfig;
    }
}

