/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.tls.service.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import org.apache.http.HttpHost;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.protocol.HttpContext;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;

public class TlsCertificateAuthorityClientSocketFactory
extends SSLConnectionSocketFactory {
    private final String caHostname;
    private final List<X509Certificate> certificates;

    public TlsCertificateAuthorityClientSocketFactory(SSLContext sslContext, String caHostname, List<X509Certificate> certificates) {
        super(sslContext);
        this.caHostname = caHostname;
        this.certificates = certificates;
    }

    public synchronized Socket connectSocket(int connectTimeout, Socket socket, HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException {
        String cn;
        Socket result = super.connectSocket(connectTimeout, socket, host, remoteAddress, localAddress, context);
        if (!SSLSocket.class.isInstance(result)) {
            throw new IOException("Expected tls socket");
        }
        SSLSocket sslSocket = (SSLSocket)result;
        Certificate[] peerCertificateChain = sslSocket.getSession().getPeerCertificates();
        if (peerCertificateChain.length != 1) {
            throw new IOException("Expected root ca cert");
        }
        if (!X509Certificate.class.isInstance(peerCertificateChain[0])) {
            throw new IOException("Expected root ca cert in X509 format");
        }
        try {
            X509Certificate certificate = (X509Certificate)peerCertificateChain[0];
            cn = IETFUtils.valueToString((ASN1Encodable)new JcaX509CertificateHolder(certificate).getSubject().getRDNs(BCStyle.CN)[0].getFirst().getValue());
            this.certificates.add(certificate);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        if (!this.caHostname.equals(cn)) {
            throw new IOException("Expected cn of " + this.caHostname + " but got " + cn);
        }
        return result;
    }
}

