/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository.metrics;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.nifi.controller.repository.FlowFileEvent;
import org.apache.nifi.controller.repository.metrics.EventSumValue;

public class EventSum {
    private final AtomicReference<EventSumValue> ref = new AtomicReference();

    public EventSumValue getValue() {
        EventSumValue value = this.ref.get();
        return value == null ? new EventSumValue(System.currentTimeMillis()) : value;
    }

    public EventSumValue addOrReset(FlowFileEvent event, long timestamp) {
        EventSumValue curValue;
        long expectedSecond = timestamp / 1000L;
        while ((curValue = this.ref.get()) == null || curValue.getTimestamp() / 1000L != expectedSecond) {
            EventSumValue newValue = new EventSumValue(timestamp);
            boolean replaced = this.ref.compareAndSet(curValue, newValue);
            if (!replaced) continue;
            newValue.add(event);
            return curValue;
        }
        curValue.add(event);
        return null;
    }

    public EventSumValue reset(long ifOlderThan) {
        block2: {
            EventSumValue curValue;
            do {
                if ((curValue = this.ref.get()) == null) {
                    return null;
                }
                if (curValue.getTimestamp() >= ifOlderThan) break block2;
            } while (!this.ref.compareAndSet(curValue, null));
            return curValue;
        }
        return null;
    }
}

