/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.encrypt;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Objects;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.nifi.encrypt.SensitiveValueEncoder;
import org.apache.nifi.security.util.crypto.SecureHasher;
import org.apache.nifi.security.util.crypto.SecureHasherFactory;
import org.apache.nifi.util.NiFiProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardSensitiveValueEncoder
implements SensitiveValueEncoder {
    private static final Logger logger = LoggerFactory.getLogger(StandardSensitiveValueEncoder.class);
    private SecretKeySpec secretKeySpec;
    private static Base64.Encoder base64Encoder;
    private static final String HMAC_SHA256 = "HmacSHA256";
    private static final Charset PROPERTY_CHARSET;

    public StandardSensitiveValueEncoder(NiFiProperties properties) {
        this(properties.getProperty("nifi.sensitive.props.key"), SecureHasherFactory.getSecureHasher((String)properties.getProperty("nifi.sensitive.props.algorithm")));
    }

    private StandardSensitiveValueEncoder(String sensitivePropertiesKey, SecureHasher hasher) {
        Objects.requireNonNull(sensitivePropertiesKey, "Sensitive Properties Key is required");
        Objects.requireNonNull(hasher, "SecureHasher is required");
        byte[] hashedSensitivePropertyKey = hasher.hashRaw(sensitivePropertiesKey.getBytes(PROPERTY_CHARSET));
        this.secretKeySpec = new SecretKeySpec(hashedSensitivePropertyKey, HMAC_SHA256);
        base64Encoder = Base64.getEncoder();
    }

    @Override
    public String getEncoded(String plaintextSensitiveValue) {
        try {
            Mac mac = Mac.getInstance(HMAC_SHA256);
            mac.init(this.secretKeySpec);
            byte[] hashedBytes = mac.doFinal(plaintextSensitiveValue.getBytes(PROPERTY_CHARSET));
            return "[MASKED] (" + base64Encoder.encodeToString(hashedBytes) + ")";
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            logger.error("Encountered an error making the sensitive value loggable: {}", (Object)e.getLocalizedMessage());
            return "[Unable to mask value]";
        }
    }

    static {
        PROPERTY_CHARSET = StandardCharsets.UTF_8;
    }
}

