/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.tracing;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.tracing.MetricsRecorder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.Meter;
import java.util.Map;

@BetaApi
@InternalApi
public class OpenTelemetryMetricsRecorder
implements MetricsRecorder {
    private final DoubleHistogram attemptLatencyRecorder;
    private final DoubleHistogram operationLatencyRecorder;
    private final LongCounter operationCountRecorder;
    private final LongCounter attemptCountRecorder;

    public OpenTelemetryMetricsRecorder(OpenTelemetry openTelemetry, String serviceName) {
        Meter meter = openTelemetry.meterBuilder("gax-java").setInstrumentationVersion(GaxProperties.getGaxVersion()).build();
        this.attemptLatencyRecorder = meter.histogramBuilder(serviceName + "/attempt_latency").setDescription("Time an individual attempt took").setUnit("ms").build();
        this.operationLatencyRecorder = meter.histogramBuilder(serviceName + "/operation_latency").setDescription("Total time until final operation success or failure, including retries and backoff.").setUnit("ms").build();
        this.attemptCountRecorder = meter.counterBuilder(serviceName + "/attempt_count").setDescription("Number of Attempts").setUnit("1").build();
        this.operationCountRecorder = meter.counterBuilder(serviceName + "/operation_count").setDescription("Number of Operations").setUnit("1").build();
    }

    @Override
    public void recordAttemptLatency(double attemptLatency, Map<String, String> attributes) {
        this.attemptLatencyRecorder.record(attemptLatency, this.toOtelAttributes(attributes));
    }

    @Override
    public void recordAttemptCount(long count, Map<String, String> attributes) {
        this.attemptCountRecorder.add(count, this.toOtelAttributes(attributes));
    }

    @Override
    public void recordOperationLatency(double operationLatency, Map<String, String> attributes) {
        this.operationLatencyRecorder.record(operationLatency, this.toOtelAttributes(attributes));
    }

    @Override
    public void recordOperationCount(long count, Map<String, String> attributes) {
        this.operationCountRecorder.add(count, this.toOtelAttributes(attributes));
    }

    @VisibleForTesting
    Attributes toOtelAttributes(Map<String, String> attributes) {
        Preconditions.checkNotNull(attributes, (Object)"Attributes map cannot be null");
        AttributesBuilder attributesBuilder = Attributes.builder();
        attributes.forEach((arg_0, arg_1) -> ((AttributesBuilder)attributesBuilder).put(arg_0, arg_1));
        return attributesBuilder.build();
    }
}

