/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.vm;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.vm.MemoryCMRImpl;
import io.questdb.cairo.vm.api.MemoryCMOR;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Files;
import io.questdb.std.FilesFacade;
import io.questdb.std.str.LPSZ;

public class MemoryCMORImpl
extends MemoryCMRImpl
implements MemoryCMOR {
    private static final Log LOG = LogFactory.getLog(MemoryCMORImpl.class);
    private long mapFileOffset;
    private long offset;

    @Override
    public long addressOf(long offset) {
        assert (offset - this.mapFileOffset <= this.size) : "offset=" + offset + ", size=" + this.size + ", fd=" + this.fd;
        return this.pageAddress + offset - this.mapFileOffset;
    }

    @Override
    public void close() {
        super.close();
        this.mapFileOffset = 0L;
        this.offset = 0L;
    }

    @Override
    public void extend(long newSize) {
        if (newSize > this.size) {
            this.setSize0(newSize + this.offset - this.mapFileOffset);
        }
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    @Override
    public void growToFileSize() {
        long length = this.getFilesFacade().length(this.getFd());
        if (length < 0L) {
            throw CairoException.critical(this.ff.errno()).put("could not get length fd: ").put(this.fd);
        }
        this.extend(length - this.mapFileOffset);
    }

    @Override
    public void of(FilesFacade ff, LPSZ name, long extendSegmentSize, long size, int memoryTag, long opts) {
        this.ofOffset(ff, name, 0L, size, memoryTag, opts);
    }

    @Override
    public void ofOffset(FilesFacade ff, LPSZ name, long lo, long hi, int memoryTag, long opts) {
        this.memoryTag = memoryTag;
        this.openFile(ff, name);
        if (hi < 0L && (hi = ff.length(this.fd)) < 0L) {
            this.close();
            throw CairoException.critical(ff.errno()).put("could not get length: ").put(name);
        }
        assert (hi >= lo) : "hi : " + hi + " lo : " + lo;
        if (hi > lo) {
            this.offset = lo;
            this.mapFileOffset = Files.PAGE_SIZE * (lo / Files.PAGE_SIZE);
            this.size = hi - this.mapFileOffset;
            this.map(ff, name, this.size, this.mapFileOffset);
        } else {
            this.size = 0L;
        }
    }

    @Override
    public long size() {
        return this.size + this.mapFileOffset - this.offset;
    }

    private void openFile(FilesFacade ff, LPSZ name) {
        this.close();
        this.ff = ff;
        this.fd = TableUtils.openRO(ff, name, LOG);
    }

    private void setSize0(long newSize) {
        try {
            if (this.size > 0L) {
                this.pageAddress = TableUtils.mremap(this.ff, this.fd, this.pageAddress, this.size, newSize, this.mapFileOffset, 1, this.memoryTag);
            } else {
                assert (this.pageAddress == 0L);
                this.pageAddress = TableUtils.mapRO(this.ff, this.fd, newSize, this.mapFileOffset, this.memoryTag);
            }
            this.size = newSize;
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
    }

    protected void map(FilesFacade ff, LPSZ name, long size, long mapOffset) {
        this.size = size;
        if (size > 0L) {
            try {
                this.pageAddress = TableUtils.mapRO(ff, this.fd, size, mapOffset, this.memoryTag);
            }
            catch (Throwable e) {
                this.close();
                throw e;
            }
        }
        LOG.debug().$("map  [file=").$(name).$(", fd=").$(this.fd).$(", pageSize=").$(size).$(", size=").$(this.size).$(']').$();
    }
}

