/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.MessageBus;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.IndexBuilder;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.UpdateOperator;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.TableRecordMetadata;
import io.questdb.cairo.sql.TableReferenceOutOfDateException;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryCM;
import io.questdb.cairo.vm.api.MemoryCMARW;
import io.questdb.cairo.vm.api.MemoryCMR;
import io.questdb.griffin.PurgingOperator;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.ops.UpdateOperation;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.QuietCloseable;
import io.questdb.std.Rows;
import io.questdb.std.Vect;
import io.questdb.std.str.Path;

public class UpdateOperatorImpl
extends PurgingOperator
implements QuietCloseable,
UpdateOperator {
    private static final Log LOG = LogFactory.getLog(UpdateOperatorImpl.class);
    private final long dataAppendPageSize;
    private final ObjList<MemoryCMARW> dstColumns = new ObjList();
    private final long fileOpenOpts;
    private final ObjList<MemoryCMR> srcColumns = new ObjList();
    private IndexBuilder indexBuilder = new IndexBuilder();

    public UpdateOperatorImpl(CairoConfiguration configuration, MessageBus messageBus, TableWriter tableWriter, Path path, int rootLen) {
        super(LOG, configuration, messageBus, tableWriter, path, rootLen);
        this.dataAppendPageSize = configuration.getDataAppendPageSize();
        this.fileOpenOpts = configuration.getWriterFileOpenOpts();
    }

    @Override
    public void close() {
        this.indexBuilder = Misc.free(this.indexBuilder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long executeUpdate(SqlExecutionContext sqlExecutionContext, UpdateOperation op) throws TableReferenceOutOfDateException {
        TableToken tableToken = this.tableWriter.getTableToken();
        LOG.info().$("updating [table=").$(tableToken).$(" instance=").$(op.getCorrelationId()).I$();
        try {
            TableRecordMetadata tableMetadata;
            int tableId = op.getTableId();
            long tableVersion = op.getTableVersion();
            RecordCursorFactory factory = op.getFactory();
            this.cleanupColumnVersions.clear();
            if (this.tableWriter.inTransaction()) {
                LOG.info().$("committing current transaction before UPDATE execution [table=").$(tableToken).$(" instance=").$(op.getCorrelationId()).I$();
                this.tableWriter.commit();
            }
            if ((tableMetadata = this.tableWriter.getMetadata()).getTableId() != tableId || this.tableWriter.getStructureVersion() != tableVersion) {
                throw TableReferenceOutOfDateException.of(tableToken, tableId, tableMetadata.getTableId(), tableVersion, this.tableWriter.getStructureVersion());
            }
            RecordMetadata updateMetadata = factory.getMetadata();
            int affectedColumnCount = updateMetadata.getColumnCount();
            this.updateColumnIndexes.clear();
            for (int i = 0; i < affectedColumnCount; ++i) {
                String columnName = updateMetadata.getColumnName(i);
                int tableColumnIndex = tableMetadata.getColumnIndex(columnName);
                assert (tableColumnIndex >= 0);
                this.updateColumnIndexes.add(tableColumnIndex);
            }
            this.configureColumns(tableMetadata, affectedColumnCount);
            int partitionIndex = -1;
            long rowsUpdated = 0L;
            op.forceTestTimeout();
            try (RecordCursor recordCursor = factory.getCursor(sqlExecutionContext);){
                Record masterRecord = recordCursor.getRecord();
                long prevRow = 0L;
                long minRow = -1L;
                long lastRowId = Long.MIN_VALUE;
                while (recordCursor.hasNext()) {
                    long rowId = masterRecord.getUpdateRowId();
                    if (rowId == lastRowId) continue;
                    if (rowId < lastRowId) {
                        throw CairoException.critical(0).put("Update statement generated invalid query plan. Rows are not returned in order.");
                    }
                    lastRowId = rowId;
                    int rowPartitionIndex = Rows.toPartitionIndex(rowId);
                    long currentRow = Rows.toLocalRowID(rowId);
                    if (rowPartitionIndex != partitionIndex) {
                        if (this.tableWriter.isPartitionReadOnly(rowPartitionIndex)) {
                            throw CairoException.critical(0).put("cannot update read-only partition [table=").put(tableToken.getTableName()).put(", partitionTimestamp=").ts(this.tableWriter.getPartitionTimestamp(rowPartitionIndex)).put(']');
                        }
                        if (partitionIndex > -1) {
                            LOG.info().$("updating partition [partitionIndex=").$(partitionIndex).$(", rowPartitionIndex=").$(rowPartitionIndex).$(", rowPartitionTs=").$ts(this.tableWriter.getPartitionTimestamp(rowPartitionIndex)).$(", affectedColumnCount=").$(affectedColumnCount).$(", prevRow=").$(prevRow).$(", minRow=").$(minRow).I$();
                            this.copyColumns(partitionIndex, affectedColumnCount, prevRow, minRow);
                            UpdateOperatorImpl.updateEffectiveColumnTops(this.tableWriter, partitionIndex, this.updateColumnIndexes, affectedColumnCount, minRow);
                            this.rebuildIndexes(this.tableWriter.getPartitionTimestamp(partitionIndex), tableMetadata, this.tableWriter);
                        }
                        this.openColumns(this.srcColumns, rowPartitionIndex, false);
                        this.openColumns(this.dstColumns, rowPartitionIndex, true);
                        partitionIndex = rowPartitionIndex;
                        prevRow = 0L;
                        minRow = currentRow;
                    }
                    this.appendRowUpdate(rowPartitionIndex, affectedColumnCount, prevRow, currentRow, masterRecord, minRow);
                    prevRow = currentRow + 1L;
                    ++rowsUpdated;
                    op.testTimeout();
                }
                if (partitionIndex > -1) {
                    this.copyColumns(partitionIndex, affectedColumnCount, prevRow, minRow);
                    UpdateOperatorImpl.updateEffectiveColumnTops(this.tableWriter, partitionIndex, this.updateColumnIndexes, affectedColumnCount, minRow);
                    this.rebuildIndexes(this.tableWriter.getPartitionTimestamp(partitionIndex), tableMetadata, this.tableWriter);
                }
            }
            finally {
                Misc.freeObjList(this.srcColumns);
                Misc.freeObjList(this.dstColumns);
                this.srcColumns.clear();
                this.dstColumns.clear();
            }
            if (partitionIndex > -1) {
                op.forceTestTimeout();
                this.tableWriter.commit();
                this.tableWriter.openLastPartition();
                this.purgeOldColumnVersions();
            }
            LOG.info().$("update finished [table=").$(tableToken).$(", instance=").$(op.getCorrelationId()).$(", updated=").$(rowsUpdated).$(", txn=").$(this.tableWriter.getTxn()).I$();
            long l = rowsUpdated;
            return l;
        }
        catch (TableReferenceOutOfDateException e) {
            throw e;
        }
        catch (SqlException e) {
            throw CairoException.critical(0).put("could not apply update on SPI side [e=").put((CharSequence)((Object)e)).put(']');
        }
        catch (Throwable th) {
            LOG.error().$("could not update").$(th).$();
            throw th;
        }
        finally {
            op.closeWriter();
        }
    }

    private static long calculatedEffectiveColumnTop(long firstUpdatedPartitionRowId, long columnTop) {
        if (columnTop > -1L) {
            return Math.min(firstUpdatedPartitionRowId, columnTop);
        }
        return firstUpdatedPartitionRowId;
    }

    private static void fillUpdatesGapWithNull(int columnType, long fromRow, long toRow, MemoryCMARW dstFixMem, MemoryCMARW dstVarMem, int shl) {
        short columnTag = ColumnType.tagOf(columnType);
        switch (columnTag) {
            case 11: {
                for (long row = fromRow; row < toRow; ++row) {
                    dstFixMem.putLong(dstVarMem.putNullStr());
                }
                break;
            }
            case 18: {
                for (long row = fromRow; row < toRow; ++row) {
                    dstFixMem.putLong(dstVarMem.putNullBin());
                }
                break;
            }
            default: {
                long rowCount = toRow - fromRow;
                TableUtils.setNull(columnType, dstFixMem.appendAddressFor(rowCount << shl), rowCount);
            }
        }
    }

    private static int getFixedColumnSize(int columnType) {
        if (ColumnType.isVariableLength(columnType)) {
            return 3;
        }
        return ColumnType.pow2SizeOf(columnType);
    }

    private static void updateEffectiveColumnTops(TableWriter tableWriter, int partitionIndex, IntList updateColumnIndexes, int columnCount, long firstUpdatedPartitionRowId) {
        long partitionTimestamp = tableWriter.getPartitionTimestamp(partitionIndex);
        for (int columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
            int updateColumnIndex = updateColumnIndexes.get(columnIndex);
            long columnTop = tableWriter.getColumnTop(partitionTimestamp, updateColumnIndex, -1L);
            long effectiveColumnTop = UpdateOperatorImpl.calculatedEffectiveColumnTop(firstUpdatedPartitionRowId, columnTop);
            if (effectiveColumnTop <= -1L) continue;
            tableWriter.upsertColumnVersion(partitionTimestamp, updateColumnIndex, effectiveColumnTop);
        }
    }

    private void appendRowUpdate(int rowPartitionIndex, int affectedColumnCount, long prevRow, long currentRow, Record masterRecord, long firstUpdatedRowId) {
        TableRecordMetadata tableMetadata = this.tableWriter.getMetadata();
        long partitionTimestamp = this.tableWriter.getPartitionTimestamp(rowPartitionIndex);
        block20: for (int i = 0; i < affectedColumnCount; ++i) {
            MemoryCMR srcFixMem = this.srcColumns.get(2 * i);
            MemoryCMARW dstFixMem = this.dstColumns.get(2 * i);
            MemoryCMR srcVarMem = this.srcColumns.get(2 * i + 1);
            MemoryCMARW dstVarMem = this.dstColumns.get(2 * i + 1);
            int columnIndex = this.updateColumnIndexes.get(i);
            long oldColumnTop = this.tableWriter.getColumnTop(partitionTimestamp, columnIndex, -1L);
            long newColumnTop = UpdateOperatorImpl.calculatedEffectiveColumnTop(firstUpdatedRowId, oldColumnTop);
            int columnType = tableMetadata.getColumnType(columnIndex);
            if (currentRow > prevRow) {
                this.copyColumn(prevRow, currentRow, srcFixMem, srcVarMem, dstFixMem, dstVarMem, newColumnTop, oldColumnTop, columnType);
            }
            switch (ColumnType.tagOf(columnType)) {
                case 5: {
                    dstFixMem.putInt(masterRecord.getInt(i));
                    continue block20;
                }
                case 9: {
                    dstFixMem.putFloat(masterRecord.getFloat(i));
                    continue block20;
                }
                case 6: {
                    dstFixMem.putLong(masterRecord.getLong(i));
                    continue block20;
                }
                case 8: {
                    dstFixMem.putLong(masterRecord.getTimestamp(i));
                    continue block20;
                }
                case 7: {
                    dstFixMem.putLong(masterRecord.getDate(i));
                    continue block20;
                }
                case 10: {
                    dstFixMem.putDouble(masterRecord.getDouble(i));
                    continue block20;
                }
                case 3: {
                    dstFixMem.putShort(masterRecord.getShort(i));
                    continue block20;
                }
                case 4: {
                    dstFixMem.putChar(masterRecord.getChar(i));
                    continue block20;
                }
                case 2: {
                    dstFixMem.putByte(masterRecord.getByte(i));
                    continue block20;
                }
                case 1: {
                    dstFixMem.putBool(masterRecord.getBool(i));
                    continue block20;
                }
                case 14: {
                    dstFixMem.putByte(masterRecord.getGeoByte(i));
                    continue block20;
                }
                case 15: {
                    dstFixMem.putShort(masterRecord.getGeoShort(i));
                    continue block20;
                }
                case 16: {
                    dstFixMem.putInt(masterRecord.getGeoInt(i));
                    continue block20;
                }
                case 17: {
                    dstFixMem.putLong(masterRecord.getGeoLong(i));
                    continue block20;
                }
                case 12: {
                    dstFixMem.putInt(this.tableWriter.getSymbolIndexNoTransientCountUpdate(this.updateColumnIndexes.get(i), masterRecord.getSym(i)));
                    continue block20;
                }
                case 11: {
                    dstFixMem.putLong(dstVarMem.putStr(masterRecord.getStr(i)));
                    continue block20;
                }
                case 18: {
                    dstFixMem.putLong(dstVarMem.putBin(masterRecord.getBin(i)));
                    continue block20;
                }
                case 19: 
                case 24: {
                    dstFixMem.putLong(masterRecord.getLong128Lo(i));
                    dstFixMem.putLong(masterRecord.getLong128Hi(i));
                    continue block20;
                }
                default: {
                    throw CairoException.nonCritical().put("Column type ").put(ColumnType.nameOf(columnType)).put(" not supported for updates");
                }
            }
        }
    }

    private void configureColumns(RecordMetadata metadata, int columnCount) {
        block3: for (int i = this.dstColumns.size(); i < columnCount; ++i) {
            int columnType = metadata.getColumnType(this.updateColumnIndexes.get(i));
            switch (columnType) {
                default: {
                    this.srcColumns.add(Vm.getCMRInstance());
                    this.srcColumns.add(null);
                    this.dstColumns.add(Vm.getCMARWInstance());
                    this.dstColumns.add(null);
                    continue block3;
                }
                case 11: 
                case 18: {
                    this.srcColumns.add(Vm.getCMRInstance());
                    this.srcColumns.add(Vm.getCMRInstance());
                    this.dstColumns.add(Vm.getCMARWInstance());
                    this.dstColumns.add(Vm.getCMARWInstance());
                }
            }
        }
    }

    private void copyColumn(long prevRow, long maxRow, MemoryCMR srcFixMem, MemoryCMR srcVarMem, MemoryCMARW dstFixMem, MemoryCMARW dstVarMem, long newColumnTop, long oldColumnTop, int columnType) {
        assert (newColumnTop <= oldColumnTop || oldColumnTop < 0L);
        int shl = UpdateOperatorImpl.getFixedColumnSize(columnType);
        if (oldColumnTop == -1L && prevRow > 0L) {
            UpdateOperatorImpl.fillUpdatesGapWithNull(columnType, prevRow, maxRow, dstFixMem, dstVarMem, shl);
        }
        if (oldColumnTop == 0L) {
            this.copyValues(prevRow, maxRow, srcFixMem, srcVarMem, dstFixMem, dstVarMem, columnType, shl);
        }
        if (oldColumnTop > 0L) {
            if (prevRow >= oldColumnTop) {
                this.copyValues(prevRow - oldColumnTop, maxRow - oldColumnTop, srcFixMem, srcVarMem, dstFixMem, dstVarMem, columnType, shl);
            } else if (maxRow <= oldColumnTop) {
                if (prevRow > 0L) {
                    UpdateOperatorImpl.fillUpdatesGapWithNull(columnType, prevRow, maxRow, dstFixMem, dstVarMem, shl);
                }
            } else {
                if (prevRow > newColumnTop) {
                    UpdateOperatorImpl.fillUpdatesGapWithNull(columnType, prevRow, oldColumnTop, dstFixMem, dstVarMem, shl);
                }
                this.copyValues(0L, maxRow - oldColumnTop, srcFixMem, srcVarMem, dstFixMem, dstVarMem, columnType, shl);
            }
        }
    }

    private void copyColumns(int partitionIndex, int affectedColumnCount, long prevRow, long minRow) {
        TableRecordMetadata tableMetadata = this.tableWriter.getMetadata();
        long partitionTimestamp = this.tableWriter.getPartitionTimestamp(partitionIndex);
        long maxRow = this.tableWriter.getPartitionSize(partitionIndex);
        for (int i = 0; i < affectedColumnCount; ++i) {
            MemoryCMR srcFixMem = this.srcColumns.get(2 * i);
            MemoryCMR srcVarMem = this.srcColumns.get(2 * i + 1);
            MemoryCMARW dstFixMem = this.dstColumns.get(2 * i);
            MemoryCMARW dstVarMem = this.dstColumns.get(2 * i + 1);
            int columnIndex = this.updateColumnIndexes.getQuick(i);
            long oldColumnTop = this.tableWriter.getColumnTop(partitionTimestamp, columnIndex, -1L);
            long newColumnTop = UpdateOperatorImpl.calculatedEffectiveColumnTop(minRow, oldColumnTop);
            int columnType = tableMetadata.getColumnType(columnIndex);
            if (maxRow <= prevRow) continue;
            this.copyColumn(prevRow, maxRow, srcFixMem, srcVarMem, dstFixMem, dstVarMem, newColumnTop, oldColumnTop, columnType);
        }
    }

    private void copyValues(long fromRowId, long toRowId, MemoryCMR srcFixMem, MemoryCMR srcVarMem, MemoryCMARW dstFixMem, MemoryCMARW dstVarMem, int columnType, int shl) {
        long address = srcFixMem.addressOf(fromRowId << shl);
        switch (ColumnType.tagOf(columnType)) {
            case 11: 
            case 18: {
                long varStartOffset = srcFixMem.getLong(fromRowId * 8L);
                long varEndOffset = srcFixMem.getLong(toRowId * 8L);
                long varAddress = srcVarMem.addressOf(varStartOffset);
                long copyToOffset = dstVarMem.getAppendOffset();
                dstVarMem.putBlockOfBytes(varAddress, varEndOffset - varStartOffset);
                dstFixMem.extend(toRowId + 1L << shl);
                Vect.shiftCopyFixedSizeColumnData(varStartOffset - copyToOffset, address + 8L, 0L, toRowId - fromRowId - 1L, dstFixMem.getAppendAddress());
                dstFixMem.jumpTo(toRowId + 1L << shl);
                break;
            }
            default: {
                dstFixMem.putBlockOfBytes(address, toRowId - fromRowId << shl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openColumns(ObjList<? extends MemoryCM> columns, int partitionIndex, boolean forWrite) {
        long partitionTimestamp = this.tableWriter.getPartitionTimestamp(partitionIndex);
        long partitionNameTxn = this.tableWriter.getPartitionNameTxn(partitionIndex);
        TableRecordMetadata metadata = this.tableWriter.getMetadata();
        try {
            this.path.trimTo(this.rootLen);
            TableUtils.setPathForPartition(this.path, this.tableWriter.getPartitionBy(), partitionTimestamp, false);
            TableUtils.txnPartitionConditionally(this.path, partitionNameTxn);
            int pathTrimToLen = this.path.length();
            int n = this.updateColumnIndexes.size();
            for (int i = 0; i < n; ++i) {
                int columnIndex = this.updateColumnIndexes.get(i);
                String name = metadata.getColumnName(columnIndex);
                int columnType = metadata.getColumnType(columnIndex);
                long columnTop = this.tableWriter.getColumnTop(partitionTimestamp, columnIndex, -1L);
                if (forWrite) {
                    long existingVersion = this.tableWriter.getColumnNameTxn(partitionTimestamp, columnIndex);
                    this.tableWriter.upsertColumnVersion(partitionTimestamp, columnIndex, columnTop);
                    if (columnTop > -1L) {
                        this.cleanupColumnVersions.add(columnIndex, existingVersion, partitionTimestamp, partitionNameTxn);
                    }
                }
                long columnNameTxn = this.tableWriter.getColumnNameTxn(partitionTimestamp, columnIndex);
                if (ColumnType.isVariableLength(columnType)) {
                    MemoryCMR colMemIndex = (MemoryCMR)columns.get(2 * i);
                    colMemIndex.close();
                    assert (!colMemIndex.isOpen());
                    MemoryCMR colMemVar = (MemoryCMR)columns.get(2 * i + 1);
                    colMemVar.close();
                    assert (!colMemVar.isOpen());
                    if (forWrite || columnTop != -1L) {
                        colMemIndex.of(this.ff, TableUtils.iFile(this.path.trimTo(pathTrimToLen), name, columnNameTxn), this.dataAppendPageSize, -1L, 27, this.fileOpenOpts);
                        colMemVar.of(this.ff, TableUtils.dFile(this.path.trimTo(pathTrimToLen), name, columnNameTxn), this.dataAppendPageSize, -1L, 27, this.fileOpenOpts);
                    }
                } else {
                    MemoryCMR colMem = (MemoryCMR)columns.get(2 * i);
                    colMem.close();
                    assert (!colMem.isOpen());
                    if (forWrite || columnTop != -1L) {
                        colMem.of(this.ff, TableUtils.dFile(this.path.trimTo(pathTrimToLen), name, columnNameTxn), this.dataAppendPageSize, -1L, 27, this.fileOpenOpts);
                    }
                }
                if (!forWrite || !ColumnType.isVariableLength(columnType)) continue;
                ((MemoryCMARW)columns.get(2 * i)).putLong(0L);
            }
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    private void rebuildIndexes(long partitionTimestamp, TableRecordMetadata tableMetadata, TableWriter tableWriter) {
        int pathTrimToLen = this.path.length();
        this.indexBuilder.of(this.path.trimTo(this.rootLen), this.configuration);
        int n = this.updateColumnIndexes.size();
        for (int i = 0; i < n; ++i) {
            int columnIndex = this.updateColumnIndexes.get(i);
            if (!tableMetadata.isColumnIndexed(columnIndex)) continue;
            String colName = tableMetadata.getColumnName(columnIndex);
            this.indexBuilder.reindexAfterUpdate(partitionTimestamp, colName, tableWriter);
        }
        this.indexBuilder.clear();
        this.path.trimTo(pathTrimToLen);
    }
}

