/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.GeoByteFunction;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;

public class FirstGeoHashGroupByFunctionByte
extends GeoByteFunction
implements GroupByFunction,
UnaryFunction {
    protected final Function function;
    protected int valueIndex;

    public FirstGeoHashGroupByFunctionByte(int type, Function function) {
        super(type);
        this.function = function;
    }

    @Override
    public void computeFirst(MapValue mapValue, Record record) {
        mapValue.putByte(this.valueIndex, this.function.getGeoByte(record));
    }

    @Override
    public void computeNext(MapValue mapValue, Record record) {
    }

    @Override
    public Function getArg() {
        return this.function;
    }

    @Override
    public byte getGeoByte(Record rec) {
        return rec.getGeoByte(this.valueIndex);
    }

    @Override
    public int getGeoInt(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getGeoLong(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public short getGeoShort(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        return "first";
    }

    @Override
    public void pushValueTypes(ArrayColumnTypes columnTypes) {
        this.valueIndex = columnTypes.getColumnCount();
        columnTypes.add(2);
    }

    @Override
    public void setByte(MapValue mapValue, byte value) {
        mapValue.putByte(this.valueIndex, value);
    }

    @Override
    public void setNull(MapValue mapValue) {
        this.setByte(mapValue, (byte)-1);
    }
}

