/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.sql.DataFrame;
import io.questdb.cairo.sql.DataFrameCursor;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.Plannable;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.AbstractDataFrameRecordCursor;
import io.questdb.std.IntList;
import org.jetbrains.annotations.NotNull;

class LatestByValueRecordCursor
extends AbstractDataFrameRecordCursor
implements Plannable {
    private final int columnIndex;
    private final int symbolKey;
    private boolean empty;
    private boolean hasNext;

    public LatestByValueRecordCursor(int columnIndex, int symbolKey, @NotNull IntList columnIndexes) {
        super(columnIndexes);
        this.columnIndex = columnIndex;
        this.symbolKey = symbolKey;
    }

    @Override
    public boolean hasNext() {
        if (this.hasNext) {
            this.hasNext = false;
            return true;
        }
        return false;
    }

    @Override
    public long size() {
        return -1L;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Row backward scan");
        sink.attr("symbolFilter").putColumnName(this.columnIndex).val('=').val(this.symbolKey);
    }

    @Override
    public void toTop() {
        this.hasNext = !this.empty;
    }

    private void findRecord(SqlExecutionContext executionContext) {
        DataFrame frame;
        SqlExecutionCircuitBreaker circuitBreaker = executionContext.getCircuitBreaker();
        this.empty = true;
        block0: while ((frame = this.dataFrameCursor.next()) != null) {
            long rowLo = frame.getRowLo();
            long rowHi = frame.getRowHi() - 1L;
            this.recordA.jumpTo(frame.getPartitionIndex(), rowHi);
            for (long row = rowHi; row >= rowLo; --row) {
                circuitBreaker.statefulThrowExceptionIfTripped();
                this.recordA.setRecordIndex(row);
                int key = this.recordA.getInt(this.columnIndex);
                if (key != this.symbolKey) continue;
                this.empty = false;
                break block0;
            }
        }
    }

    @Override
    void of(DataFrameCursor dataFrameCursor, SqlExecutionContext executionContext) {
        this.dataFrameCursor = dataFrameCursor;
        this.recordA.of(dataFrameCursor.getTableReader());
        this.recordB.of(dataFrameCursor.getTableReader());
        this.findRecord(executionContext);
        this.toTop();
    }
}

