/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.AbstractCharSequenceHashSet;
import io.questdb.std.Chars;
import io.questdb.std.Numbers;
import java.util.Arrays;

public class CompactCharSequenceHashSet
extends AbstractCharSequenceHashSet {
    private static final int MIN_INITIAL_CAPACITY = 16;

    public CompactCharSequenceHashSet() {
        this(16);
    }

    private CompactCharSequenceHashSet(int initialCapacity) {
        this(initialCapacity, 0.6);
    }

    private CompactCharSequenceHashSet(int initialCapacity, double loadFactor) {
        super(initialCapacity, loadFactor);
        this.clear();
    }

    public boolean add(CharSequence key) {
        int index = this.keyIndex(key);
        if (index < 0) {
            return false;
        }
        this.addAt(index, key);
        return true;
    }

    public void addAt(int index, CharSequence key) {
        String s = Chars.toString(key);
        this.keys[index] = s;
        if (--this.free < 1) {
            this.rehash();
        }
    }

    @Override
    public boolean contains(CharSequence key) {
        return this.keyIndex(key) < 0;
    }

    @Override
    public boolean excludes(CharSequence key) {
        return this.keyIndex(key) > -1;
    }

    @Override
    public CharSequence keyAt(int index) {
        int index1 = -index - 1;
        return this.keys[index1];
    }

    @Override
    public int remove(CharSequence key) {
        int keyIndex = this.keyIndex(key);
        if (keyIndex < 0) {
            this.removeAt(keyIndex);
            return -keyIndex - 1;
        }
        return -1;
    }

    public String toString() {
        return Arrays.toString(this.keys);
    }

    private void rehash() {
        int newCapacity;
        this.free = this.capacity = (newCapacity = this.capacity * 2);
        int len = Numbers.ceilPow2((int)((double)newCapacity / this.loadFactor));
        CharSequence[] oldKeys = this.keys;
        this.keys = new CharSequence[len];
        this.mask = len - 1;
        for (CharSequence key : oldKeys) {
            if (key == noEntryKey) continue;
            this.keys[this.keyIndex((CharSequence)key)] = key;
            --this.free;
        }
    }

    @Override
    protected void erase(int index) {
        this.keys[index] = noEntryKey;
    }

    @Override
    protected void move(int from, int to) {
        this.keys[to] = this.keys[from];
        this.erase(from);
    }
}

