/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.configuration;

import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.deprecation.log.DeprecationLogger;
import org.apache.nifi.deprecation.log.DeprecationLoggerFactory;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.security.knox.KnoxAuthenticationFilter;
import org.apache.nifi.web.security.knox.KnoxAuthenticationProvider;
import org.apache.nifi.web.security.knox.KnoxService;
import org.apache.nifi.web.security.knox.KnoxServiceFactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;

@Configuration
public class KnoxAuthenticationSecurityConfiguration {
    private static final DeprecationLogger deprecationLogger = DeprecationLoggerFactory.getLogger(KnoxAuthenticationSecurityConfiguration.class);
    private final NiFiProperties niFiProperties;
    private final Authorizer authorizer;

    @Autowired
    public KnoxAuthenticationSecurityConfiguration(NiFiProperties niFiProperties, Authorizer authorizer) {
        this.niFiProperties = niFiProperties;
        this.authorizer = authorizer;
        if (niFiProperties.isKnoxSsoEnabled()) {
            deprecationLogger.warn("Support for Apache Knox Single Sign-On authentication is deprecated for removal in NiFi 2", new Object[0]);
        }
    }

    @Bean
    public KnoxAuthenticationFilter knoxAuthenticationFilter(AuthenticationManager authenticationManager) {
        KnoxAuthenticationFilter knoxAuthenticationFilter = new KnoxAuthenticationFilter();
        knoxAuthenticationFilter.setAuthenticationManager(authenticationManager);
        knoxAuthenticationFilter.setProperties(this.niFiProperties);
        return knoxAuthenticationFilter;
    }

    @Bean
    public KnoxAuthenticationProvider knoxAuthenticationProvider() {
        return new KnoxAuthenticationProvider(this.knoxService(), this.niFiProperties, this.authorizer);
    }

    @Bean
    public KnoxService knoxService() {
        KnoxServiceFactoryBean knoxServiceFactoryBean = new KnoxServiceFactoryBean();
        knoxServiceFactoryBean.setProperties(this.niFiProperties);
        return knoxServiceFactoryBean.getObject();
    }
}

