/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.pg;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.nifi.VersionControlInfoResult;
import org.apache.nifi.web.api.entity.ProcessGroupEntity;
import org.apache.nifi.web.api.entity.VersionControlInformationEntity;

public class PGStopVersionControl
extends AbstractNiFiCommand<VersionControlInfoResult> {
    public PGStopVersionControl() {
        super("pg-stop-version-control", VersionControlInfoResult.class);
    }

    @Override
    public String getDescription() {
        return "Stops version control for the specified process group.";
    }

    @Override
    protected void doInitialize(Context context) {
        this.addOption(CommandOption.PG_ID.createOption());
    }

    @Override
    public VersionControlInfoResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException, CommandException {
        String pgId = this.getRequiredArg(properties, CommandOption.PG_ID);
        ProcessGroupEntity pgEntity = client.getProcessGroupClient().getProcessGroup(pgId);
        VersionControlInformationEntity entity = client.getVersionsClient().stopVersionControl(pgEntity);
        return new VersionControlInfoResult(this.getResultType(properties), entity);
    }
}

