/*
 * Decompiled with CFR 0.152.
 */
package v14.h2.expression;

import v14.h2.engine.Session;
import v14.h2.expression.Expression;
import v14.h2.expression.ExpressionVisitor;
import v14.h2.expression.ValueExpression;
import v14.h2.table.ColumnResolver;
import v14.h2.table.TableFilter;
import v14.h2.value.TypeInfo;
import v14.h2.value.Value;
import v14.h2.value.ValueJson;

public class Format
extends Expression {
    private Expression expr;
    private final FormatEnum format;

    public Format(Expression expression, FormatEnum formatEnum) {
        this.expr = expression;
        this.format = formatEnum;
    }

    @Override
    public Value getValue(Session session) {
        return this.getValue(this.expr.getValue(session));
    }

    public Value getValue(Value value) {
        switch (value.getValueType()) {
            case 0: {
                return ValueJson.NULL;
            }
            case 13: 
            case 14: 
            case 16: 
            case 21: {
                return ValueJson.fromJson(value.getString());
            }
        }
        return value.convertTo(40);
    }

    @Override
    public TypeInfo getType() {
        return TypeInfo.TYPE_JSON;
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n, int n2) {
        this.expr.mapColumns(columnResolver, n, n2);
    }

    @Override
    public Expression optimize(Session session) {
        this.expr = this.expr.optimize(session);
        if (this.expr.isConstant()) {
            return ValueExpression.get(this.getValue(session));
        }
        if (this.expr instanceof Format && this.format == ((Format)this.expr).format) {
            return this.expr;
        }
        return this;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        this.expr.setEvaluatable(tableFilter, bl);
    }

    @Override
    public boolean isAutoIncrement() {
        return this.expr.isAutoIncrement();
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, boolean bl) {
        return this.expr.getSQL(stringBuilder, bl).append(" FORMAT ").append(this.format.name());
    }

    @Override
    public void updateAggregate(Session session, int n) {
        this.expr.updateAggregate(session, n);
    }

    @Override
    public int getNullable() {
        return this.expr.getNullable();
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        return this.expr.isEverything(expressionVisitor);
    }

    @Override
    public int getCost() {
        return this.expr.getCost();
    }

    @Override
    public String getTableName() {
        return this.expr.getTableName();
    }

    @Override
    public String getColumnName() {
        return this.expr.getColumnName();
    }

    @Override
    public int getSubexpressionCount() {
        return 1;
    }

    @Override
    public Expression getSubexpression(int n) {
        if (n != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.expr;
    }

    public static enum FormatEnum {
        JSON;

    }
}

