/*
 * Decompiled with CFR 0.152.
 */
package v14.h2.store.fs;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import v14.h2.security.AES;
import v14.h2.security.BlockCipher;
import v14.h2.security.SHA256;
import v14.h2.store.fs.FileBase;
import v14.h2.store.fs.FileChannelInputStream;
import v14.h2.store.fs.FileChannelOutputStream;
import v14.h2.store.fs.FilePath;
import v14.h2.store.fs.FilePathWrapper;
import v14.h2.store.fs.FileUtils;
import v14.h2.util.MathUtils;

public class FilePathEncrypt
extends FilePathWrapper {
    private static final String SCHEME = "encrypt";

    public static void register() {
        FilePath.register(new FilePathEncrypt());
    }

    @Override
    public FileChannel open(String string) throws IOException {
        String[] stringArray = this.parse(this.name);
        FileChannel fileChannel = FileUtils.open(stringArray[1], string);
        byte[] byArray = stringArray[0].getBytes(StandardCharsets.UTF_8);
        return new FileEncrypt(this.name, byArray, fileChannel);
    }

    @Override
    public String getScheme() {
        return SCHEME;
    }

    @Override
    protected String getPrefix() {
        String[] stringArray = this.parse(this.name);
        return this.getScheme() + ":" + stringArray[0] + ":";
    }

    @Override
    public FilePath unwrap(String string) {
        return FilePath.get(this.parse(string)[1]);
    }

    @Override
    public long size() {
        long l = this.getBase().size() - 4096L;
        if (((l = Math.max(0L, l)) & 0xFFFL) != 0L) {
            l -= 4096L;
        }
        return l;
    }

    @Override
    public OutputStream newOutputStream(boolean bl) throws IOException {
        return new FileChannelOutputStream(this.open("rw"), bl);
    }

    @Override
    public InputStream newInputStream() throws IOException {
        return new FileChannelInputStream(this.open("r"), true);
    }

    private String[] parse(String string) {
        if (!string.startsWith(this.getScheme())) {
            throw new IllegalArgumentException(string + " doesn't start with " + this.getScheme());
        }
        int n = (string = string.substring(this.getScheme().length() + 1)).indexOf(58);
        if (n < 0) {
            throw new IllegalArgumentException(string + " doesn't contain encryption algorithm and password");
        }
        String string2 = string.substring(0, n);
        string = string.substring(n + 1);
        return new String[]{string2, string};
    }

    public static byte[] getPasswordBytes(char[] cArray) {
        int n = cArray.length;
        byte[] byArray = new byte[n * 2];
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            byArray[i + i] = (byte)(c >>> 8);
            byArray[i + i + 1] = (byte)c;
        }
        return byArray;
    }

    static class XTS {
        private static final int GF_128_FEEDBACK = 135;
        private static final int CIPHER_BLOCK_SIZE = 16;
        private final BlockCipher cipher;

        XTS(BlockCipher blockCipher) {
            this.cipher = blockCipher;
        }

        void encrypt(long l, int n, byte[] byArray, int n2) {
            byte[] byArray2 = this.initTweak(l);
            int n3 = 0;
            while (n3 + 16 <= n) {
                if (n3 > 0) {
                    XTS.updateTweak(byArray2);
                }
                XTS.xorTweak(byArray, n3 + n2, byArray2);
                this.cipher.encrypt(byArray, n3 + n2, 16);
                XTS.xorTweak(byArray, n3 + n2, byArray2);
                n3 += 16;
            }
            if (n3 < n) {
                XTS.updateTweak(byArray2);
                XTS.swap(byArray, n3 + n2, n3 - 16 + n2, n - n3);
                XTS.xorTweak(byArray, n3 - 16 + n2, byArray2);
                this.cipher.encrypt(byArray, n3 - 16 + n2, 16);
                XTS.xorTweak(byArray, n3 - 16 + n2, byArray2);
            }
        }

        void decrypt(long l, int n, byte[] byArray, int n2) {
            byte[] byArray2;
            byte[] byArray3 = byArray2 = this.initTweak(l);
            int n3 = 0;
            while (n3 + 16 <= n) {
                if (n3 > 0) {
                    XTS.updateTweak(byArray2);
                    if (n3 + 16 + 16 > n && n3 + 16 < n) {
                        byArray3 = (byte[])byArray2.clone();
                        XTS.updateTweak(byArray2);
                    }
                }
                XTS.xorTweak(byArray, n3 + n2, byArray2);
                this.cipher.decrypt(byArray, n3 + n2, 16);
                XTS.xorTweak(byArray, n3 + n2, byArray2);
                n3 += 16;
            }
            if (n3 < n) {
                XTS.swap(byArray, n3, n3 - 16 + n2, n - n3 + n2);
                XTS.xorTweak(byArray, n3 - 16 + n2, byArray3);
                this.cipher.decrypt(byArray, n3 - 16 + n2, 16);
                XTS.xorTweak(byArray, n3 - 16 + n2, byArray3);
            }
        }

        private byte[] initTweak(long l) {
            byte[] byArray = new byte[16];
            int n = 0;
            while (n < 16) {
                byArray[n] = (byte)(l & 0xFFL);
                ++n;
                l >>>= 8;
            }
            this.cipher.encrypt(byArray, 0, 16);
            return byArray;
        }

        private static void xorTweak(byte[] byArray, int n, byte[] byArray2) {
            for (int i = 0; i < 16; ++i) {
                int n2 = n + i;
                byArray[n2] = (byte)(byArray[n2] ^ byArray2[i]);
            }
        }

        private static void updateTweak(byte[] byArray) {
            int n = 0;
            byte by = 0;
            for (int i = 0; i < 16; ++i) {
                by = (byte)(byArray[i] >> 7 & 1);
                byArray[i] = (byte)((byArray[i] << 1) + n & 0xFF);
                n = by;
            }
            if (by != 0) {
                byArray[0] = (byte)(byArray[0] ^ 0x87);
            }
        }

        private static void swap(byte[] byArray, int n, int n2, int n3) {
            for (int i = 0; i < n3; ++i) {
                byte by = byArray[n + i];
                byArray[n + i] = byArray[n2 + i];
                byArray[n2 + i] = by;
            }
        }
    }

    public static class FileEncrypt
    extends FileBase {
        static final int BLOCK_SIZE = 4096;
        static final int BLOCK_SIZE_MASK = 4095;
        static final int HEADER_LENGTH = 4096;
        private static final byte[] HEADER = "H2encrypt\n".getBytes();
        private static final int SALT_POS = HEADER.length;
        private static final int SALT_LENGTH = 8;
        private static final int HASH_ITERATIONS = 10;
        private final FileChannel base;
        private long pos;
        private long size;
        private final String name;
        private XTS xts;
        private byte[] encryptionKey;

        public FileEncrypt(String string, byte[] byArray, FileChannel fileChannel) {
            this.name = string;
            this.base = fileChannel;
            this.encryptionKey = byArray;
        }

        private void init() throws IOException {
            byte[] byArray;
            Object object;
            boolean bl;
            if (this.xts != null) {
                return;
            }
            this.size = this.base.size() - 4096L;
            boolean bl2 = bl = this.size < 0L;
            if (bl) {
                object = Arrays.copyOf(HEADER, 4096);
                byArray = MathUtils.secureRandomBytes(8);
                System.arraycopy(byArray, 0, object, SALT_POS, byArray.length);
                FileEncrypt.writeFully(this.base, 0L, ByteBuffer.wrap((byte[])object));
                this.size = 0L;
            } else {
                byArray = new byte[8];
                FileEncrypt.readFully(this.base, SALT_POS, ByteBuffer.wrap(byArray));
                if ((this.size & 0xFFFL) != 0L) {
                    this.size -= 4096L;
                }
            }
            object = new AES();
            ((AES)object).setKey(SHA256.getPBKDF2(this.encryptionKey, byArray, 10, 16));
            this.encryptionKey = null;
            this.xts = new XTS((BlockCipher)object);
        }

        @Override
        protected void implCloseChannel() throws IOException {
            this.base.close();
        }

        @Override
        public FileChannel position(long l) throws IOException {
            this.pos = l;
            return this;
        }

        @Override
        public long position() throws IOException {
            return this.pos;
        }

        @Override
        public int read(ByteBuffer byteBuffer) throws IOException {
            int n = this.read(byteBuffer, this.pos);
            if (n > 0) {
                this.pos += (long)n;
            }
            return n;
        }

        @Override
        public int read(ByteBuffer byteBuffer, long l) throws IOException {
            int n = byteBuffer.remaining();
            if (n == 0) {
                return 0;
            }
            this.init();
            n = (int)Math.min((long)n, this.size - l);
            if (l >= this.size) {
                return -1;
            }
            if (l < 0L) {
                throw new IllegalArgumentException("pos: " + l);
            }
            if ((l & 0xFFFL) != 0L || (n & 0xFFF) != 0) {
                long l2 = l / 4096L * 4096L;
                int n2 = (int)(l - l2);
                int n3 = (n + n2 + 4096 - 1) / 4096 * 4096;
                ByteBuffer byteBuffer2 = ByteBuffer.allocate(n3);
                this.readInternal(byteBuffer2, l2, n3);
                byteBuffer2.flip();
                byteBuffer2.limit(n2 + n);
                byteBuffer2.position(n2);
                byteBuffer.put(byteBuffer2);
                return n;
            }
            this.readInternal(byteBuffer, l, n);
            return n;
        }

        private void readInternal(ByteBuffer byteBuffer, long l, int n) throws IOException {
            int n2 = byteBuffer.position();
            FileEncrypt.readFully(this.base, l + 4096L, byteBuffer);
            long l2 = l / 4096L;
            while (n > 0) {
                this.xts.decrypt(l2++, 4096, byteBuffer.array(), byteBuffer.arrayOffset() + n2);
                n2 += 4096;
                n -= 4096;
            }
        }

        private static void readFully(FileChannel fileChannel, long l, ByteBuffer byteBuffer) throws IOException {
            do {
                int n;
                if ((n = fileChannel.read(byteBuffer, l)) < 0) {
                    throw new EOFException();
                }
                l += (long)n;
            } while (byteBuffer.remaining() > 0);
        }

        @Override
        public int write(ByteBuffer byteBuffer, long l) throws IOException {
            this.init();
            int n = byteBuffer.remaining();
            if ((l & 0xFFFL) != 0L || (n & 0xFFF) != 0) {
                long l2 = l / 4096L * 4096L;
                int n2 = (int)(l - l2);
                int n3 = (n + n2 + 4096 - 1) / 4096 * 4096;
                ByteBuffer byteBuffer2 = ByteBuffer.allocate(n3);
                int n4 = (int)(this.size - l2 + 4096L - 1L) / 4096 * 4096;
                int n5 = Math.min(n3, n4);
                if (n5 > 0) {
                    this.readInternal(byteBuffer2, l2, n5);
                    byteBuffer2.rewind();
                }
                byteBuffer2.limit(n2 + n);
                byteBuffer2.position(n2);
                byteBuffer2.put(byteBuffer);
                byteBuffer2.limit(n3);
                byteBuffer2.rewind();
                this.writeInternal(byteBuffer2, l2, n3);
                long l3 = l + (long)n;
                this.size = Math.max(this.size, l3);
                int n6 = (int)(this.size & 0xFFFL);
                if (n6 > 0) {
                    byteBuffer2 = ByteBuffer.allocate(n6);
                    FileEncrypt.writeFully(this.base, l2 + 4096L + (long)n3, byteBuffer2);
                }
                return n;
            }
            this.writeInternal(byteBuffer, l, n);
            long l4 = l + (long)n;
            this.size = Math.max(this.size, l4);
            return n;
        }

        private void writeInternal(ByteBuffer byteBuffer, long l, int n) throws IOException {
            ByteBuffer byteBuffer2 = ByteBuffer.allocate(n);
            byteBuffer2.put(byteBuffer);
            byteBuffer2.flip();
            long l2 = l / 4096L;
            int n2 = 0;
            for (int i = n; i > 0; i -= 4096) {
                this.xts.encrypt(l2++, 4096, byteBuffer2.array(), byteBuffer2.arrayOffset() + n2);
                n2 += 4096;
            }
            FileEncrypt.writeFully(this.base, l + 4096L, byteBuffer2);
        }

        private static void writeFully(FileChannel fileChannel, long l, ByteBuffer byteBuffer) throws IOException {
            int n = 0;
            do {
                int n2 = fileChannel.write(byteBuffer, l + (long)n);
                n += n2;
            } while (byteBuffer.remaining() > 0);
        }

        @Override
        public int write(ByteBuffer byteBuffer) throws IOException {
            int n = this.write(byteBuffer, this.pos);
            if (n > 0) {
                this.pos += (long)n;
            }
            return n;
        }

        @Override
        public long size() throws IOException {
            this.init();
            return this.size;
        }

        @Override
        public FileChannel truncate(long l) throws IOException {
            this.init();
            if (l > this.size) {
                return this;
            }
            if (l < 0L) {
                throw new IllegalArgumentException("newSize: " + l);
            }
            int n = (int)(l & 0xFFFL);
            if (n > 0) {
                this.base.truncate(l + 4096L + 4096L);
            } else {
                this.base.truncate(l + 4096L);
            }
            this.size = l;
            this.pos = Math.min(this.pos, this.size);
            return this;
        }

        @Override
        public void force(boolean bl) throws IOException {
            this.base.force(bl);
        }

        @Override
        public FileLock tryLock(long l, long l2, boolean bl) throws IOException {
            return this.base.tryLock(l, l2, bl);
        }

        public String toString() {
            return this.name;
        }
    }
}

