/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.toolkit.schema.v2;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.nifi.minifi.toolkit.schema.ConfigSchema;
import org.apache.nifi.minifi.toolkit.schema.ConnectionSchema;
import org.apache.nifi.minifi.toolkit.schema.FunnelSchema;
import org.apache.nifi.minifi.toolkit.schema.PortSchema;
import org.apache.nifi.minifi.toolkit.schema.ProcessGroupSchema;
import org.apache.nifi.minifi.toolkit.schema.ProcessorSchema;
import org.apache.nifi.minifi.toolkit.schema.common.BaseSchemaWithId;
import org.apache.nifi.minifi.toolkit.schema.common.BaseSchemaWithIdAndName;
import org.apache.nifi.minifi.toolkit.schema.common.CommonPropertyKeys;
import org.apache.nifi.minifi.toolkit.schema.common.ConvertableSchema;
import org.apache.nifi.minifi.toolkit.schema.common.StringUtil;
import org.apache.nifi.minifi.toolkit.schema.common.WritableSchema;
import org.apache.nifi.minifi.toolkit.schema.v2.RemoteProcessGroupSchemaV2;

public class ProcessGroupSchemaV2
extends BaseSchemaWithIdAndName
implements WritableSchema,
ConvertableSchema<ProcessGroupSchema> {
    public static final String PROCESS_GROUPS_KEY = "Process Groups";
    public static final String ID_DEFAULT = "Root-Group";
    private String comment;
    private List<ProcessorSchema> processors;
    private List<FunnelSchema> funnels;
    private List<ConnectionSchema> connections;
    private List<RemoteProcessGroupSchemaV2> remoteProcessGroups;
    private List<ProcessGroupSchemaV2> processGroupSchemas;
    private List<PortSchema> inputPortSchemas;
    private List<PortSchema> outputPortSchemas;

    public ProcessGroupSchemaV2(Map map, String wrapperName) {
        super(map, wrapperName);
        this.processors = this.getOptionalKeyAsList(map, "Processors", ProcessorSchema::new, wrapperName);
        this.funnels = this.getOptionalKeyAsList(map, "Funnels", FunnelSchema::new, wrapperName);
        this.remoteProcessGroups = this.getOptionalKeyAsList(map, "Remote Process Groups", RemoteProcessGroupSchemaV2::new, wrapperName);
        this.connections = this.getOptionalKeyAsList(map, "Connections", ConnectionSchema::new, wrapperName);
        this.inputPortSchemas = this.getOptionalKeyAsList(map, "Input Ports", m -> new PortSchema((Map)m, "InputPort(id: {id}, name: {name})"), wrapperName);
        this.outputPortSchemas = this.getOptionalKeyAsList(map, "Output Ports", m -> new PortSchema((Map)m, "OutputPort(id: {id}, name: {name})"), wrapperName);
        this.processGroupSchemas = this.getOptionalKeyAsList(map, PROCESS_GROUPS_KEY, m -> new ProcessGroupSchemaV2((Map)m, "ProcessGroup(id: {id}, name: {name})"), wrapperName);
        if (ConfigSchema.TOP_LEVEL_NAME.equals(wrapperName)) {
            if (this.inputPortSchemas.size() > 0) {
                this.addValidationIssue("Input Ports", wrapperName, "must be empty in root group as external input/output ports are currently unsupported");
            }
            if (this.outputPortSchemas.size() > 0) {
                this.addValidationIssue("Output Ports", wrapperName, "must be empty in root group as external input/output ports are currently unsupported");
            }
        } else if (ID_DEFAULT.equals(this.getId())) {
            this.addValidationIssue("id", wrapperName, "must be set to a value not Root-Group if not in root group");
        }
        Set<String> portIds = this.getPortIds();
        this.connections.stream().filter(c -> portIds.contains(c.getSourceId())).forEachOrdered(c -> c.setNeedsSourceRelationships(false));
        HashSet funnelIds = new HashSet(this.funnels.stream().map(BaseSchemaWithId::getId).collect(Collectors.toList()));
        this.connections.stream().filter(c -> funnelIds.contains(c.getSourceId())).forEachOrdered(c -> c.setNeedsSourceRelationships(false));
        this.addIssuesIfNotNull(this.processors);
        this.addIssuesIfNotNull(this.remoteProcessGroups);
        this.addIssuesIfNotNull(this.processGroupSchemas);
        this.addIssuesIfNotNull(this.funnels);
        this.addIssuesIfNotNull(this.connections);
    }

    @Override
    public Map<String, Object> toMap() {
        Map result = (Map)this.mapSupplier.get();
        String id = this.getId();
        if (!ID_DEFAULT.equals(id)) {
            result.put("id", id);
        }
        StringUtil.doIfNotNullOrEmpty(this.getName(), name -> result.put("name", name));
        ProcessGroupSchemaV2.putListIfNotNull(result, "Processors", this.processors);
        ProcessGroupSchemaV2.putListIfNotNull(result, PROCESS_GROUPS_KEY, this.processGroupSchemas);
        ProcessGroupSchemaV2.putListIfNotNull(result, "Input Ports", this.inputPortSchemas);
        ProcessGroupSchemaV2.putListIfNotNull(result, "Output Ports", this.outputPortSchemas);
        ProcessGroupSchemaV2.putListIfNotNull(result, "Funnels", this.funnels);
        ProcessGroupSchemaV2.putListIfNotNull(result, "Connections", this.connections);
        ProcessGroupSchemaV2.putListIfNotNull(result, "Remote Process Groups", this.remoteProcessGroups.stream().map(RemoteProcessGroupSchemaV2::convert).collect(Collectors.toList()));
        return result;
    }

    public List<ProcessorSchema> getProcessors() {
        return this.processors;
    }

    public List<FunnelSchema> getFunnels() {
        return this.funnels;
    }

    public List<ConnectionSchema> getConnections() {
        return this.connections;
    }

    public List<RemoteProcessGroupSchemaV2> getRemoteProcessGroups() {
        return this.remoteProcessGroups;
    }

    public List<ProcessGroupSchemaV2> getProcessGroupSchemas() {
        return this.processGroupSchemas;
    }

    public Set<String> getPortIds() {
        HashSet<String> result = new HashSet<String>();
        this.inputPortSchemas.stream().map(BaseSchemaWithId::getId).forEachOrdered(result::add);
        this.outputPortSchemas.stream().map(BaseSchemaWithId::getId).forEachOrdered(result::add);
        this.processGroupSchemas.stream().flatMap(p -> p.getPortIds().stream()).forEachOrdered(result::add);
        return result;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    protected String getId(Map map, String wrapperName) {
        return this.getOptionalKeyAsType(map, "id", String.class, wrapperName, ID_DEFAULT);
    }

    @Override
    public ProcessGroupSchema convert() {
        Map<String, Object> map = this.toMap();
        map.put("Controller Services", CommonPropertyKeys.DEFAULT_PROPERTIES);
        return new ProcessGroupSchema(map, this.getWrapperName());
    }

    @Override
    public int getVersion() {
        return 3;
    }

    public List<PortSchema> getOutputPortSchemas() {
        return this.outputPortSchemas;
    }

    public List<PortSchema> getInputPortSchemas() {
        return this.inputPortSchemas;
    }

    @Override
    protected boolean isValidId(String value) {
        if (ID_DEFAULT.equals(value)) {
            return true;
        }
        return super.isValidId(value);
    }
}

