/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.cast;

import org.apache.nifi.attribute.expression.language.EvaluationContext;
import org.apache.nifi.attribute.expression.language.evaluation.DateQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.DecimalQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.InstantQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.NumberEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.NumberQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.StringQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.WholeNumberQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.util.NumberParsing;
import org.apache.nifi.attribute.expression.language.exception.AttributeExpressionLanguageParsingException;
import org.apache.nifi.expression.AttributeExpression;

public class NumberCastEvaluator
extends NumberEvaluator {
    private final Evaluator<?> subjectEvaluator;

    public NumberCastEvaluator(Evaluator<?> subjectEvaluator) {
        if (subjectEvaluator.getResultType() == AttributeExpression.ResultType.BOOLEAN) {
            throw new AttributeExpressionLanguageParsingException("Cannot implicitly convert Data Type " + String.valueOf(subjectEvaluator.getResultType()) + " to " + String.valueOf(AttributeExpression.ResultType.WHOLE_NUMBER));
        }
        this.subjectEvaluator = subjectEvaluator;
    }

    @Override
    public QueryResult<Number> evaluate(EvaluationContext evaluationContext) {
        QueryResult<?> result = this.subjectEvaluator.evaluate(evaluationContext);
        if (result.getValue() == null) {
            return new NumberQueryResult(null);
        }
        switch (result.getResultType()) {
            case NUMBER: {
                return (NumberQueryResult)result;
            }
            case WHOLE_NUMBER: {
                Long longValue = ((WholeNumberQueryResult)result).getValue();
                return new NumberQueryResult(longValue);
            }
            case DECIMAL: {
                Double doubleValue = ((DecimalQueryResult)result).getValue();
                return new NumberQueryResult(doubleValue);
            }
            case STRING: {
                String trimmed = ((StringQueryResult)result).getValue().trim();
                NumberParsing.ParseResultType parseType = NumberParsing.parse(trimmed);
                switch (parseType) {
                    case DECIMAL: {
                        return new NumberQueryResult(Double.valueOf(trimmed));
                    }
                    case WHOLE_NUMBER: {
                        Long resultValue;
                        try {
                            resultValue = Long.valueOf(trimmed);
                        }
                        catch (NumberFormatException e) {
                            resultValue = Long.decode(trimmed);
                        }
                        return new NumberQueryResult(resultValue);
                    }
                }
                return new NumberQueryResult(null);
            }
            case DATE: {
                return new NumberQueryResult(((DateQueryResult)result).getValue().getTime());
            }
            case INSTANT: {
                return new NumberQueryResult(((InstantQueryResult)result).getValue().toEpochMilli());
            }
        }
        return new NumberQueryResult(null);
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.subjectEvaluator;
    }
}

