/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.service.extension;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import org.apache.nifi.extension.ExtensionFilterParams;
import org.apache.nifi.extension.ExtensionMetadata;
import org.apache.nifi.extension.TagCount;
import org.apache.nifi.extension.manifest.Extension;
import org.apache.nifi.extension.manifest.ProvidedServiceAPI;
import org.apache.nifi.registry.bucket.Bucket;
import org.apache.nifi.registry.extension.bundle.Bundle;
import org.apache.nifi.registry.extension.bundle.BundleFilterParams;
import org.apache.nifi.registry.extension.bundle.BundleType;
import org.apache.nifi.registry.extension.bundle.BundleVersion;
import org.apache.nifi.registry.extension.bundle.BundleVersionFilterParams;
import org.apache.nifi.registry.extension.bundle.BundleVersionMetadata;
import org.apache.nifi.registry.extension.repo.ExtensionRepoArtifact;
import org.apache.nifi.registry.extension.repo.ExtensionRepoBucket;
import org.apache.nifi.registry.extension.repo.ExtensionRepoGroup;
import org.apache.nifi.registry.extension.repo.ExtensionRepoVersionSummary;

public interface ExtensionService {
    public BundleVersion createBundleVersion(String var1, BundleType var2, InputStream var3, String var4) throws IOException;

    public List<Bundle> getBundles(Set<String> var1, BundleFilterParams var2);

    public List<Bundle> getBundlesByBucket(String var1);

    public Bundle getBundle(String var1);

    public Bundle deleteBundle(Bundle var1);

    public SortedSet<BundleVersionMetadata> getBundleVersions(Set<String> var1, BundleVersionFilterParams var2);

    public SortedSet<BundleVersionMetadata> getBundleVersions(String var1);

    public BundleVersion getBundleVersion(String var1, String var2, String var3);

    public BundleVersion getBundleVersion(String var1, String var2, String var3, String var4);

    public void writeBundleVersionContent(BundleVersion var1, OutputStream var2);

    public BundleVersion deleteBundleVersion(BundleVersion var1);

    public SortedSet<ExtensionMetadata> getExtensionMetadata(Set<String> var1, ExtensionFilterParams var2);

    public SortedSet<ExtensionMetadata> getExtensionMetadata(Set<String> var1, ProvidedServiceAPI var2);

    public SortedSet<ExtensionMetadata> getExtensionMetadata(BundleVersion var1);

    public Extension getExtension(BundleVersion var1, String var2);

    public void writeExtensionDocs(BundleVersion var1, String var2, OutputStream var3) throws IOException;

    public void writeAdditionalDetailsDocs(BundleVersion var1, String var2, OutputStream var3) throws IOException;

    public SortedSet<TagCount> getExtensionTags();

    public SortedSet<ExtensionRepoBucket> getExtensionRepoBuckets(Set<String> var1);

    public SortedSet<ExtensionRepoGroup> getExtensionRepoGroups(Bucket var1);

    public SortedSet<ExtensionRepoArtifact> getExtensionRepoArtifacts(Bucket var1, String var2);

    public SortedSet<ExtensionRepoVersionSummary> getExtensionRepoVersions(Bucket var1, String var2, String var3);
}

