/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.encrypt;

public enum PropertyEncryptionMethod {
    NIFI_ARGON2_AES_GCM_256(256),
    NIFI_PBKDF2_AES_GCM_256(256);

    private static final int BYTE_LENGTH_DIVISOR = 8;
    private final int keyLength;
    private final int derivedKeyLength;

    private PropertyEncryptionMethod(int keyLength) {
        this.keyLength = keyLength;
        this.derivedKeyLength = keyLength / 8;
    }

    public int getKeyLength() {
        return this.keyLength;
    }

    public int getDerivedKeyLength() {
        return this.derivedKeyLength;
    }
}

