/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.nar;

import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.nar.NarProperty;

public class NarProperties {
    private final String sourceType;
    private final String sourceId;
    private final String narGroup;
    private final String narId;
    private final String narVersion;
    private final String narDependencyGroup;
    private final String narDependencyId;
    private final String narDependencyVersion;
    private final Instant installed;

    private NarProperties(Builder builder) {
        this.sourceType = Objects.requireNonNull(builder.sourceType);
        this.sourceId = builder.sourceId;
        this.narGroup = Objects.requireNonNull(builder.narGroup);
        this.narId = Objects.requireNonNull(builder.narId);
        this.narVersion = Objects.requireNonNull(builder.narVersion);
        this.narDependencyGroup = builder.narDependencyGroup;
        this.narDependencyId = builder.narDependencyId;
        this.narDependencyVersion = builder.narDependencyVersion;
        if (!(this.narDependencyGroup == null && this.narDependencyId == null && this.narDependencyVersion == null || this.narDependencyGroup != null && this.narDependencyId != null && this.narDependencyVersion != null)) {
            throw new IllegalArgumentException("Must provided all NAR dependency values, or no dependency values");
        }
        this.installed = Objects.requireNonNull(builder.installed);
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public String getNarGroup() {
        return this.narGroup;
    }

    public String getNarId() {
        return this.narId;
    }

    public String getNarVersion() {
        return this.narVersion;
    }

    public String getNarDependencyGroup() {
        return this.narDependencyGroup;
    }

    public String getNarDependencyId() {
        return this.narDependencyId;
    }

    public String getNarDependencyVersion() {
        return this.narDependencyVersion;
    }

    public Instant getInstalled() {
        return this.installed;
    }

    public BundleCoordinate getCoordinate() {
        return new BundleCoordinate(this.narGroup, this.narId, this.narVersion);
    }

    public Optional<BundleCoordinate> getDependencyCoordinate() {
        if (this.narDependencyGroup == null) {
            return Optional.empty();
        }
        return Optional.of(new BundleCoordinate(this.narDependencyGroup, this.narDependencyId, this.narDependencyVersion));
    }

    public Properties toProperties() {
        Properties properties = new Properties();
        properties.put(NarProperty.SOURCE_TYPE.getKey(), this.sourceType);
        if (this.sourceId != null) {
            properties.put(NarProperty.SOURCE_ID.getKey(), this.sourceId);
        }
        properties.put(NarProperty.NAR_GROUP.getKey(), this.narGroup);
        properties.put(NarProperty.NAR_ID.getKey(), this.narId);
        properties.put(NarProperty.NAR_VERSION.getKey(), this.narVersion);
        if (this.narDependencyGroup != null) {
            properties.put(NarProperty.NAR_DEPENDENCY_GROUP.getKey(), this.narDependencyGroup);
            properties.put(NarProperty.NAR_DEPENDENCY_ID.getKey(), this.narDependencyId);
            properties.put(NarProperty.NAR_DEPENDENCY_VERSION.getKey(), this.narDependencyVersion);
        }
        properties.put(NarProperty.INSTALLED.getKey(), this.installed.toString());
        return properties;
    }

    public static NarProperties parse(InputStream inputStream) throws IOException {
        Properties properties = new Properties();
        properties.load(inputStream);
        String installedValue = properties.getProperty(NarProperty.INSTALLED.getKey());
        Instant installed = Instant.parse(installedValue);
        return NarProperties.builder().sourceType(properties.getProperty(NarProperty.SOURCE_TYPE.getKey())).sourceId(properties.getProperty(NarProperty.SOURCE_ID.getKey())).narGroup(properties.getProperty(NarProperty.NAR_GROUP.getKey())).narId(properties.getProperty(NarProperty.NAR_ID.getKey())).narVersion(properties.getProperty(NarProperty.NAR_VERSION.getKey())).narDependencyGroup(properties.getProperty(NarProperty.NAR_DEPENDENCY_GROUP.getKey())).narDependencyId(properties.getProperty(NarProperty.NAR_DEPENDENCY_ID.getKey())).narDependencyVersion(properties.getProperty(NarProperty.NAR_DEPENDENCY_VERSION.getKey())).installed(installed).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String sourceType;
        private String sourceId;
        private String narGroup;
        private String narId;
        private String narVersion;
        private String narDependencyGroup;
        private String narDependencyId;
        private String narDependencyVersion;
        private Instant installed;

        public Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public Builder sourceId(String sourceId) {
            this.sourceId = sourceId;
            return this;
        }

        public Builder narGroup(String narGroup) {
            this.narGroup = narGroup;
            return this;
        }

        public Builder narId(String narId) {
            this.narId = narId;
            return this;
        }

        public Builder narVersion(String narVersion) {
            this.narVersion = narVersion;
            return this;
        }

        public Builder narDependencyGroup(String narDependencyGroup) {
            this.narDependencyGroup = narDependencyGroup;
            return this;
        }

        public Builder narDependencyId(String narDependencyId) {
            this.narDependencyId = narDependencyId;
            return this;
        }

        public Builder narDependencyVersion(String narDependencyVersion) {
            this.narDependencyVersion = narDependencyVersion;
            return this;
        }

        public Builder installed(Instant installed) {
            this.installed = installed;
            return this;
        }

        public NarProperties build() {
            return new NarProperties(this);
        }
    }
}

