/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.HtmlSelectableTextInput;
import com.gargoylesoftware.htmlunit.html.LabelableElement;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class HtmlNumberInput
extends HtmlSelectableTextInput
implements LabelableElement {
    private static final char[] VALID_INT_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-'};

    HtmlNumberInput(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
        String value = this.getValueAttribute();
        if (!value.isEmpty() && !NumberUtils.isCreatable((String)value)) {
            this.setValueAttribute("");
        }
    }

    @Override
    protected void typeDone(String newValue, boolean notifyAttributeChangeListeners) {
        if (this.hasFeature(BrowserVersionFeatures.JS_INPUT_NUMBER_ACCEPT_ALL)) {
            this.setAttributeNS(null, "value", newValue, notifyAttributeChangeListeners, false);
            return;
        }
        if (StringUtils.isBlank((CharSequence)newValue)) {
            this.setAttributeNS(null, "value", "", notifyAttributeChangeListeners, false);
            return;
        }
        if ("-".equals(newValue) || "+".equals(newValue)) {
            this.setAttributeNS(null, "value", newValue, notifyAttributeChangeListeners, false);
            return;
        }
        String parseValue = newValue;
        int lastPos = parseValue.length() - 1;
        if (parseValue.charAt(lastPos) == '.') {
            parseValue = parseValue.substring(0, lastPos);
        }
        try {
            Double.parseDouble(parseValue);
            this.setAttributeNS(null, "value", newValue.trim(), notifyAttributeChangeListeners, false);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Override
    protected boolean isSubmittableByEnter() {
        return true;
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        boolean modifyValue = this.getValueAttribute().equals(this.getDefaultValue());
        this.setDefaultValue(defaultValue, modifyValue);
    }

    @Override
    public void setDefaultChecked(boolean defaultChecked) {
    }

    @Override
    public void setValueAttribute(String newValue) {
        try {
            if (!newValue.isEmpty()) {
                String lang = ((SgmlPage)this.getPage()).getWebClient().getBrowserVersion().getBrowserLanguage();
                NumberFormat format = NumberFormat.getInstance(Locale.forLanguageTag(lang));
                format.parse(newValue);
            }
            super.setValueAttribute(newValue);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    @Override
    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        String valueAttr = this.getValueAttribute();
        if (!valueAttr.isEmpty()) {
            BigDecimal value;
            block20: {
                if ("-".equals(valueAttr) || "+".equals(valueAttr)) {
                    return false;
                }
                if (this.getStep().isEmpty()) {
                    String val = valueAttr;
                    int lastPos = val.length() - 1;
                    if (lastPos >= 0 && val.charAt(lastPos) == '.') {
                        if (this.hasFeature(BrowserVersionFeatures.JS_INPUT_NUMBER_DOT_AT_END_IS_DOUBLE)) {
                            return false;
                        }
                        val = val.substring(0, lastPos);
                    }
                    if (!StringUtils.containsOnly((CharSequence)val, (char[])VALID_INT_CHARS)) {
                        return false;
                    }
                }
                try {
                    value = new BigDecimal(valueAttr);
                }
                catch (NumberFormatException e) {
                    return false;
                }
                if (!this.getMin().isEmpty()) {
                    try {
                        BigDecimal min = new BigDecimal(this.getMin());
                        if (value.compareTo(min) < 0) {
                            return false;
                        }
                        if (this.getStep().isEmpty()) break block20;
                        try {
                            BigDecimal step = new BigDecimal(this.getStep());
                            if (value.subtract(min).abs().remainder(step).doubleValue() > 0.0) {
                                return false;
                            }
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                    catch (NumberFormatException min) {
                        // empty catch block
                    }
                }
            }
            if (!this.getMax().isEmpty()) {
                try {
                    BigDecimal max = new BigDecimal(this.getMax());
                    if (value.compareTo(max) > 0) {
                        return false;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return true;
    }
}

