/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.instrumentation.transformer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.qpid.server.instrumentation.metadata.MethodDescription;
import org.apache.qpid.server.instrumentation.transformer.AbstractQpidTransformer;
import org.apache.qpid.server.instrumentation.transformer.QpidTransformer;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfiguredObjectMethodOperationTransformer<T extends MethodDescription>
extends AbstractQpidTransformer<T>
implements QpidTransformer<T> {
    private static final String CLASS_NAME = "org.apache.qpid.server.model.ConfiguredObjectMethodOperation";
    private static final String INTERNAL_CLASS_NAME = "org/apache/qpid/server/model/ConfiguredObjectMethodOperation";
    private static final String DESC_CONSTRUCTOR = String.format("(%s%s%s)V", ConfiguredObjectMethodOperationTransformer.referenceName(CLASS), ConfiguredObjectMethodOperationTransformer.referenceName(METHOD), ConfiguredObjectMethodOperationTransformer.referenceName("org/apache/qpid/server/model/ConfiguredObjectTypeRegistry"));
    private static final String PERFORM = "perform";
    private static final String DESC_PERFORM = String.format("(%s%s)%s", ConfiguredObjectMethodOperationTransformer.referenceName("org/apache/qpid/server/model/ConfiguredObject"), ConfiguredObjectMethodOperationTransformer.referenceName(MAP), ConfiguredObjectMethodOperationTransformer.referenceName(OBJECT));
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfiguredObjectMethodOperationTransformer.class);
    private final List<T> _methods;

    public ConfiguredObjectMethodOperationTransformer(List<T> methods) {
        this._methods = new ArrayList<T>(methods);
    }

    @Override
    public Logger getLogger() {
        return LOGGER;
    }

    @Override
    public List<T> getMemberDescriptions() {
        return new ArrayList<T>(this._methods);
    }

    @Override
    public ClassVisitor getTransformer(ClassVisitor cv) {
        return new Transformer(cv, this.getMemberDescriptions());
    }

    private class Transformer
    extends ClassVisitor {
        private final List<MethodDescription> _methods;

        private Transformer(ClassVisitor cv, List<T> methods) {
            super(589824, cv);
            this._methods = methods;
        }

        public void visitEnd() {
            ConfiguredObjectMethodOperationTransformer.this.visitMethodHandleFields(this._methods.size(), (ClassWriter)this.cv);
            int access = 20;
            this.visitField(20, "_signature", AbstractQpidTransformer.referenceName(AbstractQpidTransformer.STRING), null, null).visitEnd();
            this.visitField(20, "_hashcode", "I", null, null).visitEnd();
            ConfiguredObjectMethodOperationTransformer.this.visitStaticInitializer(this._methods, ConfiguredObjectMethodOperationTransformer.INTERNAL_CLASS_NAME, ConfiguredObjectMethodOperationTransformer.CLASS_NAME, (ClassWriter)this.cv);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
            if (name.equals("<init>") && desc.equals(DESC_CONSTRUCTOR)) {
                int methodIndex = 2;
                mv = new AbstractQpidTransformer.ConstructorTransformer(mv, ConfiguredObjectMethodOperationTransformer.INTERNAL_CLASS_NAME, 2);
            }
            if (name.equals(ConfiguredObjectMethodOperationTransformer.PERFORM) && desc.equals(DESC_PERFORM)) {
                mv = new PerformTransformer(mv, this._methods);
            }
            return mv;
        }
    }

    private class PerformTransformer
    extends MethodVisitor {
        private final List<MethodDescription> _methods;
        private boolean skipOperations;

        private PerformTransformer(MethodVisitor delegate, List<MethodDescription> methods) {
            super(589824, delegate);
            this.skipOperations = false;
            this._methods = methods;
        }

        public void visitVarInsn(int opcode, int index) {
            if (!this.skipOperations) {
                super.visitVarInsn(opcode, index);
            }
        }

        public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
            if (!this.skipOperations) {
                super.visitFieldInsn(opcode, owner, name, descriptor);
            }
        }

        public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
            if (opcode == 182 && owner.equals(ConfiguredObjectMethodOperationTransformer.INTERNAL_CLASS_NAME) && "getParameterValue".equals(name)) {
                super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
                this.skipOperations = true;
                return;
            }
            if (opcode == 182 && owner.equals(AbstractQpidTransformer.METHOD) && "invoke".equals(name)) {
                this.skipOperations = false;
                boolean configuredObjectIndex = true;
                int paramsIndex = 5;
                super.visitVarInsn(25, 0);
                super.visitFieldInsn(180, ConfiguredObjectMethodOperationTransformer.INTERNAL_CLASS_NAME, "_hashcode", "I");
                super.visitVarInsn(54, 7);
                int signatureIndex = 7;
                Map<String, AbstractQpidTransformer.AttributeStackAddress> stackMap = ConfiguredObjectMethodOperationTransformer.this.createAttributesStackMap(this._methods);
                int[] hashes = new int[stackMap.size()];
                Label[] switchJumpLabels = new Label[stackMap.size()];
                ConfiguredObjectMethodOperationTransformer.this.fillHashesAndLabels(stackMap, hashes, switchJumpLabels);
                Label label = new Label();
                super.visitVarInsn(21, 7);
                super.visitLookupSwitchInsn(label, hashes, switchJumpLabels);
                for (int i = 0; i < this._methods.size(); ++i) {
                    MethodDescription method = this._methods.get(i);
                    String returnType = method.getReturnType();
                    String signature = AbstractQpidTransformer.sig(method);
                    super.visitLabel(stackMap.get(method.getSignature()).getLabel());
                    super.visitFrame(3, 0, null, 0, null);
                    super.visitFieldInsn(178, ConfiguredObjectMethodOperationTransformer.INTERNAL_CLASS_NAME, "MH_" + i, AbstractQpidTransformer.referenceName(AbstractQpidTransformer.METHOD_HANDLE));
                    super.visitVarInsn(25, 1);
                    for (int j = 0; j < method.getParameterCount(); ++j) {
                        String type = ConfiguredObjectMethodOperationTransformer.this.autoboxType(method.getParameter(j));
                        if (type.charAt(0) == 'L' && type.endsWith(";")) {
                            type = type.substring(1, type.length() - 1);
                        }
                        super.visitVarInsn(25, 5);
                        super.visitIntInsn(16, j);
                        super.visitInsn(50);
                        super.visitTypeInsn(192, type);
                        ConfiguredObjectMethodOperationTransformer.this.autoboxIfNeeded(ConfiguredObjectMethodOperationTransformer.this.autoboxType(method.getParameter(j)), method.getParameter(j), this.mv);
                    }
                    super.visitMethodInsn(182, AbstractQpidTransformer.METHOD_HANDLE, "invokeExact", signature, AbstractQpidTransformer.FALSE.booleanValue());
                    if (method.returnsPrimitive() && !method.returnsVoid()) {
                        ConfiguredObjectMethodOperationTransformer.this.autoboxIfNeeded(returnType, ConfiguredObjectMethodOperationTransformer.this.autoboxType(returnType), this.mv);
                    }
                    if (method.returnsVoid()) {
                        super.visitInsn(1);
                    }
                    super.visitInsn(176);
                }
                super.visitLabel(label);
                super.visitFrame(3, 0, null, 0, null);
                super.visitVarInsn(25, 0);
                super.visitFieldInsn(180, ConfiguredObjectMethodOperationTransformer.INTERNAL_CLASS_NAME, "_signature", AbstractQpidTransformer.referenceName(AbstractQpidTransformer.STRING));
                super.visitVarInsn(58, 8);
                super.visitTypeInsn(187, "org/apache/qpid/server/util/ServerScopedRuntimeException");
                super.visitInsn(89);
                super.visitLdcInsn((Object)"Failed to call operation %s on object %s");
                super.visitInsn(5);
                super.visitTypeInsn(189, AbstractQpidTransformer.OBJECT);
                super.visitInsn(89);
                super.visitInsn(3);
                super.visitVarInsn(25, 8);
                super.visitInsn(83);
                super.visitInsn(89);
                super.visitInsn(4);
                super.visitVarInsn(25, 1);
                super.visitInsn(83);
                super.visitMethodInsn(184, AbstractQpidTransformer.STRING, "format", AbstractQpidTransformer.DESC_FORMAT, AbstractQpidTransformer.FALSE.booleanValue());
                super.visitMethodInsn(183, "org/apache/qpid/server/util/ServerScopedRuntimeException", "<init>", AbstractQpidTransformer.DESC_EXCEPTION1, AbstractQpidTransformer.FALSE.booleanValue());
                super.visitInsn(191);
            } else {
                super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
            }
        }
    }
}

