/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.util;

import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Environment;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.utilint.LogVerifier;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public class LogVerificationReadableByteChannel
implements ReadableByteChannel {
    private static final int TEMP_SIZE = 8192;
    private final ReadableByteChannel channel;
    private final LogVerifier verifier;
    private byte[] tempArray;

    public LogVerificationReadableByteChannel(Environment env, ReadableByteChannel channel, String fileName) {
        this(DbInternal.getNonNullEnvImpl(env), channel, fileName);
    }

    public LogVerificationReadableByteChannel(EnvironmentImpl envImpl, ReadableByteChannel channel, String fileName) {
        this.channel = channel;
        this.verifier = new LogVerifier(envImpl, fileName);
    }

    @Override
    public synchronized int read(ByteBuffer buffer) throws IOException {
        int start = buffer.position();
        int count = this.channel.read(buffer);
        if (count < 0) {
            this.verifier.verifyAtEof();
        } else if (buffer.hasArray()) {
            this.verifier.verify(buffer.array(), buffer.arrayOffset() + start, count);
        } else {
            int chunk;
            if (this.tempArray == null) {
                this.tempArray = new byte[8192];
            }
            buffer.position(start);
            for (int len = count; len > 0; len -= chunk) {
                chunk = Math.min(len, 8192);
                buffer.get(this.tempArray, 0, chunk);
                this.verifier.verify(this.tempArray, 0, chunk);
            }
        }
        return count;
    }

    @Override
    public synchronized void close() throws IOException {
        this.channel.close();
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }
}

