/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.longpolling;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.longpolling.PollingHeader;
import org.apache.rocketmq.broker.longpolling.PollingResult;
import org.apache.rocketmq.broker.longpolling.PopRequest;
import org.apache.rocketmq.common.KeyBuilder;
import org.apache.rocketmq.common.ServiceThread;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.netty.NettyRemotingAbstract;
import org.apache.rocketmq.remoting.netty.NettyRequestProcessor;
import org.apache.rocketmq.remoting.netty.RequestTask;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;

public class PopLongPollingService
extends ServiceThread {
    private static final Logger POP_LOGGER = LoggerFactory.getLogger((String)"RocketmqPop");
    private final BrokerController brokerController;
    private final NettyRequestProcessor processor;
    private final ConcurrentHashMap<String, ConcurrentHashMap<String, Byte>> topicCidMap;
    private final ConcurrentLinkedHashMap<String, ConcurrentSkipListSet<PopRequest>> pollingMap;
    private long lastCleanTime = 0L;
    private final AtomicLong totalPollingNum = new AtomicLong(0L);

    public PopLongPollingService(BrokerController brokerController, NettyRequestProcessor processor) {
        this.brokerController = brokerController;
        this.processor = processor;
        this.topicCidMap = new ConcurrentHashMap(brokerController.getBrokerConfig().getPopPollingMapSize());
        this.pollingMap = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity((long)this.brokerController.getBrokerConfig().getPopPollingMapSize()).build();
    }

    public String getServiceName() {
        if (this.brokerController.getBrokerConfig().isInBrokerContainer()) {
            return this.brokerController.getBrokerIdentity().getIdentifier() + PopLongPollingService.class.getSimpleName();
        }
        return PopLongPollingService.class.getSimpleName();
    }

    public void run() {
        int i = 0;
        while (!this.stopped) {
            try {
                this.waitForRunning(20L);
                ++i;
                if (this.pollingMap.isEmpty()) continue;
                long tmpTotalPollingNum = 0L;
                for (Map.Entry entry : this.pollingMap.entrySet()) {
                    PopRequest first;
                    String key = (String)entry.getKey();
                    ConcurrentSkipListSet popQ = (ConcurrentSkipListSet)entry.getValue();
                    if (popQ == null) continue;
                    while ((first = (PopRequest)popQ.pollFirst()) != null) {
                        if (!first.isTimeout()) {
                            if (popQ.add(first)) break;
                            POP_LOGGER.info("polling, add fail again: {}", (Object)first);
                        }
                        if (this.brokerController.getBrokerConfig().isEnablePopLog()) {
                            POP_LOGGER.info("timeout , wakeUp polling : {}", (Object)first);
                        }
                        this.totalPollingNum.decrementAndGet();
                        this.wakeUp(first);
                    }
                    if (i < 100) continue;
                    long tmpPollingNum = popQ.size();
                    tmpTotalPollingNum += tmpPollingNum;
                    if (tmpPollingNum <= 100L) continue;
                    POP_LOGGER.info("polling queue {} , size={} ", (Object)key, (Object)tmpPollingNum);
                }
                if (i >= 100) {
                    POP_LOGGER.info("pollingMapSize={},tmpTotalSize={},atomicTotalSize={},diffSize={}", new Object[]{this.pollingMap.size(), tmpTotalPollingNum, this.totalPollingNum.get(), Math.abs(this.totalPollingNum.get() - tmpTotalPollingNum)});
                    this.totalPollingNum.set(tmpTotalPollingNum);
                    i = 0;
                }
                if (this.lastCleanTime != 0L && System.currentTimeMillis() - this.lastCleanTime <= 300000L) continue;
                this.cleanUnusedResource();
            }
            catch (Throwable e) {
                POP_LOGGER.error("checkPolling error", e);
            }
        }
        try {
            for (Map.Entry entry : this.pollingMap.entrySet()) {
                PopRequest first;
                ConcurrentSkipListSet popQ = (ConcurrentSkipListSet)entry.getValue();
                while ((first = (PopRequest)popQ.pollFirst()) != null) {
                    this.wakeUp(first);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void notifyMessageArriving(String topic, int queueId) {
        ConcurrentHashMap<String, Byte> cids = this.topicCidMap.get(topic);
        if (cids == null) {
            return;
        }
        for (Map.Entry<String, Byte> cid : cids.entrySet()) {
            if (queueId >= 0) {
                this.notifyMessageArriving(topic, cid.getKey(), -1);
            }
            this.notifyMessageArriving(topic, cid.getKey(), queueId);
        }
    }

    public boolean notifyMessageArriving(String topic, String cid, int queueId) {
        ConcurrentSkipListSet remotingCommands = (ConcurrentSkipListSet)this.pollingMap.get((Object)KeyBuilder.buildPollingKey((String)topic, (String)cid, (int)queueId));
        if (remotingCommands == null || remotingCommands.isEmpty()) {
            return false;
        }
        PopRequest popRequest = (PopRequest)remotingCommands.pollFirst();
        while (popRequest != null && !popRequest.getChannel().isActive()) {
            this.totalPollingNum.decrementAndGet();
            popRequest = (PopRequest)remotingCommands.pollFirst();
        }
        if (popRequest == null) {
            return false;
        }
        this.totalPollingNum.decrementAndGet();
        if (this.brokerController.getBrokerConfig().isEnablePopLog()) {
            POP_LOGGER.info("lock release , new msg arrive , wakeUp : {}", (Object)popRequest);
        }
        return this.wakeUp(popRequest);
    }

    public boolean wakeUp(PopRequest request) {
        if (request == null || !request.complete()) {
            return false;
        }
        if (!request.getCtx().channel().isActive()) {
            return false;
        }
        Runnable run = () -> {
            try {
                RemotingCommand response = this.processor.processRequest(request.getCtx(), request.getRemotingCommand());
                if (response != null) {
                    response.setOpaque(request.getRemotingCommand().getOpaque());
                    response.markResponseType();
                    NettyRemotingAbstract.writeResponse((Channel)request.getChannel(), (RemotingCommand)request.getRemotingCommand(), (RemotingCommand)response, future -> {
                        if (!future.isSuccess()) {
                            POP_LOGGER.error("ProcessRequestWrapper response to {} failed", (Object)request.getChannel().remoteAddress(), (Object)future.cause());
                            POP_LOGGER.error(request.toString());
                            POP_LOGGER.error(response.toString());
                        }
                    });
                }
            }
            catch (Exception e1) {
                POP_LOGGER.error("ExecuteRequestWhenWakeup run", (Throwable)e1);
            }
        };
        this.brokerController.getPullMessageExecutor().submit((Runnable)new RequestTask(run, request.getChannel(), request.getRemotingCommand()));
        return true;
    }

    public PollingResult polling(ChannelHandlerContext ctx, RemotingCommand remotingCommand, PollingHeader requestHeader) {
        boolean isFull;
        if (requestHeader.getPollTime() <= 0L || this.isStopped()) {
            return PollingResult.NOT_POLLING;
        }
        ConcurrentHashMap<String, Byte> cids = this.topicCidMap.get(requestHeader.getTopic());
        if (cids == null) {
            cids = new ConcurrentHashMap();
            ConcurrentHashMap<String, Byte> old = this.topicCidMap.putIfAbsent(requestHeader.getTopic(), cids);
            if (old != null) {
                cids = old;
            }
        }
        cids.putIfAbsent(requestHeader.getConsumerGroup(), (byte)-128);
        long expired = requestHeader.getBornTime() + requestHeader.getPollTime();
        PopRequest request = new PopRequest(remotingCommand, ctx, expired);
        boolean bl = isFull = this.totalPollingNum.get() >= this.brokerController.getBrokerConfig().getMaxPopPollingSize();
        if (isFull) {
            POP_LOGGER.info("polling {}, result POLLING_FULL, total:{}", (Object)remotingCommand, (Object)this.totalPollingNum.get());
            return PollingResult.POLLING_FULL;
        }
        boolean isTimeout = request.isTimeout();
        if (isTimeout) {
            if (this.brokerController.getBrokerConfig().isEnablePopLog()) {
                POP_LOGGER.info("polling {}, result POLLING_TIMEOUT", (Object)remotingCommand);
            }
            return PollingResult.POLLING_TIMEOUT;
        }
        String key = KeyBuilder.buildPollingKey((String)requestHeader.getTopic(), (String)requestHeader.getConsumerGroup(), (int)requestHeader.getQueueId());
        ConcurrentSkipListSet queue = (ConcurrentSkipListSet)this.pollingMap.get((Object)key);
        if (queue == null) {
            queue = new ConcurrentSkipListSet(PopRequest.COMPARATOR);
            ConcurrentSkipListSet old = (ConcurrentSkipListSet)this.pollingMap.putIfAbsent((Object)key, queue);
            if (old != null) {
                queue = old;
            }
        } else {
            int size = queue.size();
            if (size > this.brokerController.getBrokerConfig().getPopPollingSize()) {
                POP_LOGGER.info("polling {}, result POLLING_FULL, singleSize:{}", (Object)remotingCommand, (Object)size);
                return PollingResult.POLLING_FULL;
            }
        }
        if (queue.add((PopRequest)request)) {
            remotingCommand.setSuspended(true);
            this.totalPollingNum.incrementAndGet();
            if (this.brokerController.getBrokerConfig().isEnablePopLog()) {
                POP_LOGGER.info("polling {}, result POLLING_SUC", (Object)remotingCommand);
            }
            return PollingResult.POLLING_SUC;
        }
        POP_LOGGER.info("polling {}, result POLLING_FULL, add fail, {}", (Object)request, (Object)queue);
        return PollingResult.POLLING_FULL;
    }

    public ConcurrentLinkedHashMap<String, ConcurrentSkipListSet<PopRequest>> getPollingMap() {
        return this.pollingMap;
    }

    private void cleanUnusedResource() {
        try {
            Map.Entry entry;
            Iterator<Map.Entry<String, ConcurrentHashMap<String, Byte>>> topicCidMapIter = this.topicCidMap.entrySet().iterator();
            while (topicCidMapIter.hasNext()) {
                entry = topicCidMapIter.next();
                String topic = entry.getKey();
                if (this.brokerController.getTopicConfigManager().selectTopicConfig(topic) == null) {
                    POP_LOGGER.info("remove not exit topic {} in topicCidMap!", (Object)topic);
                    topicCidMapIter.remove();
                    continue;
                }
                Iterator cidMapIter = ((ConcurrentHashMap)entry.getValue()).entrySet().iterator();
                while (cidMapIter.hasNext()) {
                    Map.Entry cidEntry = cidMapIter.next();
                    String cid = (String)cidEntry.getKey();
                    if (this.brokerController.getSubscriptionGroupManager().getSubscriptionGroupTable().containsKey(cid)) continue;
                    POP_LOGGER.info("remove not exit sub {} of topic {} in topicCidMap!", (Object)cid, (Object)topic);
                    cidMapIter.remove();
                }
            }
            Iterator pollingMapIter = this.pollingMap.entrySet().iterator();
            while (pollingMapIter.hasNext()) {
                String[] keyArray;
                entry = (Map.Entry)pollingMapIter.next();
                if (entry.getKey() == null || (keyArray = ((String)entry.getKey()).split("@")).length != 3) continue;
                String topic = keyArray[0];
                String cid = keyArray[1];
                if (this.brokerController.getTopicConfigManager().selectTopicConfig(topic) == null) {
                    POP_LOGGER.info("remove not exit topic {} in pollingMap!", (Object)topic);
                    pollingMapIter.remove();
                    continue;
                }
                if (this.brokerController.getSubscriptionGroupManager().getSubscriptionGroupTable().containsKey(cid)) continue;
                POP_LOGGER.info("remove not exit sub {} of topic {} in pollingMap!", (Object)cid, (Object)topic);
                pollingMapIter.remove();
            }
        }
        catch (Throwable e) {
            POP_LOGGER.error("cleanUnusedResource", e);
        }
        this.lastCleanTime = System.currentTimeMillis();
    }
}

