/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tieredstore.file;

import com.google.common.annotations.VisibleForTesting;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.tieredstore.common.AppendResult;
import org.apache.rocketmq.tieredstore.common.TieredMessageStoreConfig;
import org.apache.rocketmq.tieredstore.file.TieredFileAllocator;
import org.apache.rocketmq.tieredstore.file.TieredFlatFile;
import org.apache.rocketmq.tieredstore.provider.TieredFileSegment;
import org.apache.rocketmq.tieredstore.util.MessageBufferUtil;

public class TieredCommitLog {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqTieredStore");
    private static final Long NOT_EXIST_MIN_OFFSET = -1L;
    public static final int CODA_SIZE = 16;
    public static final int BLANK_MAGIC_CODE = -875286124;
    private final TieredMessageStoreConfig storeConfig;
    private final TieredFlatFile flatFile;
    private final AtomicLong minConsumeQueueOffset;

    public TieredCommitLog(TieredFileAllocator fileQueueFactory, String filePath) {
        this.storeConfig = fileQueueFactory.getStoreConfig();
        this.flatFile = fileQueueFactory.createFlatFileForCommitLog(filePath);
        this.minConsumeQueueOffset = new AtomicLong(NOT_EXIST_MIN_OFFSET);
        this.correctMinOffsetAsync();
    }

    @VisibleForTesting
    public TieredFlatFile getFlatFile() {
        return this.flatFile;
    }

    public long getMinOffset() {
        return this.flatFile.getMinOffset();
    }

    public long getCommitOffset() {
        return this.flatFile.getCommitOffset();
    }

    public long getMinConsumeQueueOffset() {
        return this.minConsumeQueueOffset.get() != NOT_EXIST_MIN_OFFSET.longValue() ? this.minConsumeQueueOffset.get() : this.correctMinOffset();
    }

    public long getDispatchCommitOffset() {
        return this.flatFile.getDispatchCommitOffset();
    }

    public long getMaxOffset() {
        return this.flatFile.getMaxOffset();
    }

    public long getBeginTimestamp() {
        TieredFileSegment firstIndexFile = this.flatFile.getFileByIndex(0);
        if (firstIndexFile == null) {
            return -1L;
        }
        long beginTimestamp = firstIndexFile.getMinTimestamp();
        return beginTimestamp != Long.MAX_VALUE ? beginTimestamp : -1L;
    }

    public long getEndTimestamp() {
        return this.flatFile.getFileToWrite().getMaxTimestamp();
    }

    public long correctMinOffset() {
        try {
            return this.correctMinOffsetAsync().get();
        }
        catch (Exception e) {
            log.error("Correct min offset failed in clean expired file", (Throwable)e);
            return NOT_EXIST_MIN_OFFSET;
        }
    }

    public synchronized CompletableFuture<Long> correctMinOffsetAsync() {
        if (this.flatFile.getFileSegmentCount() == 0) {
            this.minConsumeQueueOffset.set(NOT_EXIST_MIN_OFFSET);
            return CompletableFuture.completedFuture(NOT_EXIST_MIN_OFFSET);
        }
        int length = 28;
        if (this.flatFile.getCommitOffset() - this.flatFile.getMinOffset() < (long)length) {
            this.minConsumeQueueOffset.set(NOT_EXIST_MIN_OFFSET);
            return CompletableFuture.completedFuture(NOT_EXIST_MIN_OFFSET);
        }
        try {
            return ((CompletableFuture)this.flatFile.readAsync(this.flatFile.getMinOffset(), length).thenApply(buffer -> {
                long offset = MessageBufferUtil.getQueueOffset(buffer);
                this.minConsumeQueueOffset.set(offset);
                log.debug("Correct commitlog min cq offset success, filePath={}, min cq offset={}, commitlog range={}-{}", new Object[]{this.flatFile.getFilePath(), offset, this.flatFile.getMinOffset(), this.flatFile.getCommitOffset()});
                return offset;
            })).exceptionally(throwable -> {
                log.warn("Correct commitlog min cq offset error, filePath={}, range={}-{}", new Object[]{this.flatFile.getFilePath(), this.flatFile.getMinOffset(), this.flatFile.getCommitOffset(), throwable});
                return this.minConsumeQueueOffset.get();
            });
        }
        catch (Exception e) {
            log.error("Correct commitlog min cq offset error, filePath={}", (Object)this.flatFile.getFilePath(), (Object)e);
            return CompletableFuture.completedFuture(this.minConsumeQueueOffset.get());
        }
    }

    public AppendResult append(ByteBuffer byteBuf) {
        return this.flatFile.append(byteBuf, MessageBufferUtil.getStoreTimeStamp(byteBuf));
    }

    public AppendResult append(ByteBuffer byteBuf, boolean commit) {
        return this.flatFile.append(byteBuf, MessageBufferUtil.getStoreTimeStamp(byteBuf), commit);
    }

    public CompletableFuture<ByteBuffer> readAsync(long offset, int length) {
        return this.flatFile.readAsync(offset, length);
    }

    public void commit(boolean sync) {
        this.flatFile.commit(sync);
    }

    public void cleanExpiredFile(long expireTimestamp) {
        if (this.flatFile.cleanExpiredFile(expireTimestamp) > 0) {
            this.correctMinOffset();
        }
    }

    public void destroyExpiredFile() {
        this.flatFile.destroyExpiredFile();
        if (this.flatFile.getFileSegmentCount() == 0) {
            return;
        }
        TieredFileSegment fileSegment = this.flatFile.getFileToWrite();
        try {
            if (System.currentTimeMillis() - fileSegment.getMaxTimestamp() > TimeUnit.HOURS.toMillis(this.storeConfig.getCommitLogRollingInterval()) && fileSegment.getAppendPosition() > (long)this.storeConfig.getCommitLogRollingMinimumSize()) {
                this.flatFile.rollingNewFile();
            }
        }
        catch (Exception e) {
            log.error("Rolling to next file failed", (Throwable)e);
        }
    }

    public void destroy() {
        this.flatFile.destroy();
    }
}

