/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.queue;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.rocketmq.common.Pair;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.common.topic.TopicValidator;
import org.apache.rocketmq.common.utils.DataConverter;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.store.DefaultMessageStore;
import org.apache.rocketmq.store.DispatchRequest;
import org.apache.rocketmq.store.queue.RocksDBConsumeQueueTable;
import org.apache.rocketmq.store.rocksdb.ConsumeQueueRocksDBStorage;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.WriteBatch;

public class RocksDBConsumeQueueOffsetTable {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqStore");
    private static final Logger ERROR_LOG = LoggerFactory.getLogger((String)"RocketmqStoreError");
    private static final Logger ROCKSDB_LOG = LoggerFactory.getLogger((String)"RocketmqRocksDB");
    private static final byte[] MAX_BYTES = "max".getBytes(DataConverter.CHARSET_UTF8);
    private static final byte[] MIN_BYTES = "min".getBytes(DataConverter.CHARSET_UTF8);
    private static final int OFFSET_PHY_OFFSET = 0;
    private static final int OFFSET_CQ_OFFSET = 8;
    private static final int OFFSET_KEY_LENGTH_WITHOUT_TOPIC_BYTES = 14;
    private static final int OFFSET_VALUE_LENGTH = 16;
    private static final String MAX_PHYSICAL_OFFSET_CHECKPOINT = "CHECKPOINT_TOPIC";
    private static final byte[] MAX_PHYSICAL_OFFSET_CHECKPOINT_BYTES = "CHECKPOINT_TOPIC".getBytes(DataConverter.CHARSET_UTF8);
    private static final int INNER_CHECKPOINT_TOPIC_LEN = 14 + MAX_PHYSICAL_OFFSET_CHECKPOINT_BYTES.length;
    private static final ByteBuffer INNER_CHECKPOINT_TOPIC = ByteBuffer.allocateDirect(INNER_CHECKPOINT_TOPIC_LEN);
    private static final byte[] MAX_PHYSICAL_OFFSET_CHECKPOINT_KEY = new byte[INNER_CHECKPOINT_TOPIC_LEN];
    private final ByteBuffer maxPhyOffsetBB;
    private final RocksDBConsumeQueueTable rocksDBConsumeQueueTable;
    private final ConsumeQueueRocksDBStorage rocksDBStorage;
    private final DefaultMessageStore messageStore;
    private ColumnFamilyHandle offsetCFH;
    private final Map<String, PhyAndCQOffset> topicQueueMinOffset;
    private final Map<String, Long> topicQueueMaxCqOffset;

    public RocksDBConsumeQueueOffsetTable(RocksDBConsumeQueueTable rocksDBConsumeQueueTable, ConsumeQueueRocksDBStorage rocksDBStorage, DefaultMessageStore messageStore) {
        this.rocksDBConsumeQueueTable = rocksDBConsumeQueueTable;
        this.rocksDBStorage = rocksDBStorage;
        this.messageStore = messageStore;
        this.topicQueueMinOffset = new ConcurrentHashMap<String, PhyAndCQOffset>(1024);
        this.topicQueueMaxCqOffset = new ConcurrentHashMap<String, Long>(1024);
        this.maxPhyOffsetBB = ByteBuffer.allocateDirect(8);
    }

    public void load() {
        this.offsetCFH = this.rocksDBStorage.getOffsetCFHandle();
    }

    public void updateTempTopicQueueMaxOffset(Pair<ByteBuffer, ByteBuffer> offsetBBPair, byte[] topicBytes, DispatchRequest request, Map<ByteBuffer, Pair<ByteBuffer, DispatchRequest>> tempTopicQueueMaxOffsetMap) {
        this.buildOffsetKeyAndValueByteBuffer(offsetBBPair, topicBytes, request);
        ByteBuffer topicQueueId = (ByteBuffer)offsetBBPair.getObject1();
        ByteBuffer maxOffsetBB = (ByteBuffer)offsetBBPair.getObject2();
        Pair<ByteBuffer, DispatchRequest> old = tempTopicQueueMaxOffsetMap.get(topicQueueId);
        if (old == null) {
            tempTopicQueueMaxOffsetMap.put(topicQueueId, (Pair<ByteBuffer, DispatchRequest>)new Pair((Object)maxOffsetBB, (Object)request));
        } else {
            long oldMaxOffset = ((ByteBuffer)old.getObject1()).getLong(8);
            long maxOffset = maxOffsetBB.getLong(8);
            if (maxOffset >= oldMaxOffset) {
                ERROR_LOG.error("cqOffset invalid1. old: {}, now: {}", (Object)oldMaxOffset, (Object)maxOffset);
            }
        }
    }

    public void putMaxPhyAndCqOffset(Map<ByteBuffer, Pair<ByteBuffer, DispatchRequest>> tempTopicQueueMaxOffsetMap, WriteBatch writeBatch, long maxPhyOffset) throws RocksDBException {
        for (Map.Entry<ByteBuffer, Pair<ByteBuffer, DispatchRequest>> entry : tempTopicQueueMaxOffsetMap.entrySet()) {
            writeBatch.put(this.offsetCFH, entry.getKey(), (ByteBuffer)entry.getValue().getObject1());
        }
        this.appendMaxPhyOffset(writeBatch, maxPhyOffset);
    }

    public void putHeapMaxCqOffset(Map<ByteBuffer, Pair<ByteBuffer, DispatchRequest>> tempTopicQueueMaxOffsetMap) {
        for (Map.Entry<ByteBuffer, Pair<ByteBuffer, DispatchRequest>> entry : tempTopicQueueMaxOffsetMap.entrySet()) {
            DispatchRequest request = (DispatchRequest)entry.getValue().getObject2();
            this.putHeapMaxCqOffset(request.getTopic(), request.getQueueId(), request.getConsumeQueueOffset());
        }
    }

    public void destroyOffset(String topic, int queueId, WriteBatch writeBatch) throws RocksDBException {
        byte[] topicBytes = topic.getBytes(DataConverter.CHARSET_UTF8);
        ByteBuffer minOffsetKey = this.buildOffsetKeyByteBuffer(topicBytes, queueId, false);
        byte[] minOffsetBytes = this.rocksDBStorage.getOffset(minOffsetKey.array());
        Long startCQOffset = minOffsetBytes != null ? Long.valueOf(ByteBuffer.wrap(minOffsetBytes).getLong(8)) : null;
        ByteBuffer maxOffsetKey = this.buildOffsetKeyByteBuffer(topicBytes, queueId, true);
        byte[] maxOffsetBytes = this.rocksDBStorage.getOffset(maxOffsetKey.array());
        Long endCQOffset = maxOffsetBytes != null ? Long.valueOf(ByteBuffer.wrap(maxOffsetBytes).getLong(8)) : null;
        writeBatch.delete(this.offsetCFH, minOffsetKey.array());
        writeBatch.delete(this.offsetCFH, maxOffsetKey.array());
        String topicQueueId = this.buildTopicQueueId(topic, queueId);
        this.removeHeapMinCqOffset(topicQueueId);
        this.removeHeapMaxCqOffset(topicQueueId);
        log.info("RocksDB offset table delete topic: {}, queueId: {}, minOffset: {}, maxOffset: {}", new Object[]{topic, queueId, startCQOffset, endCQOffset});
    }

    private void appendMaxPhyOffset(WriteBatch writeBatch, long maxPhyOffset) throws RocksDBException {
        ByteBuffer maxPhyOffsetBB = this.maxPhyOffsetBB;
        maxPhyOffsetBB.position(0).limit(8);
        maxPhyOffsetBB.putLong(maxPhyOffset);
        maxPhyOffsetBB.flip();
        INNER_CHECKPOINT_TOPIC.position(0).limit(INNER_CHECKPOINT_TOPIC_LEN);
        writeBatch.put(this.offsetCFH, INNER_CHECKPOINT_TOPIC, maxPhyOffsetBB);
    }

    public long getMaxPhyOffset() throws RocksDBException {
        byte[] valueBytes = this.rocksDBStorage.getOffset(MAX_PHYSICAL_OFFSET_CHECKPOINT_KEY);
        if (valueBytes == null) {
            return 0L;
        }
        ByteBuffer valueBB = ByteBuffer.wrap(valueBytes);
        return valueBB.getLong(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Set<Integer>> iterateOffsetTable2FindDirty(Set<String> existTopicSet) {
        HashMap<String, Set<Integer>> topicQueueIdToBeDeletedMap = new HashMap<String, Set<Integer>>();
        try (RocksIterator iterator = null;){
            iterator = this.rocksDBStorage.seekOffsetCF();
            if (iterator == null) {
                HashMap<String, Set<Integer>> hashMap = topicQueueIdToBeDeletedMap;
                return hashMap;
            }
            iterator.seekToFirst();
            while (iterator.isValid()) {
                byte[] key = iterator.key();
                byte[] value = iterator.value();
                if (key != null && key.length > 14 && value != null && value.length == 16) {
                    ByteBuffer keyBB = ByteBuffer.wrap(key);
                    int topicLen = keyBB.getInt(0);
                    byte[] topicBytes = new byte[topicLen];
                    keyBB.position(5);
                    keyBB.get(topicBytes);
                    String topic = new String(topicBytes, DataConverter.CHARSET_UTF8);
                    if (!TopicValidator.isSystemTopic((String)topic)) {
                        int queueId = keyBB.getInt(5 + topicLen + 1 + 3 + 1);
                        if (!existTopicSet.contains(topic)) {
                            ByteBuffer valueBB = ByteBuffer.wrap(value);
                            long cqOffset = valueBB.getLong(8);
                            Set topicQueueIdSet = (Set)topicQueueIdToBeDeletedMap.get(topic);
                            if (topicQueueIdSet == null) {
                                HashSet<Integer> newSet = new HashSet<Integer>();
                                newSet.add(queueId);
                                topicQueueIdToBeDeletedMap.put(topic, newSet);
                            } else {
                                topicQueueIdSet.add(queueId);
                            }
                            ERROR_LOG.info("RocksDBConsumeQueueOffsetTable has dirty cqOffset. topic: {}, queueId: {}, cqOffset: {}", new Object[]{topic, queueId, cqOffset});
                        }
                    }
                }
                iterator.next();
            }
        }
        return topicQueueIdToBeDeletedMap;
    }

    public Long getMaxCqOffset(String topic, int queueId) throws RocksDBException {
        Long maxCqOffset = this.getHeapMaxCqOffset(topic, queueId);
        if (maxCqOffset == null) {
            ByteBuffer byteBuffer = this.getMaxPhyAndCqOffsetInKV(topic, queueId);
            maxCqOffset = byteBuffer != null ? Long.valueOf(byteBuffer.getLong(8)) : null;
            String topicQueueId = this.buildTopicQueueId(topic, queueId);
            this.topicQueueMaxCqOffset.putIfAbsent(topicQueueId, maxCqOffset != null ? maxCqOffset : -1L);
            if (this.messageStore.getMessageStoreConfig().isEnableRocksDBLog()) {
                ROCKSDB_LOG.warn("updateMaxOffsetInQueue. {}, {}", (Object)topicQueueId, (Object)maxCqOffset);
            }
        }
        return maxCqOffset;
    }

    public void truncateDirty(long offsetToTruncate) throws RocksDBException {
        this.correctMaxPyhOffset(offsetToTruncate);
        ConcurrentMap<String, TopicConfig> allTopicConfigMap = this.messageStore.getTopicConfigs();
        if (allTopicConfigMap == null) {
            return;
        }
        for (TopicConfig topicConfig : allTopicConfigMap.values()) {
            for (int i = 0; i < topicConfig.getWriteQueueNums(); ++i) {
                this.truncateDirtyOffset(topicConfig.getTopicName(), i);
            }
        }
    }

    private Pair<Boolean, Long> isMinOffsetOk(String topic, int queueId, long minPhyOffset) throws RocksDBException {
        PhyAndCQOffset phyAndCQOffset = this.getHeapMinOffset(topic, queueId);
        if (phyAndCQOffset != null) {
            long phyOffset = phyAndCQOffset.getPhyOffset();
            long cqOffset = phyAndCQOffset.getCqOffset();
            return phyOffset >= minPhyOffset ? new Pair((Object)true, (Object)cqOffset) : new Pair((Object)false, (Object)cqOffset);
        }
        ByteBuffer byteBuffer = this.getMinPhyAndCqOffsetInKV(topic, queueId);
        if (byteBuffer == null) {
            return new Pair((Object)false, (Object)0L);
        }
        long phyOffset = byteBuffer.getLong(0);
        long cqOffset = byteBuffer.getLong(8);
        if (phyOffset >= minPhyOffset) {
            String topicQueueId = this.buildTopicQueueId(topic, queueId);
            PhyAndCQOffset newPhyAndCQOffset = new PhyAndCQOffset(phyOffset, cqOffset);
            this.topicQueueMinOffset.putIfAbsent(topicQueueId, newPhyAndCQOffset);
            if (this.messageStore.getMessageStoreConfig().isEnableRocksDBLog()) {
                ROCKSDB_LOG.warn("updateMinOffsetInQueue. {}, {}", (Object)topicQueueId, (Object)newPhyAndCQOffset);
            }
            return new Pair((Object)true, (Object)cqOffset);
        }
        return new Pair((Object)false, (Object)cqOffset);
    }

    private void truncateDirtyOffset(String topic, int queueId) throws RocksDBException {
        ByteBuffer byteBuffer = this.getMaxPhyAndCqOffsetInKV(topic, queueId);
        if (byteBuffer == null) {
            return;
        }
        long maxPhyOffset = byteBuffer.getLong(0);
        long maxCqOffset = byteBuffer.getLong(8);
        long maxPhyOffsetInCQ = this.getMaxPhyOffset();
        if (maxPhyOffset >= maxPhyOffsetInCQ) {
            this.correctMaxCqOffset(topic, queueId, maxCqOffset, maxPhyOffsetInCQ);
            Long newMaxCqOffset = this.getHeapMaxCqOffset(topic, queueId);
            ROCKSDB_LOG.warn("truncateDirtyLogicFile topic: {}, queueId: {} from {} to {}", new Object[]{topic, queueId, maxPhyOffset, newMaxCqOffset});
        }
    }

    private void correctMaxPyhOffset(long maxPhyOffset) throws RocksDBException {
        if (!this.rocksDBStorage.hold()) {
            return;
        }
        try {
            WriteBatch writeBatch = new WriteBatch();
            long oldMaxPhyOffset = this.getMaxPhyOffset();
            if (oldMaxPhyOffset <= maxPhyOffset) {
                return;
            }
            log.info("correctMaxPyhOffset, oldMaxPhyOffset={}, newMaxPhyOffset={}", (Object)oldMaxPhyOffset, (Object)maxPhyOffset);
            this.appendMaxPhyOffset(writeBatch, maxPhyOffset);
            this.rocksDBStorage.batchPut(writeBatch);
        }
        catch (RocksDBException e) {
            ERROR_LOG.error("correctMaxPyhOffset Failed.", (Throwable)e);
            throw e;
        }
        finally {
            this.rocksDBStorage.release();
        }
    }

    public long getMinCqOffset(String topic, int queueId) throws RocksDBException {
        PhyAndCQOffset phyAndCQOffset;
        long minPhyOffset = this.messageStore.getMinPhyOffset();
        Pair<Boolean, Long> pair = this.isMinOffsetOk(topic, queueId, minPhyOffset);
        long cqOffset = (Long)pair.getObject2();
        if (!((Boolean)pair.getObject1()).booleanValue() && this.correctMinCqOffset(topic, queueId, cqOffset, minPhyOffset) && (phyAndCQOffset = this.getHeapMinOffset(topic, queueId)) != null) {
            if (this.messageStore.getMessageStoreConfig().isEnableRocksDBLog()) {
                ROCKSDB_LOG.warn("getMinOffsetInQueue miss heap. topic: {}, queueId: {}, old: {}, new: {}", new Object[]{topic, queueId, cqOffset, phyAndCQOffset});
            }
            return phyAndCQOffset.getCqOffset();
        }
        return cqOffset;
    }

    public Long getMaxPhyOffset(String topic, int queueId) {
        try {
            ByteBuffer byteBuffer = this.getMaxPhyAndCqOffsetInKV(topic, queueId);
            if (byteBuffer != null) {
                return byteBuffer.getLong(0);
            }
        }
        catch (Exception e) {
            ERROR_LOG.info("getMaxPhyOffset error. topic: {}, queueId: {}", (Object)topic, (Object)queueId);
        }
        return null;
    }

    private ByteBuffer getMinPhyAndCqOffsetInKV(String topic, int queueId) throws RocksDBException {
        return this.getPhyAndCqOffsetInKV(topic, queueId, false);
    }

    private ByteBuffer getMaxPhyAndCqOffsetInKV(String topic, int queueId) throws RocksDBException {
        return this.getPhyAndCqOffsetInKV(topic, queueId, true);
    }

    private ByteBuffer getPhyAndCqOffsetInKV(String topic, int queueId, boolean max) throws RocksDBException {
        byte[] topicBytes = topic.getBytes(DataConverter.CHARSET_UTF8);
        ByteBuffer keyBB = this.buildOffsetKeyByteBuffer(topicBytes, queueId, max);
        byte[] value = this.rocksDBStorage.getOffset(keyBB.array());
        return value != null ? ByteBuffer.wrap(value) : null;
    }

    private String buildTopicQueueId(String topic, int queueId) {
        return topic + "-" + queueId;
    }

    private void putHeapMinCqOffset(String topic, int queueId, long minPhyOffset, long minCQOffset) {
        String topicQueueId = this.buildTopicQueueId(topic, queueId);
        PhyAndCQOffset phyAndCQOffset = new PhyAndCQOffset(minPhyOffset, minCQOffset);
        this.topicQueueMinOffset.put(topicQueueId, phyAndCQOffset);
    }

    private void putHeapMaxCqOffset(String topic, int queueId, long maxCQOffset) {
        String topicQueueId = this.buildTopicQueueId(topic, queueId);
        Long oldMaxCqOffset = this.topicQueueMaxCqOffset.put(topicQueueId, maxCQOffset);
        if (oldMaxCqOffset != null && oldMaxCqOffset > maxCQOffset) {
            ERROR_LOG.error("cqOffset invalid0. old: {}, now: {}", (Object)oldMaxCqOffset, (Object)maxCQOffset);
        }
    }

    private PhyAndCQOffset getHeapMinOffset(String topic, int queueId) {
        return this.topicQueueMinOffset.get(this.buildTopicQueueId(topic, queueId));
    }

    private Long getHeapMaxCqOffset(String topic, int queueId) {
        String topicQueueId = this.buildTopicQueueId(topic, queueId);
        return this.topicQueueMaxCqOffset.get(topicQueueId);
    }

    private PhyAndCQOffset removeHeapMinCqOffset(String topicQueueId) {
        return this.topicQueueMinOffset.remove(topicQueueId);
    }

    private Long removeHeapMaxCqOffset(String topicQueueId) {
        return this.topicQueueMaxCqOffset.remove(topicQueueId);
    }

    private void updateCqOffset(String topic, int queueId, long phyOffset, long cqOffset, boolean max) throws RocksDBException {
        WriteBatch writeBatch;
        block8: {
            if (!this.rocksDBStorage.hold()) {
                return;
            }
            writeBatch = new WriteBatch();
            try {
                byte[] topicBytes = topic.getBytes(DataConverter.CHARSET_UTF8);
                ByteBuffer offsetKey = this.buildOffsetKeyByteBuffer(topicBytes, queueId, max);
                ByteBuffer offsetValue = this.buildOffsetValueByteBuffer(phyOffset, cqOffset);
                writeBatch.put(this.offsetCFH, offsetKey.array(), offsetValue.array());
                this.rocksDBStorage.batchPut(writeBatch);
                if (max) {
                    this.putHeapMaxCqOffset(topic, queueId, cqOffset);
                    break block8;
                }
                this.putHeapMinCqOffset(topic, queueId, phyOffset, cqOffset);
            }
            catch (RocksDBException e) {
                try {
                    ERROR_LOG.error("updateCqOffset({}) failed.", (Object)(max ? "max" : "min"), (Object)e);
                    throw e;
                }
                catch (Throwable throwable) {
                    writeBatch.close();
                    this.rocksDBStorage.release();
                    if (this.messageStore.getMessageStoreConfig().isEnableRocksDBLog()) {
                        ROCKSDB_LOG.warn("updateCqOffset({}). topic: {}, queueId: {}, phyOffset: {}, cqOffset: {}", new Object[]{max ? "max" : "min", topic, queueId, phyOffset, cqOffset});
                    }
                    throw throwable;
                }
            }
        }
        writeBatch.close();
        this.rocksDBStorage.release();
        if (this.messageStore.getMessageStoreConfig().isEnableRocksDBLog()) {
            ROCKSDB_LOG.warn("updateCqOffset({}). topic: {}, queueId: {}, phyOffset: {}, cqOffset: {}", new Object[]{max ? "max" : "min", topic, queueId, phyOffset, cqOffset});
        }
    }

    private boolean correctMaxCqOffset(String topic, int queueId, long maxCQOffset, long maxPhyOffsetInCQ) throws RocksDBException {
        long minCQOffset = this.getMinCqOffset(topic, queueId);
        PhyAndCQOffset minPhyAndCQOffset = this.getHeapMinOffset(topic, queueId);
        if (minPhyAndCQOffset == null || minPhyAndCQOffset.getCqOffset() != minCQOffset || minPhyAndCQOffset.getPhyOffset() > maxPhyOffsetInCQ) {
            ROCKSDB_LOG.info("[BUG] correctMaxCqOffset error! topic: {}, queueId: {}, maxPhyOffsetInCQ: {}, minCqOffset: {}, phyAndCQOffset: {}", new Object[]{topic, queueId, maxPhyOffsetInCQ, minCQOffset, minPhyAndCQOffset});
            throw new RocksDBException("correctMaxCqOffset error");
        }
        long high = maxCQOffset;
        long low = minCQOffset;
        PhyAndCQOffset targetPhyAndCQOffset = this.rocksDBConsumeQueueTable.binarySearchInCQ(topic, queueId, high, low, maxPhyOffsetInCQ, false);
        long targetCQOffset = targetPhyAndCQOffset.getCqOffset();
        long targetPhyOffset = targetPhyAndCQOffset.getPhyOffset();
        if (targetCQOffset == -1L) {
            if (maxCQOffset != minCQOffset) {
                this.updateCqOffset(topic, queueId, minPhyAndCQOffset.getPhyOffset(), minCQOffset, true);
            }
            if (this.messageStore.getMessageStoreConfig().isEnableRocksDBLog()) {
                ROCKSDB_LOG.warn("correct error. {}, {}, {}, {}, {}", new Object[]{topic, queueId, minCQOffset, maxCQOffset, minPhyAndCQOffset.getPhyOffset()});
            }
            return false;
        }
        this.updateCqOffset(topic, queueId, targetPhyOffset, targetCQOffset, true);
        return true;
    }

    private boolean correctMinCqOffset(String topic, int queueId, long minCQOffset, long minPhyOffset) throws RocksDBException {
        ByteBuffer maxBB = this.getMaxPhyAndCqOffsetInKV(topic, queueId);
        if (maxBB == null) {
            this.updateCqOffset(topic, queueId, minPhyOffset, 0L, false);
            return true;
        }
        long maxPhyOffset = maxBB.getLong(0);
        long maxCQOffset = maxBB.getLong(8);
        if (maxPhyOffset < minPhyOffset) {
            this.updateCqOffset(topic, queueId, minPhyOffset, maxCQOffset + 1L, false);
            return true;
        }
        long high = maxCQOffset;
        long low = minCQOffset;
        PhyAndCQOffset phyAndCQOffset = this.rocksDBConsumeQueueTable.binarySearchInCQ(topic, queueId, high, low, minPhyOffset, true);
        long targetCQOffset = phyAndCQOffset.getCqOffset();
        long targetPhyOffset = phyAndCQOffset.getPhyOffset();
        if (targetCQOffset == -1L) {
            if (maxCQOffset != minCQOffset) {
                this.updateCqOffset(topic, queueId, maxPhyOffset, maxCQOffset, false);
            }
            if (this.messageStore.getMessageStoreConfig().isEnableRocksDBLog()) {
                ROCKSDB_LOG.warn("correct error. {}, {}, {}, {}, {}", new Object[]{topic, queueId, minCQOffset, maxCQOffset, minPhyOffset});
            }
            return false;
        }
        this.updateCqOffset(topic, queueId, targetPhyOffset, targetCQOffset, false);
        return true;
    }

    public static Pair<ByteBuffer, ByteBuffer> getOffsetByteBufferPair() {
        ByteBuffer offsetKey = ByteBuffer.allocateDirect(300);
        ByteBuffer offsetValue = ByteBuffer.allocateDirect(16);
        return new Pair((Object)offsetKey, (Object)offsetValue);
    }

    private void buildOffsetKeyAndValueByteBuffer(Pair<ByteBuffer, ByteBuffer> offsetBBPair, byte[] topicBytes, DispatchRequest request) {
        ByteBuffer offsetKey = (ByteBuffer)offsetBBPair.getObject1();
        this.buildOffsetKeyByteBuffer(offsetKey, topicBytes, request.getQueueId(), true);
        ByteBuffer offsetValue = (ByteBuffer)offsetBBPair.getObject2();
        this.buildOffsetValueByteBuffer(offsetValue, request.getCommitLogOffset(), request.getConsumeQueueOffset());
    }

    private ByteBuffer buildOffsetKeyByteBuffer(byte[] topicBytes, int queueId, boolean max) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(14 + topicBytes.length);
        RocksDBConsumeQueueOffsetTable.buildOffsetKeyByteBuffer0(byteBuffer, topicBytes, queueId, max);
        return byteBuffer;
    }

    private void buildOffsetKeyByteBuffer(ByteBuffer byteBuffer, byte[] topicBytes, int queueId, boolean max) {
        byteBuffer.position(0).limit(14 + topicBytes.length);
        RocksDBConsumeQueueOffsetTable.buildOffsetKeyByteBuffer0(byteBuffer, topicBytes, queueId, max);
    }

    private static void buildOffsetKeyByteBuffer0(ByteBuffer byteBuffer, byte[] topicBytes, int queueId, boolean max) {
        byteBuffer.putInt(topicBytes.length).put((byte)1).put(topicBytes).put((byte)1);
        if (max) {
            byteBuffer.put(MAX_BYTES);
        } else {
            byteBuffer.put(MIN_BYTES);
        }
        byteBuffer.put((byte)1).putInt(queueId);
        byteBuffer.flip();
    }

    private void buildOffsetValueByteBuffer(ByteBuffer byteBuffer, long phyOffset, long cqOffset) {
        byteBuffer.position(0).limit(16);
        this.buildOffsetValueByteBuffer0(byteBuffer, phyOffset, cqOffset);
    }

    private ByteBuffer buildOffsetValueByteBuffer(long phyOffset, long cqOffset) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(16);
        this.buildOffsetValueByteBuffer0(byteBuffer, phyOffset, cqOffset);
        return byteBuffer;
    }

    private void buildOffsetValueByteBuffer0(ByteBuffer byteBuffer, long phyOffset, long cqOffset) {
        byteBuffer.putLong(phyOffset).putLong(cqOffset);
        byteBuffer.flip();
    }

    static {
        RocksDBConsumeQueueOffsetTable.buildOffsetKeyByteBuffer0(INNER_CHECKPOINT_TOPIC, MAX_PHYSICAL_OFFSET_CHECKPOINT_BYTES, 0, true);
        INNER_CHECKPOINT_TOPIC.position(0).limit(INNER_CHECKPOINT_TOPIC_LEN);
        INNER_CHECKPOINT_TOPIC.get(MAX_PHYSICAL_OFFSET_CHECKPOINT_KEY);
    }

    static class PhyAndCQOffset {
        private final long phyOffset;
        private final long cqOffset;

        public PhyAndCQOffset(long phyOffset, long cqOffset) {
            this.phyOffset = phyOffset;
            this.cqOffset = cqOffset;
        }

        public long getPhyOffset() {
            return this.phyOffset;
        }

        public long getCqOffset() {
            return this.cqOffset;
        }

        public String toString() {
            return "[cqOffset=" + this.cqOffset + ", phyOffset=" + this.phyOffset + "]";
        }
    }
}

