/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.timer;

import com.conversantmedia.util.concurrent.DisruptorBlockingQueue;
import io.opentelemetry.api.common.Attributes;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.rocketmq.common.ServiceThread;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.common.TopicFilterType;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageAccessor;
import org.apache.rocketmq.common.message.MessageClientIDSetter;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageExtBrokerInner;
import org.apache.rocketmq.common.utils.ThreadUtils;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.store.DefaultMessageStore;
import org.apache.rocketmq.store.MessageStore;
import org.apache.rocketmq.store.PutMessageResult;
import org.apache.rocketmq.store.SelectMappedBufferResult;
import org.apache.rocketmq.store.config.BrokerRole;
import org.apache.rocketmq.store.config.MessageStoreConfig;
import org.apache.rocketmq.store.logfile.MappedFile;
import org.apache.rocketmq.store.metrics.DefaultStoreMetricsManager;
import org.apache.rocketmq.store.queue.ConsumeQueueInterface;
import org.apache.rocketmq.store.queue.CqUnit;
import org.apache.rocketmq.store.queue.ReferredIterator;
import org.apache.rocketmq.store.stats.BrokerStatsManager;
import org.apache.rocketmq.store.timer.Slot;
import org.apache.rocketmq.store.timer.TimerCheckpoint;
import org.apache.rocketmq.store.timer.TimerLog;
import org.apache.rocketmq.store.timer.TimerMetrics;
import org.apache.rocketmq.store.timer.TimerRequest;
import org.apache.rocketmq.store.timer.TimerWheel;
import org.apache.rocketmq.store.util.PerfCounter;

public class TimerMessageStore {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"RocketmqStore");
    public static final int INITIAL = 0;
    public static final int RUNNING = 1;
    public static final int HAULT = 2;
    public static final int SHUTDOWN = 3;
    private volatile int state = 0;
    public static final String TIMER_TOPIC = "rmq_sys_wheel_timer";
    public static final String TIMER_OUT_MS = "TIMER_OUT_MS";
    public static final String TIMER_ENQUEUE_MS = "TIMER_ENQUEUE_MS";
    public static final String TIMER_DEQUEUE_MS = "TIMER_DEQUEUE_MS";
    public static final String TIMER_ROLL_TIMES = "TIMER_ROLL_TIMES";
    public static final String TIMER_DELETE_UNIQUE_KEY = "TIMER_DEL_UNIQKEY";
    public static final Random RANDOM = new Random();
    public static final int PUT_OK = 0;
    public static final int PUT_NEED_RETRY = 1;
    public static final int PUT_NO_RETRY = 2;
    public static final int DAY_SECS = 86400;
    public static final int DEFAULT_CAPACITY = 1024;
    public static final int TIMER_WHEEL_TTL_DAY = 7;
    public static final int TIMER_BLANK_SLOTS = 60;
    public static final int MAGIC_DEFAULT = 1;
    public static final int MAGIC_ROLL = 2;
    public static final int MAGIC_DELETE = 4;
    public boolean debug = false;
    protected static final String ENQUEUE_PUT = "enqueue_put";
    protected static final String DEQUEUE_PUT = "dequeue_put";
    protected final PerfCounter.Ticks perfCounterTicks = new PerfCounter.Ticks(LOGGER);
    protected final BlockingQueue<TimerRequest> enqueuePutQueue;
    protected final BlockingQueue<List<TimerRequest>> dequeueGetQueue;
    protected final BlockingQueue<TimerRequest> dequeuePutQueue;
    private final ByteBuffer timerLogBuffer = ByteBuffer.allocate(4096);
    private final ThreadLocal<ByteBuffer> bufferLocal;
    private final ScheduledExecutorService scheduler;
    private final MessageStore messageStore;
    private final TimerWheel timerWheel;
    private final TimerLog timerLog;
    private final TimerCheckpoint timerCheckpoint;
    private TimerEnqueueGetService enqueueGetService;
    private TimerEnqueuePutService enqueuePutService;
    private TimerDequeueWarmService dequeueWarmService;
    private TimerDequeueGetService dequeueGetService;
    private TimerDequeuePutMessageService[] dequeuePutMessageServices;
    private TimerDequeueGetMessageService[] dequeueGetMessageServices;
    private TimerFlushService timerFlushService;
    protected volatile long currReadTimeMs;
    protected volatile long currWriteTimeMs;
    protected volatile long preReadTimeMs;
    protected volatile long commitReadTimeMs;
    protected volatile long currQueueOffset;
    protected volatile long commitQueueOffset;
    protected volatile long lastCommitReadTimeMs;
    protected volatile long lastCommitQueueOffset;
    private long lastEnqueueButExpiredTime;
    private long lastEnqueueButExpiredStoreTime;
    private final int commitLogFileSize;
    private final int timerLogFileSize;
    private final int timerRollWindowSlots;
    private final int slotsTotal;
    protected final int precisionMs;
    protected final MessageStoreConfig storeConfig;
    protected TimerMetrics timerMetrics;
    protected long lastTimeOfCheckMetrics = System.currentTimeMillis();
    protected AtomicInteger frequency = new AtomicInteger(0);
    private volatile BrokerRole lastBrokerRole = BrokerRole.SLAVE;
    private boolean dequeueStatusChangeFlag = false;
    private long shouldStartTime;
    protected volatile boolean shouldRunningDequeue;
    private final BrokerStatsManager brokerStatsManager;
    private Function<MessageExtBrokerInner, PutMessageResult> escapeBridgeHook;

    public TimerMessageStore(MessageStore messageStore, final MessageStoreConfig storeConfig, TimerCheckpoint timerCheckpoint, TimerMetrics timerMetrics, BrokerStatsManager brokerStatsManager) throws IOException {
        this.messageStore = messageStore;
        this.storeConfig = storeConfig;
        this.commitLogFileSize = storeConfig.getMappedFileSizeCommitLog();
        this.timerLogFileSize = storeConfig.getMappedFileSizeTimerLog();
        this.precisionMs = storeConfig.getTimerPrecisionMs();
        this.slotsTotal = 604800;
        this.timerWheel = new TimerWheel(TimerMessageStore.getTimerWheelPath(storeConfig.getStorePathRootDir()), this.slotsTotal, this.precisionMs);
        this.timerLog = new TimerLog(TimerMessageStore.getTimerLogPath(storeConfig.getStorePathRootDir()), this.timerLogFileSize);
        this.timerMetrics = timerMetrics;
        this.timerCheckpoint = timerCheckpoint;
        this.lastBrokerRole = storeConfig.getBrokerRole();
        this.scheduler = messageStore instanceof DefaultMessageStore ? ThreadUtils.newSingleThreadScheduledExecutor((ThreadFactory)new ThreadFactoryImpl("TimerScheduledThread", ((DefaultMessageStore)messageStore).getBrokerIdentity())) : ThreadUtils.newSingleThreadScheduledExecutor((ThreadFactory)new ThreadFactoryImpl("TimerScheduledThread"));
        this.timerRollWindowSlots = storeConfig.getTimerRollWindowSlot() > this.slotsTotal - 60 || storeConfig.getTimerRollWindowSlot() < 2 ? this.slotsTotal - 60 : storeConfig.getTimerRollWindowSlot();
        this.bufferLocal = new ThreadLocal<ByteBuffer>(){

            @Override
            protected ByteBuffer initialValue() {
                return ByteBuffer.allocateDirect(storeConfig.getMaxMessageSize() + 100);
            }
        };
        if (storeConfig.isTimerEnableDisruptor()) {
            this.enqueuePutQueue = new DisruptorBlockingQueue(1024);
            this.dequeueGetQueue = new DisruptorBlockingQueue(1024);
            this.dequeuePutQueue = new DisruptorBlockingQueue(1024);
        } else {
            this.enqueuePutQueue = new LinkedBlockingDeque<TimerRequest>(1024);
            this.dequeueGetQueue = new LinkedBlockingDeque<List<TimerRequest>>(1024);
            this.dequeuePutQueue = new LinkedBlockingDeque<TimerRequest>(1024);
        }
        this.brokerStatsManager = brokerStatsManager;
    }

    public void initService() {
        this.enqueueGetService = new TimerEnqueueGetService();
        this.enqueuePutService = new TimerEnqueuePutService();
        this.dequeueWarmService = new TimerDequeueWarmService();
        this.dequeueGetService = new TimerDequeueGetService();
        this.timerFlushService = new TimerFlushService();
        int getThreadNum = Math.max(this.storeConfig.getTimerGetMessageThreadNum(), 1);
        this.dequeueGetMessageServices = new TimerDequeueGetMessageService[getThreadNum];
        for (int i = 0; i < this.dequeueGetMessageServices.length; ++i) {
            this.dequeueGetMessageServices[i] = new TimerDequeueGetMessageService();
        }
        int putThreadNum = Math.max(this.storeConfig.getTimerPutMessageThreadNum(), 1);
        this.dequeuePutMessageServices = new TimerDequeuePutMessageService[putThreadNum];
        for (int i = 0; i < this.dequeuePutMessageServices.length; ++i) {
            this.dequeuePutMessageServices[i] = new TimerDequeuePutMessageService();
        }
    }

    public boolean load() {
        this.initService();
        boolean load = this.timerLog.load();
        load = load && this.timerMetrics.load();
        this.recover();
        this.calcTimerDistribution();
        return load;
    }

    public static String getTimerWheelPath(String rootDir) {
        return rootDir + File.separator + "timerwheel";
    }

    public static String getTimerLogPath(String rootDir) {
        return rootDir + File.separator + "timerlog";
    }

    private void calcTimerDistribution() {
        long startTime = System.currentTimeMillis();
        List<Integer> timerDist = this.timerMetrics.getTimerDistList();
        long currTime = System.currentTimeMillis() / (long)this.precisionMs * (long)this.precisionMs;
        for (int i = 0; i < timerDist.size(); ++i) {
            int slotBeforeNum = i == 0 ? 0 : timerDist.get(i - 1) * 1000 / this.precisionMs;
            int slotTotalNum = timerDist.get(i) * 1000 / this.precisionMs;
            int periodTotal = 0;
            for (int j = slotBeforeNum; j < slotTotalNum; ++j) {
                Slot slotEach = this.timerWheel.getSlot(currTime + (long)j * (long)this.precisionMs);
                periodTotal += slotEach.num;
            }
            LOGGER.debug("{} period's total num: {}", (Object)timerDist.get(i), (Object)periodTotal);
            this.timerMetrics.updateDistPair(timerDist.get(i), periodTotal);
        }
        long endTime = System.currentTimeMillis();
        LOGGER.debug("Total cost Time: {}", (Object)(endTime - startTime));
    }

    public void recover() {
        long lastFlushPos = this.timerCheckpoint.getLastTimerLogFlushPos();
        MappedFile lastFile = this.timerLog.getMappedFileQueue().getLastMappedFile();
        if (null != lastFile) {
            lastFlushPos -= (long)lastFile.getFileSize();
        }
        if (lastFlushPos < 0L) {
            lastFlushPos = 0L;
        }
        long processOffset = this.recoverAndRevise(lastFlushPos, true);
        this.timerLog.getMappedFileQueue().setFlushedWhere(processOffset);
        long queueOffset = this.reviseQueueOffset(processOffset);
        this.currQueueOffset = -1L == queueOffset ? this.timerCheckpoint.getLastTimerQueueOffset() : queueOffset + 1L;
        this.currQueueOffset = Math.min(this.currQueueOffset, this.timerCheckpoint.getMasterTimerQueueOffset());
        this.currReadTimeMs = this.timerCheckpoint.getLastReadTimeMs();
        long nextReadTimeMs = this.formatTimeMs(System.currentTimeMillis()) - (long)this.slotsTotal * (long)this.precisionMs + 60L * (long)this.precisionMs;
        if (this.currReadTimeMs < nextReadTimeMs) {
            this.currReadTimeMs = nextReadTimeMs;
        }
        long minFirst = this.timerWheel.checkPhyPos(this.currReadTimeMs, processOffset);
        if (this.debug) {
            minFirst = 0L;
        }
        if (minFirst < processOffset) {
            LOGGER.warn("Timer recheck because of minFirst:{} processOffset:{}", (Object)minFirst, (Object)processOffset);
            this.recoverAndRevise(minFirst, false);
        }
        LOGGER.info("Timer recover ok currReadTimerMs:{} currQueueOffset:{} checkQueueOffset:{} processOffset:{}", new Object[]{this.currReadTimeMs, this.currQueueOffset, this.timerCheckpoint.getLastTimerQueueOffset(), processOffset});
        this.commitReadTimeMs = this.currReadTimeMs;
        this.commitQueueOffset = this.currQueueOffset;
        this.prepareTimerCheckPoint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long reviseQueueOffset(long processOffset) {
        SelectMappedBufferResult selectRes = this.timerLog.getTimerMessage(processOffset - 24L);
        if (null == selectRes) {
            return -1L;
        }
        try {
            long offsetPy = selectRes.getByteBuffer().getLong();
            int sizePy = selectRes.getByteBuffer().getInt();
            MessageExt messageExt = this.getMessageByCommitOffset(offsetPy, sizePy);
            if (null == messageExt) {
                long l = -1L;
                return l;
            }
            long msgQueueOffset = messageExt.getQueueOffset();
            int queueId = messageExt.getQueueId();
            ConsumeQueueInterface cq = this.messageStore.getConsumeQueue(TIMER_TOPIC, queueId);
            if (null == cq) {
                long l = msgQueueOffset;
                return l;
            }
            long cqOffset = msgQueueOffset;
            long tmpOffset = msgQueueOffset;
            int maxCount = 20000;
            while (maxCount-- > 0) {
                if (tmpOffset < 0L) {
                    LOGGER.warn("reviseQueueOffset check cq offset fail, msg in cq is not found.{}, {}", (Object)offsetPy, (Object)sizePy);
                    break;
                }
                ReferredIterator<CqUnit> iterator = null;
                try {
                    iterator = cq.iterateFrom(tmpOffset);
                    CqUnit cqUnit = null;
                    if (null == iterator || (cqUnit = (CqUnit)iterator.next()) == null) {
                        --tmpOffset;
                        continue;
                    }
                    long offsetPyTemp = cqUnit.getPos();
                    int sizePyTemp = cqUnit.getSize();
                    if (offsetPyTemp == offsetPy && sizePyTemp == sizePy) {
                        LOGGER.info("reviseQueueOffset check cq offset ok. {}, {}, {}", new Object[]{tmpOffset, offsetPyTemp, sizePyTemp});
                        cqOffset = tmpOffset;
                        break;
                    }
                    --tmpOffset;
                }
                catch (Throwable e) {
                    LOGGER.error("reviseQueueOffset check cq offset error.", e);
                }
                finally {
                    if (iterator == null) continue;
                    iterator.release();
                }
            }
            long l = cqOffset;
            return l;
        }
        finally {
            selectRes.release();
        }
    }

    private long recoverAndRevise(long beginOffset, boolean checkTimerLog) {
        MappedFile mappedFile;
        int index;
        LOGGER.info("Begin to recover timerLog offset:{} check:{}", (Object)beginOffset, (Object)checkTimerLog);
        MappedFile lastFile = this.timerLog.getMappedFileQueue().getLastMappedFile();
        if (null == lastFile) {
            return 0L;
        }
        List<MappedFile> mappedFiles = this.timerLog.getMappedFileQueue().getMappedFiles();
        for (index = mappedFiles.size() - 1; index >= 0 && beginOffset < (mappedFile = mappedFiles.get(index)).getFileFromOffset(); --index) {
        }
        if (index < 0) {
            index = 0;
        }
        long checkOffset = mappedFiles.get(index).getFileFromOffset();
        while (index < mappedFiles.size()) {
            int position;
            MappedFile mappedFile2 = mappedFiles.get(index);
            SelectMappedBufferResult sbr = mappedFile2.selectMappedBuffer(0, checkTimerLog ? mappedFiles.get(index).getFileSize() : mappedFile2.getReadPosition());
            ByteBuffer bf = sbr.getByteBuffer();
            boolean stopCheck = false;
            for (position = 0; position < sbr.getSize(); position += 52) {
                try {
                    bf.position(position);
                    int size = bf.getInt();
                    bf.getLong();
                    int magic = bf.getInt();
                    if (magic == -875286124) break;
                    if (checkTimerLog && (!TimerMessageStore.isMagicOK(magic) || 52 != size)) {
                        stopCheck = true;
                        break;
                    }
                    long delayTime = bf.getLong() + (long)bf.getInt();
                    if (52 != size || !TimerMessageStore.isMagicOK(magic)) continue;
                    this.timerWheel.reviseSlot(delayTime, -2L, sbr.getStartOffset() + (long)position, true);
                    continue;
                }
                catch (Exception e) {
                    LOGGER.error("Recover timerLog error", (Throwable)e);
                    stopCheck = true;
                    break;
                }
            }
            sbr.release();
            checkOffset = mappedFiles.get(index).getFileFromOffset() + (long)position;
            if (stopCheck) break;
            ++index;
        }
        if (checkTimerLog) {
            this.timerLog.getMappedFileQueue().truncateDirtyFiles(checkOffset);
        }
        return checkOffset;
    }

    public static boolean isMagicOK(int magic) {
        return (magic | 0xF) == 15;
    }

    public void start() {
        int i;
        this.shouldStartTime = (long)this.storeConfig.getDisappearTimeAfterStart() + System.currentTimeMillis();
        this.maybeMoveWriteTime();
        this.enqueueGetService.start();
        this.enqueuePutService.start();
        this.dequeueWarmService.start();
        this.dequeueGetService.start();
        for (i = 0; i < this.dequeueGetMessageServices.length; ++i) {
            this.dequeueGetMessageServices[i].start();
        }
        for (i = 0; i < this.dequeuePutMessageServices.length; ++i) {
            this.dequeuePutMessageServices[i].start();
        }
        this.timerFlushService.start();
        this.scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    long minPy = TimerMessageStore.this.messageStore.getMinPhyOffset();
                    int checkOffset = TimerMessageStore.this.timerLog.getOffsetForLastUnit();
                    TimerMessageStore.this.timerLog.getMappedFileQueue().deleteExpiredFileByOffsetForTimerLog(minPy, checkOffset, 52);
                }
                catch (Exception e) {
                    LOGGER.error("Error in cleaning timerLog", (Throwable)e);
                }
            }
        }, 30L, 30L, TimeUnit.SECONDS);
        this.scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    if (TimerMessageStore.this.storeConfig.isTimerEnableCheckMetrics()) {
                        String when = TimerMessageStore.this.storeConfig.getTimerCheckMetricsWhen();
                        if (!UtilAll.isItTimeToDo((String)when)) {
                            return;
                        }
                        long curr = System.currentTimeMillis();
                        if (curr - TimerMessageStore.this.lastTimeOfCheckMetrics > 4200000L) {
                            TimerMessageStore.this.lastTimeOfCheckMetrics = curr;
                            TimerMessageStore.this.checkAndReviseMetrics();
                            LOGGER.info("[CheckAndReviseMetrics]Timer do check timer metrics cost {} ms", (Object)(System.currentTimeMillis() - curr));
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Error in cleaning timerLog", (Throwable)e);
                }
            }
        }, 45L, 45L, TimeUnit.MINUTES);
        this.state = 1;
        LOGGER.info("Timer start ok currReadTimerMs:[{}] queueOffset:[{}]", (Object)new Timestamp(this.currReadTimeMs), (Object)this.currQueueOffset);
    }

    public void start(boolean shouldRunningDequeue) {
        this.shouldRunningDequeue = shouldRunningDequeue;
        this.start();
    }

    public void shutdown() {
        int i;
        if (3 == this.state) {
            return;
        }
        this.state = 3;
        this.prepareTimerCheckPoint();
        this.timerFlushService.shutdown();
        this.timerLog.shutdown();
        this.timerCheckpoint.shutdown();
        this.enqueuePutQueue.clear();
        this.dequeueGetQueue.clear();
        this.dequeuePutQueue.clear();
        this.enqueueGetService.shutdown();
        this.enqueuePutService.shutdown();
        this.dequeueWarmService.shutdown();
        this.dequeueGetService.shutdown();
        for (i = 0; i < this.dequeueGetMessageServices.length; ++i) {
            this.dequeueGetMessageServices[i].shutdown();
        }
        for (i = 0; i < this.dequeuePutMessageServices.length; ++i) {
            this.dequeuePutMessageServices[i].shutdown();
        }
        this.timerWheel.shutdown(false);
        this.scheduler.shutdown();
        UtilAll.cleanBuffer((ByteBuffer)this.bufferLocal.get());
        this.bufferLocal.remove();
    }

    protected void maybeMoveWriteTime() {
        if (this.currWriteTimeMs < this.formatTimeMs(System.currentTimeMillis())) {
            this.currWriteTimeMs = this.formatTimeMs(System.currentTimeMillis());
        }
    }

    private void moveReadTime() {
        this.currReadTimeMs += (long)this.precisionMs;
        this.commitReadTimeMs = this.currReadTimeMs;
    }

    private boolean isRunning() {
        return 1 == this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkBrokerRole() {
        BrokerRole currRole = this.storeConfig.getBrokerRole();
        if (this.lastBrokerRole != currRole) {
            BrokerRole brokerRole = this.lastBrokerRole;
            synchronized (brokerRole) {
                LOGGER.info("Broker role change from {} to {}", (Object)this.lastBrokerRole, (Object)currRole);
                if (BrokerRole.SLAVE != currRole) {
                    this.commitQueueOffset = this.currQueueOffset = Math.min(this.currQueueOffset, this.timerCheckpoint.getMasterTimerQueueOffset());
                    this.prepareTimerCheckPoint();
                    this.timerCheckpoint.flush();
                    this.commitReadTimeMs = this.currReadTimeMs = this.timerCheckpoint.getLastReadTimeMs();
                }
                this.lastBrokerRole = currRole;
            }
        }
    }

    private boolean isRunningEnqueue() {
        this.checkBrokerRole();
        if (!this.shouldRunningDequeue && !this.isMaster() && this.currQueueOffset >= this.timerCheckpoint.getMasterTimerQueueOffset()) {
            return false;
        }
        return this.isRunning();
    }

    private boolean isRunningDequeue() {
        if (!this.shouldRunningDequeue) {
            this.syncLastReadTimeMs();
            return false;
        }
        return this.isRunning();
    }

    public void syncLastReadTimeMs() {
        this.commitReadTimeMs = this.currReadTimeMs = this.timerCheckpoint.getLastReadTimeMs();
    }

    public void setShouldRunningDequeue(boolean shouldRunningDequeue) {
        this.shouldRunningDequeue = shouldRunningDequeue;
    }

    public boolean isShouldRunningDequeue() {
        return this.shouldRunningDequeue;
    }

    public void addMetric(MessageExt msg, int value) {
        block4: {
            try {
                if (null == msg || null == msg.getProperty("REAL_TOPIC")) {
                    return;
                }
                if (msg.getProperty(TIMER_ENQUEUE_MS) != null && NumberUtils.toLong((String)msg.getProperty(TIMER_ENQUEUE_MS)) == Long.MAX_VALUE) {
                    return;
                }
                this.timerMetrics.addAndGet(msg, value);
            }
            catch (Throwable t) {
                if (this.frequency.incrementAndGet() % 1000 != 0) break block4;
                LOGGER.error("error in adding metric", t);
            }
        }
    }

    public void holdMomentForUnknownError(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void holdMomentForUnknownError() {
        this.holdMomentForUnknownError(50L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enqueue(int queueId) {
        if (this.storeConfig.isTimerStopEnqueue()) {
            return false;
        }
        if (!this.isRunningEnqueue()) {
            return false;
        }
        ConsumeQueueInterface cq = this.messageStore.getConsumeQueue(TIMER_TOPIC, queueId);
        if (null == cq) {
            return false;
        }
        if (this.currQueueOffset < cq.getMinOffsetInQueue()) {
            LOGGER.warn("Timer currQueueOffset:{} is smaller than minOffsetInQueue:{}", (Object)this.currQueueOffset, (Object)cq.getMinOffsetInQueue());
            this.currQueueOffset = cq.getMinOffsetInQueue();
        }
        long offset = this.currQueueOffset;
        ReferredIterator<CqUnit> iterator = null;
        try {
            iterator = cq.iterateFrom(offset);
            if (null == iterator) {
                boolean bl = false;
                return bl;
            }
            int i = 0;
            while (iterator.hasNext()) {
                block25: {
                    ++i;
                    this.perfCounterTicks.startTick("enqueue_get");
                    try {
                        CqUnit cqUnit = (CqUnit)iterator.next();
                        long offsetPy = cqUnit.getPos();
                        int sizePy = cqUnit.getSize();
                        cqUnit.getTagsCode();
                        MessageExt msgExt = this.getMessageByCommitOffset(offsetPy, sizePy);
                        if (null == msgExt) {
                            this.perfCounterTicks.getCounter("enqueue_get_miss");
                            break block25;
                        }
                        this.lastEnqueueButExpiredTime = System.currentTimeMillis();
                        this.lastEnqueueButExpiredStoreTime = msgExt.getStoreTimestamp();
                        long delayedTime = Long.parseLong(msgExt.getProperty(TIMER_OUT_MS));
                        msgExt.setQueueOffset(offset + (long)i);
                        TimerRequest timerRequest = new TimerRequest(offsetPy, sizePy, delayedTime, System.currentTimeMillis(), 1, msgExt);
                        while (!this.enqueuePutQueue.offer(timerRequest, 3L, TimeUnit.SECONDS)) {
                            if (this.isRunningEnqueue()) continue;
                            boolean bl = false;
                            return bl;
                        }
                        Attributes attributes = DefaultStoreMetricsManager.newAttributesBuilder().put("topic", msgExt.getProperty("REAL_TOPIC")).build();
                        DefaultStoreMetricsManager.timerMessageSetLatency.record((delayedTime - msgExt.getBornTimestamp()) / 1000L, attributes);
                    }
                    catch (Exception e) {
                        if (this.storeConfig.isTimerSkipUnknownError()) {
                            LOGGER.warn("Unknown error in skipped in enqueuing", (Throwable)e);
                            break block25;
                        }
                        this.holdMomentForUnknownError();
                        throw e;
                    }
                    finally {
                        this.perfCounterTicks.endTick("enqueue_get");
                    }
                }
                if (!this.isRunningEnqueue()) {
                    boolean bl = false;
                    return bl;
                }
                this.currQueueOffset = offset + (long)i;
            }
            this.currQueueOffset = offset + (long)i;
            boolean bl = i > 0;
            return bl;
        }
        catch (Exception e) {
            LOGGER.error("Unknown exception in enqueuing", (Throwable)e);
        }
        finally {
            if (iterator != null) {
                iterator.release();
            }
        }
        return false;
    }

    public boolean doEnqueue(long offsetPy, int sizePy, long delayedTime, MessageExt messageExt) {
        boolean isDelete;
        LOGGER.debug("Do enqueue [{}] [{}]", (Object)new Timestamp(delayedTime), (Object)messageExt);
        long tmpWriteTimeMs = this.currWriteTimeMs;
        boolean needRoll = delayedTime - tmpWriteTimeMs >= (long)this.timerRollWindowSlots * (long)this.precisionMs;
        int magic = 1;
        if (needRoll) {
            magic |= 2;
            delayedTime = delayedTime - tmpWriteTimeMs - (long)this.timerRollWindowSlots * (long)this.precisionMs < (long)this.timerRollWindowSlots / 3L * (long)this.precisionMs ? tmpWriteTimeMs + (long)(this.timerRollWindowSlots / 2) * (long)this.precisionMs : tmpWriteTimeMs + (long)this.timerRollWindowSlots * (long)this.precisionMs;
        }
        boolean bl = isDelete = messageExt.getProperty(TIMER_DELETE_UNIQUE_KEY) != null;
        if (isDelete) {
            magic |= 4;
        }
        String realTopic = messageExt.getProperty("REAL_TOPIC");
        Slot slot = this.timerWheel.getSlot(delayedTime);
        ByteBuffer tmpBuffer = this.timerLogBuffer;
        tmpBuffer.clear();
        tmpBuffer.putInt(52);
        tmpBuffer.putLong(slot.lastPos);
        tmpBuffer.putInt(magic);
        tmpBuffer.putLong(tmpWriteTimeMs);
        tmpBuffer.putInt((int)(delayedTime - tmpWriteTimeMs));
        tmpBuffer.putLong(offsetPy);
        tmpBuffer.putInt(sizePy);
        tmpBuffer.putInt(this.hashTopicForMetrics(realTopic));
        tmpBuffer.putLong(0L);
        long ret = this.timerLog.append(tmpBuffer.array(), 0, 52);
        if (-1L != ret) {
            this.timerWheel.putSlot(delayedTime, slot.firstPos == -1L ? ret : slot.firstPos, ret, isDelete ? slot.num - 1 : slot.num + 1, slot.magic);
            this.addMetric(messageExt, isDelete ? -1 : 1);
        }
        return -1L != ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int warmDequeue() {
        if (!this.isRunningDequeue()) {
            return -1;
        }
        if (!this.storeConfig.isTimerWarmEnable()) {
            return -1;
        }
        if (this.preReadTimeMs <= this.currReadTimeMs) {
            this.preReadTimeMs = this.currReadTimeMs + (long)this.precisionMs;
        }
        if (this.preReadTimeMs >= this.currWriteTimeMs) {
            return -1;
        }
        if (this.preReadTimeMs >= this.currReadTimeMs + 3L * (long)this.precisionMs) {
            return -1;
        }
        Slot slot = this.timerWheel.getSlot(this.preReadTimeMs);
        if (-1L == slot.timeMs) {
            this.preReadTimeMs += (long)this.precisionMs;
            return 0;
        }
        long currOffsetPy = slot.lastPos;
        LinkedList<SelectMappedBufferResult> sbrs = new LinkedList<SelectMappedBufferResult>();
        SelectMappedBufferResult timeSbr = null;
        SelectMappedBufferResult msgSbr = null;
        try {
            while (currOffsetPy != -1L && this.isRunning()) {
                this.perfCounterTicks.startTick("warm_dequeue");
                if ((null == timeSbr || timeSbr.getStartOffset() > currOffsetPy) && null != (timeSbr = this.timerLog.getWholeBuffer(currOffsetPy))) {
                    sbrs.add(timeSbr);
                }
                if (null == timeSbr) break;
                long prevPos = -1L;
                try {
                    int firstPos;
                    int position = (int)(currOffsetPy % (long)this.timerLogFileSize);
                    timeSbr.getByteBuffer().position(position);
                    timeSbr.getByteBuffer().getInt();
                    prevPos = timeSbr.getByteBuffer().getLong();
                    timeSbr.getByteBuffer().position(position + 28);
                    long offsetPy = timeSbr.getByteBuffer().getLong();
                    int sizePy = timeSbr.getByteBuffer().getInt();
                    if ((null == msgSbr || msgSbr.getStartOffset() > offsetPy) && null != (msgSbr = this.messageStore.getCommitLogData(offsetPy - offsetPy % (long)this.commitLogFileSize))) {
                        sbrs.add(msgSbr);
                    }
                    if (null == msgSbr) continue;
                    ByteBuffer bf = msgSbr.getByteBuffer();
                    for (int pos = firstPos = (int)(offsetPy % (long)this.commitLogFileSize); pos < firstPos + sizePy; pos += 4096) {
                        bf.position(pos);
                        bf.get();
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Unexpected error in warm", (Throwable)e);
                }
                finally {
                    currOffsetPy = prevPos;
                    this.perfCounterTicks.endTick("warm_dequeue");
                }
            }
            for (SelectMappedBufferResult sbr : sbrs) {
                if (null == sbr) continue;
                sbr.release();
            }
        }
        finally {
            this.preReadTimeMs += (long)this.precisionMs;
        }
        return 1;
    }

    public boolean checkStateForPutMessages(int state) {
        for (TimerDequeuePutMessageService service : this.dequeuePutMessageServices) {
            if (service.isState(state)) continue;
            return false;
        }
        return true;
    }

    public boolean checkStateForGetMessages(int state) {
        for (TimerDequeueGetMessageService service : this.dequeueGetMessageServices) {
            if (service.isState(state)) continue;
            return false;
        }
        return true;
    }

    public void checkDequeueLatch(CountDownLatch latch, long delayedTime) throws Exception {
        if (latch.await(1L, TimeUnit.SECONDS)) {
            return;
        }
        int checkNum = 0;
        while (!(this.dequeuePutQueue.size() <= 0 && this.checkStateForGetMessages(1) && this.checkStateForPutMessages(1) && ++checkNum >= 2 || latch.await(1L, TimeUnit.SECONDS))) {
        }
        if (!latch.await(1L, TimeUnit.SECONDS)) {
            LOGGER.warn("Check latch failed delayedTime:{}", (Object)delayedTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int dequeue() throws Exception {
        block23: {
            if (this.storeConfig.isTimerStopDequeue()) {
                return -1;
            }
            if (!this.isRunningDequeue()) {
                return -1;
            }
            if (this.currReadTimeMs >= this.currWriteTimeMs) {
                return -1;
            }
            Slot slot = this.timerWheel.getSlot(this.currReadTimeMs);
            if (-1L == slot.timeMs) {
                this.moveReadTime();
                return 0;
            }
            try {
                this.dequeueStatusChangeFlag = false;
                long currOffsetPy = slot.lastPos;
                ConcurrentSkipListSet<String> deleteUniqKeys = new ConcurrentSkipListSet<String>();
                LinkedList<TimerRequest> normalMsgStack = new LinkedList<TimerRequest>();
                LinkedList<TimerRequest> deleteMsgStack = new LinkedList<TimerRequest>();
                LinkedList<SelectMappedBufferResult> sbrs = new LinkedList<SelectMappedBufferResult>();
                SelectMappedBufferResult timeSbr = null;
                while (currOffsetPy != -1L) {
                    this.perfCounterTicks.startTick("dequeue_read_timerlog");
                    if ((null == timeSbr || timeSbr.getStartOffset() > currOffsetPy) && null != (timeSbr = this.timerLog.getWholeBuffer(currOffsetPy))) {
                        sbrs.add(timeSbr);
                    }
                    if (null == timeSbr) break;
                    long prevPos = -1L;
                    try {
                        int n = (int)(currOffsetPy % (long)this.timerLogFileSize);
                        timeSbr.getByteBuffer().position(n);
                        timeSbr.getByteBuffer().getInt();
                        prevPos = timeSbr.getByteBuffer().getLong();
                        int magic = timeSbr.getByteBuffer().getInt();
                        long enqueueTime = timeSbr.getByteBuffer().getLong();
                        long delayedTime = (long)timeSbr.getByteBuffer().getInt() + enqueueTime;
                        long offsetPy = timeSbr.getByteBuffer().getLong();
                        int sizePy = timeSbr.getByteBuffer().getInt();
                        TimerRequest timerRequest = new TimerRequest(offsetPy, sizePy, delayedTime, enqueueTime, magic);
                        timerRequest.setDeleteList(deleteUniqKeys);
                        if (this.needDelete(magic) && !this.needRoll(magic)) {
                            deleteMsgStack.add(timerRequest);
                            continue;
                        }
                        normalMsgStack.addFirst(timerRequest);
                    }
                    catch (Exception exception) {
                        LOGGER.error("Error in dequeue_read_timerlog", (Throwable)exception);
                    }
                    finally {
                        currOffsetPy = prevPos;
                        this.perfCounterTicks.endTick("dequeue_read_timerlog");
                    }
                }
                if (deleteMsgStack.size() == 0 && normalMsgStack.size() == 0) {
                    LOGGER.warn("dequeue time:{} but read nothing from timerLog", (Object)this.currReadTimeMs);
                }
                for (SelectMappedBufferResult selectMappedBufferResult : sbrs) {
                    if (null == selectMappedBufferResult) continue;
                    selectMappedBufferResult.release();
                }
                if (!this.isRunningDequeue()) {
                    return -1;
                }
                CountDownLatch deleteLatch = new CountDownLatch(deleteMsgStack.size());
                for (List<TimerRequest> list : this.splitIntoLists(deleteMsgStack)) {
                    for (TimerRequest tr : list) {
                        tr.setLatch(deleteLatch);
                    }
                    this.dequeueGetQueue.put(list);
                }
                this.checkDequeueLatch(deleteLatch, this.currReadTimeMs);
                CountDownLatch countDownLatch = new CountDownLatch(normalMsgStack.size());
                for (List<TimerRequest> normalList : this.splitIntoLists(normalMsgStack)) {
                    for (TimerRequest tr : normalList) {
                        tr.setLatch(countDownLatch);
                    }
                    this.dequeueGetQueue.put(normalList);
                }
                this.checkDequeueLatch(countDownLatch, this.currReadTimeMs);
                if (this.dequeueStatusChangeFlag) {
                    return -1;
                }
                if (!this.isRunningDequeue()) {
                    return -1;
                }
                this.moveReadTime();
            }
            catch (Throwable t) {
                LOGGER.error("Unknown error in dequeue process", t);
                if (!this.storeConfig.isTimerSkipUnknownError()) break block23;
                this.moveReadTime();
            }
        }
        return 1;
    }

    private List<List<TimerRequest>> splitIntoLists(List<TimerRequest> origin) {
        LinkedList<List<TimerRequest>> lists = new LinkedList<List<TimerRequest>>();
        if (origin.size() < 100) {
            lists.add(origin);
            return lists;
        }
        AbstractList currList = null;
        int fileIndexPy = -1;
        int msgIndex = 0;
        for (TimerRequest tr : origin) {
            if ((long)fileIndexPy != tr.getOffsetPy() / (long)this.commitLogFileSize) {
                msgIndex = 0;
                if (null != currList && currList.size() > 0) {
                    lists.add(currList);
                }
                currList = new LinkedList<TimerRequest>();
                currList.add(tr);
                fileIndexPy = (int)(tr.getOffsetPy() / (long)this.commitLogFileSize);
                continue;
            }
            currList.add(tr);
            if (++msgIndex % 2000 != 0) continue;
            lists.add(currList);
            currList = new ArrayList();
        }
        if (null != currList && currList.size() > 0) {
            lists.add(currList);
        }
        return lists;
    }

    private MessageExt getMessageByCommitOffset(long offsetPy, int sizePy) {
        for (int i = 0; i < 3; ++i) {
            MessageExt msgExt = null;
            this.bufferLocal.get().position(0);
            this.bufferLocal.get().limit(sizePy);
            boolean res = this.messageStore.getData(offsetPy, sizePy, this.bufferLocal.get());
            if (res) {
                this.bufferLocal.get().flip();
                msgExt = MessageDecoder.decode((ByteBuffer)this.bufferLocal.get(), (boolean)true, (boolean)false, (boolean)false);
            }
            if (null != msgExt) {
                return msgExt;
            }
            LOGGER.warn("Fail to read msg from commitLog offsetPy:{} sizePy:{}", (Object)offsetPy, (Object)sizePy);
        }
        return null;
    }

    public MessageExtBrokerInner convert(MessageExt messageExt, long enqueueTime, boolean needRoll) {
        if (enqueueTime != -1L) {
            MessageAccessor.putProperty((Message)messageExt, (String)TIMER_ENQUEUE_MS, (String)(enqueueTime + ""));
        }
        if (needRoll) {
            if (messageExt.getProperty(TIMER_ROLL_TIMES) != null) {
                MessageAccessor.putProperty((Message)messageExt, (String)TIMER_ROLL_TIMES, (String)(Integer.parseInt(messageExt.getProperty(TIMER_ROLL_TIMES)) + 1 + ""));
            } else {
                MessageAccessor.putProperty((Message)messageExt, (String)TIMER_ROLL_TIMES, (String)"1");
            }
        }
        MessageAccessor.putProperty((Message)messageExt, (String)TIMER_DEQUEUE_MS, (String)(System.currentTimeMillis() + ""));
        MessageExtBrokerInner message = this.convertMessage(messageExt, needRoll);
        return message;
    }

    public int doPut(MessageExtBrokerInner message, boolean roll) throws Exception {
        if (!roll && null != message.getProperty(TIMER_DELETE_UNIQUE_KEY)) {
            LOGGER.warn("Trying do put delete timer msg:[{}] roll:[{}]", (Object)message, (Object)roll);
            return 2;
        }
        PutMessageResult putMessageResult = null;
        putMessageResult = this.escapeBridgeHook != null ? this.escapeBridgeHook.apply(message) : this.messageStore.putMessage(message);
        int retryNum = 0;
        while (retryNum < 3) {
            if (null == putMessageResult || null == putMessageResult.getPutMessageStatus()) {
                ++retryNum;
            } else {
                switch (putMessageResult.getPutMessageStatus()) {
                    case PUT_OK: {
                        if (this.brokerStatsManager != null) {
                            this.brokerStatsManager.incTopicPutNums(message.getTopic(), 1, 1);
                            if (putMessageResult.getAppendMessageResult() != null) {
                                this.brokerStatsManager.incTopicPutSize(message.getTopic(), putMessageResult.getAppendMessageResult().getWroteBytes());
                            }
                            this.brokerStatsManager.incBrokerPutNums(message.getTopic(), 1);
                        }
                        return 0;
                    }
                    case SERVICE_NOT_AVAILABLE: {
                        return 1;
                    }
                    case MESSAGE_ILLEGAL: 
                    case PROPERTIES_SIZE_EXCEEDED: {
                        return 2;
                    }
                }
                ++retryNum;
            }
            Thread.sleep(50L);
            putMessageResult = this.escapeBridgeHook != null ? this.escapeBridgeHook.apply(message) : this.messageStore.putMessage(message);
            LOGGER.warn("Retrying to do put timer msg retryNum:{} putRes:{} msg:{}", new Object[]{retryNum, putMessageResult, message});
        }
        return 2;
    }

    public MessageExtBrokerInner convertMessage(MessageExt msgExt, boolean needRoll) {
        MessageExtBrokerInner msgInner = new MessageExtBrokerInner();
        msgInner.setBody(msgExt.getBody());
        msgInner.setFlag(msgExt.getFlag());
        MessageAccessor.setProperties((Message)msgInner, (Map)MessageAccessor.deepCopyProperties((Map)msgExt.getProperties()));
        TopicFilterType topicFilterType = MessageExt.parseTopicFilterType((int)msgInner.getSysFlag());
        long tagsCodeValue = MessageExtBrokerInner.tagsString2tagsCode((TopicFilterType)topicFilterType, (String)msgInner.getTags());
        msgInner.setTagsCode(tagsCodeValue);
        msgInner.setPropertiesString(MessageDecoder.messageProperties2String((Map)msgExt.getProperties()));
        msgInner.setSysFlag(msgExt.getSysFlag());
        msgInner.setBornTimestamp(msgExt.getBornTimestamp());
        msgInner.setBornHost(msgExt.getBornHost());
        msgInner.setStoreHost(msgExt.getStoreHost());
        msgInner.setReconsumeTimes(msgExt.getReconsumeTimes());
        msgInner.setWaitStoreMsgOK(false);
        if (needRoll) {
            msgInner.setTopic(msgExt.getTopic());
            msgInner.setQueueId(msgExt.getQueueId());
        } else {
            msgInner.setTopic(msgInner.getProperty("REAL_TOPIC"));
            msgInner.setQueueId(Integer.parseInt(msgInner.getProperty("REAL_QID")));
            MessageAccessor.clearProperty((Message)msgInner, (String)"REAL_TOPIC");
            MessageAccessor.clearProperty((Message)msgInner, (String)"REAL_QID");
        }
        return msgInner;
    }

    protected String getRealTopic(MessageExt msgExt) {
        if (msgExt == null) {
            return null;
        }
        return msgExt.getProperty("REAL_TOPIC");
    }

    private long formatTimeMs(long timeMs) {
        return timeMs / (long)this.precisionMs * (long)this.precisionMs;
    }

    public int hashTopicForMetrics(String topic) {
        return null == topic ? 0 : topic.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkAndReviseMetrics() {
        HashMap<String, TimerMetrics.Metric> smallOnes = new HashMap<String, TimerMetrics.Metric>();
        HashMap<String, TimerMetrics.Metric> bigOnes = new HashMap<String, TimerMetrics.Metric>();
        HashMap<Integer, String> smallHashs = new HashMap<Integer, String>();
        HashSet<Integer> smallHashCollisions = new HashSet<Integer>();
        for (Map.Entry<String, TimerMetrics.Metric> entry : this.timerMetrics.getTimingCount().entrySet()) {
            if (entry.getValue().getCount().get() < (long)this.storeConfig.getTimerMetricSmallThreshold()) {
                smallOnes.put(entry.getKey(), entry.getValue());
                int hash = this.hashTopicForMetrics(entry.getKey());
                if (smallHashs.containsKey(hash)) {
                    LOGGER.warn("[CheckAndReviseMetrics]Metric hash collision between small-small code:{} small topic:{}{} small topic:{}{}", new Object[]{hash, entry.getKey(), entry.getValue(), smallHashs.get(hash), smallOnes.get(smallHashs.get(hash))});
                    smallHashCollisions.add(hash);
                }
                smallHashs.put(hash, entry.getKey());
                continue;
            }
            bigOnes.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, TimerMetrics.Metric> entry : bigOnes.entrySet()) {
            if (!smallHashs.containsKey(this.hashTopicForMetrics(entry.getKey()))) continue;
            Iterator smallIt = smallOnes.entrySet().iterator();
            while (smallIt.hasNext()) {
                Map.Entry smallEntry = smallIt.next();
                if (this.hashTopicForMetrics((String)smallEntry.getKey()) != this.hashTopicForMetrics(entry.getKey())) continue;
                LOGGER.warn("[CheckAndReviseMetrics]Metric hash collision between small-big code:{} small topic:{}{} big topic:{}{}", new Object[]{this.hashTopicForMetrics((String)smallEntry.getKey()), smallEntry.getKey(), smallEntry.getValue(), entry.getKey(), entry.getValue()});
                smallIt.remove();
            }
        }
        smallHashs.clear();
        HashMap<String, TimerMetrics.Metric> newSmallOnes = new HashMap<String, TimerMetrics.Metric>();
        for (String topic : smallOnes.keySet()) {
            newSmallOnes.put(topic, new TimerMetrics.Metric());
            smallHashs.put(this.hashTopicForMetrics(topic), topic);
        }
        long l = this.currReadTimeMs;
        long currOffsetPy = this.timerWheel.checkPhyPos(l, 0L);
        LinkedList<SelectMappedBufferResult> sbrs = new LinkedList<SelectMappedBufferResult>();
        boolean hasError = false;
        try {
            Object timeSbr;
            while ((timeSbr = this.timerLog.getWholeBuffer(currOffsetPy)) != null) {
                sbrs.add((SelectMappedBufferResult)timeSbr);
                ByteBuffer bf = ((SelectMappedBufferResult)timeSbr).getByteBuffer();
                for (int position = 0; position < ((SelectMappedBufferResult)timeSbr).getSize(); position += 52) {
                    bf.position(position);
                    bf.getInt();
                    bf.getLong();
                    int magic = bf.getInt();
                    long enqueueTime = bf.getLong();
                    long delayedTime = (long)bf.getInt() + enqueueTime;
                    long offsetPy = bf.getLong();
                    int sizePy = bf.getInt();
                    int hashCode = bf.getInt();
                    if (delayedTime < l || !smallHashs.containsKey(hashCode)) continue;
                    String topic = null;
                    if (smallHashCollisions.contains(hashCode)) {
                        MessageExt messageExt = this.getMessageByCommitOffset(offsetPy, sizePy);
                        if (null != messageExt) {
                            topic = messageExt.getProperty("REAL_TOPIC");
                        }
                    } else {
                        topic = (String)smallHashs.get(hashCode);
                    }
                    if (null != topic && newSmallOnes.containsKey(topic)) {
                        ((TimerMetrics.Metric)newSmallOnes.get(topic)).getCount().addAndGet(this.needDelete(magic) ? -1L : 1L);
                        continue;
                    }
                    LOGGER.warn("[CheckAndReviseMetrics]Unexpected topic in checking timer metrics topic:{} code:{} offsetPy:{} size:{}", new Object[]{topic, hashCode, offsetPy, sizePy});
                }
                if (((SelectMappedBufferResult)timeSbr).getSize() < this.timerLogFileSize) {
                    break;
                }
                currOffsetPy += (long)this.timerLogFileSize;
            }
        }
        catch (Exception e) {
            hasError = true;
            LOGGER.error("[CheckAndReviseMetrics]Unknown error in checkAndReviseMetrics and abort", (Throwable)e);
        }
        finally {
            for (SelectMappedBufferResult sbr : sbrs) {
                if (null == sbr) continue;
                sbr.release();
            }
        }
        if (!hasError) {
            for (String topic : newSmallOnes.keySet()) {
                LOGGER.info("[CheckAndReviseMetrics]Revise metric for topic {} from {} to {}", new Object[]{topic, smallOnes.get(topic), newSmallOnes.get(topic)});
            }
            this.timerMetrics.getTimingCount().putAll(newSmallOnes);
        }
    }

    public String getServiceThreadName() {
        DefaultMessageStore messageStore;
        String brokerIdentifier = "";
        if (this.messageStore instanceof DefaultMessageStore && (messageStore = (DefaultMessageStore)this.messageStore).getBrokerConfig().isInBrokerContainer()) {
            brokerIdentifier = messageStore.getBrokerConfig().getIdentifier();
        }
        return brokerIdentifier;
    }

    public boolean needRoll(int magic) {
        return (magic & 2) != 0;
    }

    public boolean needDelete(int magic) {
        return (magic & 4) != 0;
    }

    public long getAllCongestNum() {
        return this.timerWheel.getAllNum(this.currReadTimeMs);
    }

    public long getCongestNum(long deliverTimeMs) {
        return this.timerWheel.getNum(deliverTimeMs);
    }

    public boolean isReject(long deliverTimeMs) {
        long congestNum = this.timerWheel.getNum(deliverTimeMs);
        if (congestNum <= (long)this.storeConfig.getTimerCongestNumEachSlot()) {
            return false;
        }
        if (congestNum >= (long)this.storeConfig.getTimerCongestNumEachSlot() * 2L) {
            return true;
        }
        return (double)RANDOM.nextInt(1000) > (double)(1000L * (congestNum - (long)this.storeConfig.getTimerCongestNumEachSlot())) / ((double)this.storeConfig.getTimerCongestNumEachSlot() + 0.1);
    }

    public long getEnqueueBehindMessages() {
        long tmpQueueOffset = this.currQueueOffset;
        ConsumeQueueInterface cq = this.messageStore.getConsumeQueue(TIMER_TOPIC, 0);
        long maxOffsetInQueue = cq == null ? 0L : cq.getMaxOffsetInQueue();
        return maxOffsetInQueue - tmpQueueOffset;
    }

    public long getEnqueueBehindMillis() {
        if (System.currentTimeMillis() - this.lastEnqueueButExpiredTime < 2000L) {
            return (System.currentTimeMillis() - this.lastEnqueueButExpiredStoreTime) / 1000L;
        }
        return 0L;
    }

    public long getEnqueueBehind() {
        return this.getEnqueueBehindMillis() / 1000L;
    }

    public long getDequeueBehindMessages() {
        return this.timerWheel.getAllNum(this.currReadTimeMs);
    }

    public long getDequeueBehindMillis() {
        return System.currentTimeMillis() - this.currReadTimeMs;
    }

    public long getDequeueBehind() {
        return this.getDequeueBehindMillis() / 1000L;
    }

    public float getEnqueueTps() {
        return this.perfCounterTicks.getCounter(ENQUEUE_PUT).getLastTps();
    }

    public float getDequeueTps() {
        return this.perfCounterTicks.getCounter(DEQUEUE_PUT).getLastTps();
    }

    public void prepareTimerCheckPoint() {
        this.timerCheckpoint.setLastTimerLogFlushPos(this.timerLog.getMappedFileQueue().getFlushedWhere());
        this.timerCheckpoint.setLastReadTimeMs(this.commitReadTimeMs);
        if (this.shouldRunningDequeue) {
            this.timerCheckpoint.setMasterTimerQueueOffset(this.commitQueueOffset);
            if (this.commitReadTimeMs != this.lastCommitReadTimeMs || this.commitQueueOffset != this.lastCommitQueueOffset) {
                this.timerCheckpoint.updateDateVersion(this.messageStore.getStateMachineVersion());
                this.lastCommitReadTimeMs = this.commitReadTimeMs;
                this.lastCommitQueueOffset = this.commitQueueOffset;
            }
        }
        this.timerCheckpoint.setLastTimerQueueOffset(Math.min(this.commitQueueOffset, this.timerCheckpoint.getMasterTimerQueueOffset()));
    }

    public void registerEscapeBridgeHook(Function<MessageExtBrokerInner, PutMessageResult> escapeBridgeHook) {
        this.escapeBridgeHook = escapeBridgeHook;
    }

    public boolean isMaster() {
        return BrokerRole.SLAVE != this.lastBrokerRole;
    }

    public long getCurrReadTimeMs() {
        return this.currReadTimeMs;
    }

    public long getQueueOffset() {
        return this.currQueueOffset;
    }

    public long getCommitQueueOffset() {
        return this.commitQueueOffset;
    }

    public long getCommitReadTimeMs() {
        return this.commitReadTimeMs;
    }

    public MessageStore getMessageStore() {
        return this.messageStore;
    }

    public TimerWheel getTimerWheel() {
        return this.timerWheel;
    }

    public TimerLog getTimerLog() {
        return this.timerLog;
    }

    public TimerMetrics getTimerMetrics() {
        return this.timerMetrics;
    }

    public int getPrecisionMs() {
        return this.precisionMs;
    }

    public TimerEnqueueGetService getEnqueueGetService() {
        return this.enqueueGetService;
    }

    public void setEnqueueGetService(TimerEnqueueGetService enqueueGetService) {
        this.enqueueGetService = enqueueGetService;
    }

    public TimerEnqueuePutService getEnqueuePutService() {
        return this.enqueuePutService;
    }

    public void setEnqueuePutService(TimerEnqueuePutService enqueuePutService) {
        this.enqueuePutService = enqueuePutService;
    }

    public TimerDequeueWarmService getDequeueWarmService() {
        return this.dequeueWarmService;
    }

    public void setDequeueWarmService(TimerDequeueWarmService dequeueWarmService) {
        this.dequeueWarmService = dequeueWarmService;
    }

    public TimerDequeueGetService getDequeueGetService() {
        return this.dequeueGetService;
    }

    public void setDequeueGetService(TimerDequeueGetService dequeueGetService) {
        this.dequeueGetService = dequeueGetService;
    }

    public TimerDequeuePutMessageService[] getDequeuePutMessageServices() {
        return this.dequeuePutMessageServices;
    }

    public void setDequeuePutMessageServices(TimerDequeuePutMessageService[] dequeuePutMessageServices) {
        this.dequeuePutMessageServices = dequeuePutMessageServices;
    }

    public TimerDequeueGetMessageService[] getDequeueGetMessageServices() {
        return this.dequeueGetMessageServices;
    }

    public void setDequeueGetMessageServices(TimerDequeueGetMessageService[] dequeueGetMessageServices) {
        this.dequeueGetMessageServices = dequeueGetMessageServices;
    }

    public void setTimerMetrics(TimerMetrics timerMetrics) {
        this.timerMetrics = timerMetrics;
    }

    public AtomicInteger getFrequency() {
        return this.frequency;
    }

    public void setFrequency(AtomicInteger frequency) {
        this.frequency = frequency;
    }

    public TimerCheckpoint getTimerCheckpoint() {
        return this.timerCheckpoint;
    }

    public class TimerFlushService
    extends ServiceThread {
        private final SimpleDateFormat sdf = new SimpleDateFormat("MM-dd HH:mm:ss");

        public String getServiceName() {
            String brokerIdentifier = "";
            if (TimerMessageStore.this.messageStore instanceof DefaultMessageStore && ((DefaultMessageStore)TimerMessageStore.this.messageStore).getBrokerConfig().isInBrokerContainer()) {
                brokerIdentifier = ((DefaultMessageStore)TimerMessageStore.this.messageStore).getBrokerConfig().getIdentifier();
            }
            return brokerIdentifier + ((Object)((Object)this)).getClass().getSimpleName();
        }

        private String format(long time) {
            return this.sdf.format(new Date(time));
        }

        public void run() {
            LOGGER.info(this.getServiceName() + " service start");
            long start = System.currentTimeMillis();
            while (!this.isStopped()) {
                try {
                    TimerMessageStore.this.prepareTimerCheckPoint();
                    TimerMessageStore.this.timerLog.getMappedFileQueue().flush(0);
                    TimerMessageStore.this.timerWheel.flush();
                    TimerMessageStore.this.timerCheckpoint.flush();
                    if (System.currentTimeMillis() - start > (long)TimerMessageStore.this.storeConfig.getTimerProgressLogIntervalMs()) {
                        start = System.currentTimeMillis();
                        long tmpQueueOffset = TimerMessageStore.this.currQueueOffset;
                        ConsumeQueueInterface cq = TimerMessageStore.this.messageStore.getConsumeQueue(TimerMessageStore.TIMER_TOPIC, 0);
                        long maxOffsetInQueue = cq == null ? 0L : cq.getMaxOffsetInQueue();
                        LOGGER.info("[{}]Timer progress-check commitRead:[{}] currRead:[{}] currWrite:[{}] readBehind:{} currReadOffset:{} offsetBehind:{} behindMaster:{} enqPutQueue:{} deqGetQueue:{} deqPutQueue:{} allCongestNum:{} enqExpiredStoreTime:{}", new Object[]{TimerMessageStore.this.storeConfig.getBrokerRole(), this.format(TimerMessageStore.this.commitReadTimeMs), this.format(TimerMessageStore.this.currReadTimeMs), this.format(TimerMessageStore.this.currWriteTimeMs), TimerMessageStore.this.getDequeueBehind(), tmpQueueOffset, maxOffsetInQueue - tmpQueueOffset, TimerMessageStore.this.timerCheckpoint.getMasterTimerQueueOffset() - tmpQueueOffset, TimerMessageStore.this.enqueuePutQueue.size(), TimerMessageStore.this.dequeueGetQueue.size(), TimerMessageStore.this.dequeuePutQueue.size(), TimerMessageStore.this.getAllCongestNum(), this.format(TimerMessageStore.this.lastEnqueueButExpiredStoreTime)});
                    }
                    TimerMessageStore.this.timerMetrics.persist();
                    this.waitForRunning(TimerMessageStore.this.storeConfig.getTimerFlushIntervalMs());
                }
                catch (Throwable e) {
                    LOGGER.error("Error occurred in " + this.getServiceName(), e);
                }
            }
            LOGGER.info(this.getServiceName() + " service end");
        }
    }

    public class TimerDequeueWarmService
    extends ServiceThread {
        public String getServiceName() {
            String brokerIdentifier = "";
            if (TimerMessageStore.this.messageStore instanceof DefaultMessageStore && ((DefaultMessageStore)TimerMessageStore.this.messageStore).getBrokerConfig().isInBrokerContainer()) {
                brokerIdentifier = ((DefaultMessageStore)TimerMessageStore.this.messageStore).getBrokerConfig().getIdentifier();
            }
            return brokerIdentifier + ((Object)((Object)this)).getClass().getSimpleName();
        }

        public void run() {
            LOGGER.info(this.getServiceName() + " service start");
            while (!this.isStopped()) {
                try {
                    this.waitForRunning(50L);
                }
                catch (Throwable e) {
                    LOGGER.error("Error occurred in " + this.getServiceName(), e);
                }
            }
            LOGGER.info(this.getServiceName() + " service end");
        }
    }

    public class TimerDequeueGetMessageService
    extends AbstractStateService {
        public String getServiceName() {
            return TimerMessageStore.this.getServiceThreadName() + ((Object)((Object)this)).getClass().getSimpleName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.setState(0);
            LOGGER.info(this.getServiceName() + " service start");
            while (!this.isStopped()) {
                try {
                    this.setState(1);
                    List<TimerRequest> trs = TimerMessageStore.this.dequeueGetQueue.poll(100L * (long)TimerMessageStore.this.precisionMs / 1000L, TimeUnit.MILLISECONDS);
                    if (null == trs || trs.size() == 0) continue;
                    this.setState(2);
                    int i = 0;
                    while (i < trs.size()) {
                        TimerRequest tr = trs.get(i);
                        boolean doRes = false;
                        try {
                            long start = System.currentTimeMillis();
                            MessageExt msgExt = TimerMessageStore.this.getMessageByCommitOffset(tr.getOffsetPy(), tr.getSizePy());
                            if (null != msgExt) {
                                if (TimerMessageStore.this.needDelete(tr.getMagic()) && !TimerMessageStore.this.needRoll(tr.getMagic())) {
                                    if (msgExt.getProperty(TimerMessageStore.TIMER_DELETE_UNIQUE_KEY) != null && tr.getDeleteList() != null) {
                                        tr.getDeleteList().add(msgExt.getProperty(TimerMessageStore.TIMER_DELETE_UNIQUE_KEY));
                                    }
                                    tr.idempotentRelease();
                                    doRes = true;
                                } else {
                                    String uniqueKey = MessageClientIDSetter.getUniqID((Message)msgExt);
                                    if (null == uniqueKey) {
                                        LOGGER.warn("No uniqueKey for msg:{}", (Object)msgExt);
                                    }
                                    if (null != uniqueKey && tr.getDeleteList() != null && tr.getDeleteList().size() > 0 && tr.getDeleteList().contains(uniqueKey)) {
                                        doRes = true;
                                        tr.idempotentRelease();
                                        TimerMessageStore.this.perfCounterTicks.getCounter("dequeue_delete").flow(1L);
                                    } else {
                                        tr.setMsg(msgExt);
                                        while (!this.isStopped() && !doRes) {
                                            doRes = TimerMessageStore.this.dequeuePutQueue.offer(tr, 3L, TimeUnit.SECONDS);
                                        }
                                    }
                                }
                                TimerMessageStore.this.perfCounterTicks.getCounter("dequeue_get_msg").flow(System.currentTimeMillis() - start);
                                continue;
                            }
                            tr.idempotentRelease();
                            doRes = true;
                            TimerMessageStore.this.perfCounterTicks.getCounter("dequeue_get_msg_miss").flow(System.currentTimeMillis() - start);
                        }
                        catch (Throwable e) {
                            LOGGER.error("Unknown exception", e);
                            if (TimerMessageStore.this.storeConfig.isTimerSkipUnknownError()) {
                                tr.idempotentRelease();
                                doRes = true;
                                continue;
                            }
                            TimerMessageStore.this.holdMomentForUnknownError();
                        }
                        finally {
                            if (!doRes) continue;
                            ++i;
                        }
                    }
                    trs.clear();
                }
                catch (Throwable e) {
                    LOGGER.error("Error occurred in " + this.getServiceName(), e);
                }
            }
            LOGGER.info(this.getServiceName() + " service end");
            this.setState(3);
        }
    }

    public class TimerDequeuePutMessageService
    extends AbstractStateService {
        public String getServiceName() {
            return TimerMessageStore.this.getServiceThreadName() + ((Object)((Object)this)).getClass().getSimpleName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.setState(0);
            LOGGER.info(this.getServiceName() + " service start");
            while (!this.isStopped() || TimerMessageStore.this.dequeuePutQueue.size() != 0) {
                try {
                    this.setState(1);
                    TimerRequest tr = TimerMessageStore.this.dequeuePutQueue.poll(10L, TimeUnit.MILLISECONDS);
                    if (null == tr) continue;
                    this.setState(2);
                    boolean doRes = false;
                    boolean tmpDequeueChangeFlag = false;
                    try {
                        while (!this.isStopped() && !doRes) {
                            if (!TimerMessageStore.this.isRunningDequeue()) {
                                TimerMessageStore.this.dequeueStatusChangeFlag = true;
                                tmpDequeueChangeFlag = true;
                                break;
                            }
                            try {
                                TimerMessageStore.this.perfCounterTicks.startTick(TimerMessageStore.DEQUEUE_PUT);
                                MessageExt msgExt = tr.getMsg();
                                DefaultStoreMetricsManager.incTimerDequeueCount(TimerMessageStore.this.getRealTopic(msgExt));
                                if (tr.getEnqueueTime() == Long.MAX_VALUE) {
                                    MessageAccessor.putProperty((Message)msgExt, (String)TimerMessageStore.TIMER_ENQUEUE_MS, (String)String.valueOf(Long.MAX_VALUE));
                                }
                                TimerMessageStore.this.addMetric(msgExt, -1);
                                MessageExtBrokerInner msg = TimerMessageStore.this.convert(msgExt, tr.getEnqueueTime(), TimerMessageStore.this.needRoll(tr.getMagic()));
                                boolean bl = doRes = 1 != TimerMessageStore.this.doPut(msg, TimerMessageStore.this.needRoll(tr.getMagic()));
                                while (!doRes && !this.isStopped()) {
                                    if (!TimerMessageStore.this.isRunningDequeue()) {
                                        TimerMessageStore.this.dequeueStatusChangeFlag = true;
                                        tmpDequeueChangeFlag = true;
                                        break;
                                    }
                                    doRes = 1 != TimerMessageStore.this.doPut(msg, TimerMessageStore.this.needRoll(tr.getMagic()));
                                    Thread.sleep(500L * (long)TimerMessageStore.this.precisionMs / 1000L);
                                }
                                TimerMessageStore.this.perfCounterTicks.endTick(TimerMessageStore.DEQUEUE_PUT);
                            }
                            catch (Throwable t) {
                                LOGGER.info("Unknown error", t);
                                if (TimerMessageStore.this.storeConfig.isTimerSkipUnknownError()) {
                                    doRes = true;
                                    continue;
                                }
                                TimerMessageStore.this.holdMomentForUnknownError();
                            }
                        }
                        tr.idempotentRelease(!tmpDequeueChangeFlag);
                    }
                    catch (Throwable throwable) {
                        tr.idempotentRelease(!tmpDequeueChangeFlag);
                        throw throwable;
                    }
                }
                catch (Throwable e) {
                    LOGGER.error("Error occurred in " + this.getServiceName(), e);
                }
            }
            LOGGER.info(this.getServiceName() + " service end");
            this.setState(3);
        }
    }

    abstract class AbstractStateService
    extends ServiceThread {
        public static final int INITIAL = -1;
        public static final int START = 0;
        public static final int WAITING = 1;
        public static final int RUNNING = 2;
        public static final int END = 3;
        protected int state = -1;

        AbstractStateService() {
        }

        protected void setState(int state) {
            this.state = state;
        }

        protected boolean isState(int state) {
            return this.state == state;
        }
    }

    public class TimerDequeueGetService
    extends ServiceThread {
        public String getServiceName() {
            return TimerMessageStore.this.getServiceThreadName() + ((Object)((Object)this)).getClass().getSimpleName();
        }

        public void run() {
            LOGGER.info(this.getServiceName() + " service start");
            while (!this.isStopped()) {
                try {
                    if (System.currentTimeMillis() < TimerMessageStore.this.shouldStartTime) {
                        LOGGER.info("TimerDequeueGetService ready to run after {}.", (Object)TimerMessageStore.this.shouldStartTime);
                        this.waitForRunning(1000L);
                        continue;
                    }
                    if (-1 != TimerMessageStore.this.dequeue()) continue;
                    this.waitForRunning(100L * (long)TimerMessageStore.this.precisionMs / 1000L);
                }
                catch (Throwable e) {
                    LOGGER.error("Error occurred in " + this.getServiceName(), e);
                }
            }
            LOGGER.info(this.getServiceName() + " service end");
        }
    }

    public class TimerEnqueuePutService
    extends ServiceThread {
        public String getServiceName() {
            return TimerMessageStore.this.getServiceThreadName() + ((Object)((Object)this)).getClass().getSimpleName();
        }

        protected List<TimerRequest> fetchTimerRequests() throws InterruptedException {
            ArrayList<TimerRequest> trs = null;
            TimerRequest firstReq = TimerMessageStore.this.enqueuePutQueue.poll(10L, TimeUnit.MILLISECONDS);
            if (null != firstReq) {
                TimerRequest tmpReq;
                trs = new ArrayList<TimerRequest>(16);
                trs.add(firstReq);
                while (null != (tmpReq = TimerMessageStore.this.enqueuePutQueue.poll(3L, TimeUnit.MILLISECONDS))) {
                    trs.add(tmpReq);
                    if (trs.size() <= 10) continue;
                    break;
                }
            }
            return trs;
        }

        protected void putMessageToTimerWheel(TimerRequest req) {
            try {
                TimerMessageStore.this.perfCounterTicks.startTick(TimerMessageStore.ENQUEUE_PUT);
                DefaultStoreMetricsManager.incTimerEnqueueCount(TimerMessageStore.this.getRealTopic(req.getMsg()));
                if (TimerMessageStore.this.shouldRunningDequeue && req.getDelayTime() < TimerMessageStore.this.currWriteTimeMs) {
                    req.setEnqueueTime(Long.MAX_VALUE);
                    TimerMessageStore.this.dequeuePutQueue.put(req);
                } else {
                    boolean doEnqueueRes = TimerMessageStore.this.doEnqueue(req.getOffsetPy(), req.getSizePy(), req.getDelayTime(), req.getMsg());
                    req.idempotentRelease(doEnqueueRes || TimerMessageStore.this.storeConfig.isTimerSkipUnknownError());
                }
                TimerMessageStore.this.perfCounterTicks.endTick(TimerMessageStore.ENQUEUE_PUT);
            }
            catch (Throwable t) {
                LOGGER.error("Unknown error", t);
                if (TimerMessageStore.this.storeConfig.isTimerSkipUnknownError()) {
                    req.idempotentRelease(true);
                }
                TimerMessageStore.this.holdMomentForUnknownError();
            }
        }

        protected void fetchAndPutTimerRequest() throws Exception {
            long tmpCommitQueueOffset = TimerMessageStore.this.currQueueOffset;
            List<TimerRequest> trs = this.fetchTimerRequests();
            if (CollectionUtils.isEmpty(trs)) {
                TimerMessageStore.this.commitQueueOffset = tmpCommitQueueOffset;
                TimerMessageStore.this.maybeMoveWriteTime();
                return;
            }
            while (!this.isStopped()) {
                CountDownLatch latch = new CountDownLatch(trs.size());
                for (TimerRequest req : trs) {
                    req.setLatch(latch);
                    this.putMessageToTimerWheel(req);
                }
                TimerMessageStore.this.checkDequeueLatch(latch, -1L);
                boolean allSuccess = trs.stream().allMatch(TimerRequest::isSucc);
                if (allSuccess) break;
                TimerMessageStore.this.holdMomentForUnknownError();
            }
            TimerMessageStore.this.commitQueueOffset = trs.get(trs.size() - 1).getMsg().getQueueOffset();
            TimerMessageStore.this.maybeMoveWriteTime();
        }

        public void run() {
            LOGGER.info(this.getServiceName() + " service start");
            while (!this.isStopped() || TimerMessageStore.this.enqueuePutQueue.size() != 0) {
                try {
                    this.fetchAndPutTimerRequest();
                }
                catch (Throwable e) {
                    LOGGER.error("Unknown error", e);
                }
            }
            LOGGER.info(this.getServiceName() + " service end");
        }
    }

    public class TimerEnqueueGetService
    extends ServiceThread {
        public String getServiceName() {
            return TimerMessageStore.this.getServiceThreadName() + ((Object)((Object)this)).getClass().getSimpleName();
        }

        public void run() {
            LOGGER.info(this.getServiceName() + " service start");
            while (!this.isStopped()) {
                try {
                    if (TimerMessageStore.this.enqueue(0)) continue;
                    this.waitForRunning(100L * (long)TimerMessageStore.this.precisionMs / 1000L);
                }
                catch (Throwable e) {
                    LOGGER.error("Error occurred in " + this.getServiceName(), e);
                }
            }
            LOGGER.info(this.getServiceName() + " service end");
        }
    }
}

