/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.remoting.protocol;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.rocketmq.remoting.protocol.RemotingSerializable;

public class DataVersion
extends RemotingSerializable {
    private long stateVersion = 0L;
    private long timestamp = System.currentTimeMillis();
    private AtomicLong counter = new AtomicLong(0L);

    public void assignNewOne(DataVersion dataVersion) {
        this.timestamp = dataVersion.timestamp;
        this.stateVersion = dataVersion.stateVersion;
        this.counter.set(dataVersion.counter.get());
    }

    public void nextVersion() {
        this.nextVersion(0L);
    }

    public void nextVersion(long stateVersion) {
        this.timestamp = System.currentTimeMillis();
        this.stateVersion = stateVersion;
        this.counter.incrementAndGet();
    }

    public long getStateVersion() {
        return this.stateVersion;
    }

    public void setStateVersion(long stateVersion) {
        this.stateVersion = stateVersion;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public AtomicLong getCounter() {
        return this.counter;
    }

    public void setCounter(AtomicLong counter) {
        this.counter = counter;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataVersion version = (DataVersion)o;
        if (this.getStateVersion() != version.getStateVersion()) {
            return false;
        }
        if (this.getTimestamp() != version.getTimestamp()) {
            return false;
        }
        if (this.counter != null && version.counter != null) {
            return this.counter.longValue() == version.counter.longValue();
        }
        return null == this.counter && null == version.counter;
    }

    public int hashCode() {
        int result = (int)(this.getStateVersion() ^ this.getStateVersion() >>> 32);
        result = 31 * result + (int)(this.getTimestamp() ^ this.getTimestamp() >>> 32);
        if (null != this.counter) {
            long l = this.counter.get();
            result = 31 * result + (int)(l ^ l >>> 32);
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DataVersion[");
        sb.append("timestamp=").append(this.timestamp);
        sb.append(", counter=").append(this.counter);
        sb.append(']');
        return sb.toString();
    }

    public int compare(DataVersion dataVersion) {
        if (this.getStateVersion() > dataVersion.getStateVersion()) {
            return 1;
        }
        if (this.getStateVersion() < dataVersion.getStateVersion()) {
            return -1;
        }
        if (this.getCounter().get() > dataVersion.getCounter().get()) {
            return 1;
        }
        if (this.getCounter().get() < dataVersion.getCounter().get()) {
            return -1;
        }
        if (this.getTimestamp() > dataVersion.getTimestamp()) {
            return 1;
        }
        if (this.getTimestamp() < dataVersion.getTimestamp()) {
            return -1;
        }
        return 0;
    }
}

