/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.auth.authentication.strategy;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.auth.authentication.context.AuthenticationContext;
import org.apache.rocketmq.auth.authentication.context.DefaultAuthenticationContext;
import org.apache.rocketmq.auth.authentication.exception.AuthenticationException;
import org.apache.rocketmq.auth.authentication.strategy.AbstractAuthenticationStrategy;
import org.apache.rocketmq.auth.config.AuthConfig;
import org.apache.rocketmq.common.Pair;

public class StatefulAuthenticationStrategy
extends AbstractAuthenticationStrategy {
    protected Cache<String, Pair<Boolean, AuthenticationException>> authCache;

    public StatefulAuthenticationStrategy(AuthConfig authConfig, Supplier<?> metadataService) {
        super(authConfig, metadataService);
        this.authCache = Caffeine.newBuilder().expireAfterWrite((long)authConfig.getStatefulAuthenticationCacheExpiredSecond(), TimeUnit.SECONDS).maximumSize((long)authConfig.getStatefulAuthenticationCacheMaxNum()).build();
    }

    @Override
    public void evaluate(AuthenticationContext context) {
        if (StringUtils.isBlank((CharSequence)context.getChannelId())) {
            this.doEvaluate(context);
            return;
        }
        Pair result = (Pair)this.authCache.get((Object)this.buildKey(context), key -> {
            try {
                this.doEvaluate(context);
                return Pair.of((Object)true, null);
            }
            catch (AuthenticationException ex) {
                return Pair.of((Object)false, (Object)ex);
            }
        });
        if (result != null && result.getObject1() == Boolean.FALSE) {
            throw (AuthenticationException)result.getObject2();
        }
    }

    private String buildKey(AuthenticationContext context) {
        if (context instanceof DefaultAuthenticationContext) {
            DefaultAuthenticationContext ctx = (DefaultAuthenticationContext)context;
            if (StringUtils.isBlank((CharSequence)ctx.getUsername())) {
                return ctx.getChannelId();
            }
            return ctx.getChannelId() + "#" + ctx.getUsername();
        }
        throw new AuthenticationException("The request of {} is not support.", context.getClass().getSimpleName());
    }
}

